/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.FileSystemImpl;
import org.apache.aries.util.filesystem.impl.NestedCloseableDirectory;
import org.apache.aries.util.filesystem.impl.NestedZipDirectory;

public class NestedZipFile
implements IFile {
    private final String name;
    private final long size;
    private final long lastModified;
    private final IDirectory parent;
    protected final IFile archive;
    private final String nameInZip;
    protected final NestedCloseableDirectory cache;

    public NestedZipFile(IFile archive, ZipEntry entry, NestedZipDirectory parent, NestedCloseableDirectory cache) {
        this.archive = archive;
        this.parent = parent;
        this.nameInZip = entry.getName();
        this.name = archive.getName() + "/" + (this.nameInZip.endsWith("/") ? this.nameInZip.substring(0, this.nameInZip.length() - 1) : this.nameInZip);
        this.size = entry.getSize();
        this.lastModified = entry.getTime();
        this.cache = cache;
    }

    public NestedZipFile(IFile archive, String pathInZip, NestedZipDirectory parent, NestedCloseableDirectory cache) {
        this.archive = archive;
        this.parent = parent;
        this.nameInZip = pathInZip;
        this.name = archive.getName() + "/" + (this.nameInZip.endsWith("/") ? this.nameInZip.substring(0, this.nameInZip.length() - 1) : this.nameInZip);
        this.size = -1L;
        this.lastModified = -1L;
        this.cache = cache;
    }

    public NestedZipFile(IFile archive) {
        this.archive = archive;
        this.parent = archive.getParent();
        this.nameInZip = "";
        this.name = archive.getName();
        this.lastModified = archive.getLastModified();
        this.size = archive.getSize();
        this.cache = null;
    }

    public NestedZipFile(NestedZipFile other, NestedCloseableDirectory cache) {
        this.name = other.name;
        this.size = other.size;
        this.lastModified = other.lastModified;
        this.parent = other.parent;
        this.archive = other.archive;
        this.nameInZip = other.nameInZip;
        this.cache = cache;
    }

    public String getNameInZip() {
        return this.nameInZip;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public IDirectory convert() {
        return null;
    }

    @Override
    public IDirectory convertNested() {
        if (this.isDirectory()) {
            return this.convert();
        }
        if (FileSystemImpl.isValidZip(this)) {
            return new NestedZipDirectory(this);
        }
        return null;
    }

    @Override
    public IDirectory getParent() {
        return this.parent;
    }

    @Override
    public InputStream open() throws IOException, UnsupportedOperationException {
        if (this.cache != null && !this.cache.isClosed()) {
            ZipFile zip = this.cache.getZipFile();
            ZipEntry ze = zip.getEntry(this.nameInZip);
            if (ze != null) {
                return zip.getInputStream(ze);
            }
            return null;
        }
        ZipInputStream zis = new ZipInputStream(this.archive.open());
        ZipEntry entry = zis.getNextEntry();
        while (entry != null && !entry.getName().equals(this.nameInZip)) {
            entry = zis.getNextEntry();
        }
        if (entry != null) {
            return zis;
        }
        zis.close();
        return null;
    }

    @Override
    public IDirectory getRoot() {
        return this.archive.getRoot();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        if (this.nameInZip.length() == 0) {
            return this.archive.toURL();
        }
        String entryURL = "jar:" + this.archive.toURL() + "!/" + this.nameInZip;
        return new URL(entryURL);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.nameInZip.length() == 0) {
            return this.archive.toString();
        }
        return this.archive.toString() + "/" + this.nameInZip;
    }
}

