/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.NestedCloseableDirectory;
import org.apache.aries.util.filesystem.impl.NestedZipFile;
import org.apache.aries.util.filesystem.impl.ZipDirectory;
import org.apache.aries.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedZipDirectory
extends NestedZipFile
implements IDirectory {
    private static final Logger logger = LoggerFactory.getLogger((String)NestedZipDirectory.class.getName());

    public NestedZipDirectory(IFile archive, ZipEntry entry, NestedZipDirectory parent, NestedCloseableDirectory cache) {
        super(archive, entry, parent, cache);
    }

    public NestedZipDirectory(IFile archive, String pathInZip, NestedZipDirectory parent, NestedCloseableDirectory cache) {
        super(archive, pathInZip, parent, cache);
    }

    public NestedZipDirectory(IFile archive) {
        super(archive);
    }

    public NestedZipDirectory(NestedZipDirectory other, NestedCloseableDirectory cache) {
        super(other, cache);
    }

    @Override
    public IDirectory convert() {
        return this;
    }

    @Override
    public Iterator<IFile> iterator() {
        return this.listFiles().iterator();
    }

    @Override
    public List<IFile> listFiles() {
        return this.listFiles(false);
    }

    @Override
    public List<IFile> listAllFiles() {
        return this.listFiles(true);
    }

    private List<IFile> listFiles(boolean includeFilesInNestedSubdirs) {
        LinkedHashMap<String, ZipEntry> entriesByName = new LinkedHashMap<String, ZipEntry>();
        for (ZipEntry zipEntry : this.getAllEntries()) {
            if (!ZipDirectory.isInDir(this.getNameInZip(), zipEntry, includeFilesInNestedSubdirs)) continue;
            entriesByName.put(zipEntry.getName(), zipEntry);
        }
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (ZipEntry ze : entriesByName.values()) {
            NestedZipDirectory parent;
            NestedZipDirectory nestedZipDirectory = parent = includeFilesInNestedSubdirs ? this.buildParent(ze, entriesByName) : this;
            if (ze.isDirectory()) {
                files.add(new NestedZipDirectory(this.archive, ze, parent, this.cache));
                continue;
            }
            files.add(new NestedZipFile(this.archive, ze, parent, this.cache));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends ZipEntry> getAllEntries() {
        ArrayList<ZipEntry> arrayList;
        if (this.cache != null && !this.cache.isClosed()) {
            return Collections.list(this.cache.getZipFile().entries());
        }
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(this.archive.open());
            ArrayList<ZipEntry> result = new ArrayList<ZipEntry>();
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                result.add(entry);
                entry = zis.getNextEntry();
            }
            arrayList = result;
        }
        catch (IOException e) {
            List list;
            try {
                logger.error("IOException reading nested ZipFile", (Throwable)e);
                list = Collections.emptyList();
            }
            catch (Throwable throwable) {
                IOUtils.close(zis);
                throw throwable;
            }
            IOUtils.close(zis);
            return list;
        }
        IOUtils.close(zis);
        return arrayList;
    }

    private NestedZipDirectory buildParent(ZipEntry entry, Map<String, ZipEntry> entries) {
        NestedZipDirectory result = this;
        String path = entry.getName().substring(this.getNameInZip().length());
        String[] segments = path.split("/");
        if (segments != null && segments.length > 1) {
            StringBuilder entryPath = new StringBuilder(this.getNameInZip());
            for (int i = 0; i < segments.length - 1; ++i) {
                String p = segments[i];
                entryPath.append(p).append("/");
                ZipEntry ze = entries.get(entryPath.toString());
                result = ze != null ? new NestedZipDirectory(this.archive, ze, result, this.cache) : new NestedZipDirectory(this.archive, entryPath.toString(), result, this.cache);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public IFile getFile(String name) {
        ZipEntry ze;
        HashMap<String, ZipEntry> entries;
        block11: {
            ZipInputStream zis;
            entries = new HashMap<String, ZipEntry>();
            if (this.cache != null && !this.cache.isClosed()) {
                ZipFile zip = this.cache.getZipFile();
                String[] segments = name.split("/");
                StringBuilder path = new StringBuilder();
                for (String s : segments) {
                    path.append(s).append('/');
                    ZipEntry p = zip.getEntry(path.toString());
                    if (p == null) continue;
                    entries.put(path.toString(), p);
                }
                ze = zip.getEntry(name);
            } else {
                zis = null;
                zis = new ZipInputStream(this.archive.open());
                ze = zis.getNextEntry();
                while (ze != null && !ze.getName().equals(name)) {
                    if (name.startsWith(ze.getName())) {
                        entries.put(ze.getName(), ze);
                    }
                    ze = zis.getNextEntry();
                }
                IOUtils.close(zis);
            }
            break block11;
            catch (IOException e) {
                IFile iFile;
                try {
                    logger.error("IOException reading nested ZipFile", (Throwable)e);
                    iFile = null;
                }
                catch (Throwable throwable) {
                    IOUtils.close(zis);
                    throw throwable;
                }
                IOUtils.close(zis);
                return iFile;
            }
        }
        if (ze != null) {
            NestedZipDirectory parent = this.buildParent(ze, entries);
            if (ze.isDirectory()) {
                return new NestedZipDirectory(this.archive, ze, parent, this.cache);
            }
            return new NestedZipFile(this.archive, ze, parent, this.cache);
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public InputStream open() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ICloseableDirectory toCloseable() {
        try {
            return new NestedCloseableDirectory(this.archive, this);
        }
        catch (IOException e) {
            logger.error("Exception while creating extracted version of nested zip file", (Throwable)e);
            return null;
        }
    }
}

