/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.DirectoryImpl;
import org.apache.aries.util.filesystem.impl.InputStreamClosableDirectory;
import org.apache.aries.util.filesystem.impl.ZipDirectory;
import org.apache.aries.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemImpl {
    private static final Logger _logger = LoggerFactory.getLogger((String)FileSystemImpl.class.getName());

    public static IDirectory getFSRoot(File fs, IDirectory parent) {
        IDirectory dir = null;
        if (fs.exists()) {
            if (fs.isDirectory()) {
                dir = new DirectoryImpl(fs, fs);
            } else if (fs.isFile() && FileSystemImpl.isValidZip(fs)) {
                try {
                    dir = new ZipDirectory(fs, parent);
                }
                catch (IOException e) {
                    _logger.error("IOException in IDirectory.getFSRoot", (Throwable)e);
                }
            }
        } else {
            _logger.error("File not found in IDirectory.getFSRoot", (Throwable)new FileNotFoundException(fs.getPath()));
        }
        return dir;
    }

    public static boolean isValidZip(File zip) {
        try {
            ZipFile zf = new ZipFile(zip);
            zf.close();
            return true;
        }
        catch (IOException e) {
            _logger.debug("Not a valid zip: " + zip);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidZip(IFile zip) {
        boolean bl;
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(zip.open());
            bl = zis.getNextEntry() != null;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                _logger.debug("Not a valid zip: " + zip);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.close(zis);
                throw throwable;
            }
            IOUtils.close(zis);
            return bl2;
        }
        IOUtils.close(zis);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICloseableDirectory getFSRoot(InputStream is) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("inputStreamExtract", ".zip");
        }
        catch (IOException e1) {
            _logger.error("IOException in IDirectory.getFSRoot", (Throwable)e1);
            return null;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempFile);
            IOUtils.copy(is, fos);
        }
        catch (IOException e) {
            ICloseableDirectory iCloseableDirectory;
            try {
                iCloseableDirectory = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(fos);
                throw throwable;
            }
            IOUtils.close(fos);
            return iCloseableDirectory;
        }
        IOUtils.close(fos);
        IDirectory dir = FileSystemImpl.getFSRoot(tempFile, null);
        if (dir == null) {
            return null;
        }
        return new InputStreamClosableDirectory(dir, tempFile);
    }
}

