/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.DirectoryImpl;
import org.apache.aries.util.filesystem.impl.FileSystemImpl;

public class FileImpl
implements IFile {
    protected String rootDir;
    protected File file;
    protected File rootDirFile;
    private String name;

    public FileImpl(File f, File rootFile) {
        this.file = f;
        this.rootDirFile = rootFile;
        this.rootDir = rootFile.getAbsolutePath();
        this.name = f.equals(rootFile) ? "" : this.file.getAbsolutePath().substring(this.rootDir.length() + 1).replace('\\', '/');
    }

    public IDirectory convert() {
        return null;
    }

    public long getLastModified() {
        long result = this.file.lastModified();
        return result;
    }

    public String getName() {
        return this.name;
    }

    public IDirectory getParent() {
        DirectoryImpl parent = new DirectoryImpl(this.file.getParentFile(), this.rootDirFile);
        return parent;
    }

    public long getSize() {
        long size = this.file.length();
        return size;
    }

    public boolean isDirectory() {
        boolean result = this.file.isDirectory();
        return result;
    }

    public boolean isFile() {
        boolean result = this.file.isFile();
        return result;
    }

    public InputStream open() throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        return is;
    }

    public IDirectory getRoot() {
        DirectoryImpl root = new DirectoryImpl(this.rootDirFile, this.rootDirFile);
        return root;
    }

    public URL toURL() throws MalformedURLException {
        URL result = this.file.toURI().toURL();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            return this.file.equals(((FileImpl)obj).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public IDirectory convertNested() {
        if (this.isDirectory()) {
            return this.convert();
        }
        return FileSystemImpl.getFSRoot(this.file, this.getParent());
    }
}

