/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin.handlers.paxcdi;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class ServiceProperty {
    final String name;
    private final String type;
    private final boolean isArray;
    private final List<String> values;

    ServiceProperty(String name, String value) {
        if (ServiceProperty.hasTypeSignature(name)) {
            String[] splitName = name.split(":");
            this.name = splitName[0];
            this.type = ServiceProperty.getType(splitName[1]);
            this.isArray = splitName[1].endsWith("[]");
            this.values = this.isArray ? Arrays.asList(value.split("\\|")) : Arrays.asList(value);
        } else {
            this.name = name;
            this.type = null;
            this.isArray = false;
            this.values = Arrays.asList(value);
        }
    }

    private static boolean hasTypeSignature(String name) {
        return name.contains(":");
    }

    private static String getType(String typeSignature) {
        String rawType = typeSignature.endsWith("[]") ? typeSignature.substring(0, typeSignature.length() - 2) : typeSignature;
        if ("".equals(rawType)) {
            return null;
        }
        if (rawType.contains(".")) {
            return rawType;
        }
        return "java.lang." + rawType;
    }

    void write(XMLStreamWriter writer) throws XMLStreamException {
        if (this.type == null && !this.isArray) {
            writer.writeEmptyElement("entry");
            writer.writeAttribute("key", this.name);
            writer.writeAttribute("value", this.values.get(0));
        } else {
            writer.writeStartElement("entry");
            writer.writeAttribute("key", this.name);
            if (this.isArray) {
                writer.writeStartElement("array");
                if (this.type != null) {
                    writer.writeAttribute("value-type", this.type);
                }
                for (String value : this.values) {
                    writer.writeStartElement("value");
                    writer.writeCharacters(value);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            } else {
                writer.writeStartElement("value");
                writer.writeAttribute("type", this.type);
                writer.writeCharacters(this.values.get(0));
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    String getSingleValue() {
        if (this.values.size() > 1) {
            throw new IllegalArgumentException("Property has more than one value");
        }
        return this.values.get(0);
    }
}

