/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.JspWriter;
import org.apache.jasper.runtime.JspWriterImpl;
import org.glassfish.jsp.api.ByteWriter;

public class ServletResponseWrapperInclude
extends HttpServletResponseWrapper {
    private PrintWriter printWriter;
    private JspWriter jspWriter;
    private boolean canFlushWriter;

    public ServletResponseWrapperInclude(ServletResponse response, JspWriter jspWriter) {
        super((HttpServletResponse)response);
        this.jspWriter = jspWriter;
        this.printWriter = jspWriter instanceof JspWriterImpl && ((JspWriterImpl)jspWriter).shouldOutputBytes() ? new PrintWriterWrapper((JspWriterImpl)jspWriter) : new PrintWriter(jspWriter);
        this.canFlushWriter = jspWriter instanceof JspWriterImpl;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return this.printWriter;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        throw new IllegalStateException();
    }

    @Override
    public void resetBuffer() {
        try {
            this.jspWriter.clearBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        this.printWriter.flush();
    }

    public boolean canFlush() {
        return this.canFlushWriter;
    }

    public boolean hasData() {
        return !this.canFlushWriter || ((JspWriterImpl)this.jspWriter).hasData();
    }

    private static class PrintWriterWrapper
    extends PrintWriter
    implements ByteWriter {
        private JspWriterImpl jspWriter;

        PrintWriterWrapper(JspWriterImpl jspWriter) {
            super(jspWriter);
            this.jspWriter = jspWriter;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.jspWriter.write(buff, off, len);
        }
    }
}

