/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.servlet.conneg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.any23.servlet.conneg.ContentTypeNegotiator;
import org.apache.any23.servlet.conneg.MediaRangeSpec;

public class ContentTypeNegotiator {
    private List<VariantSpec> variantSpecs = new ArrayList();
    private List<MediaRangeSpec> defaultAcceptRanges = Collections.singletonList(MediaRangeSpec.parseRange((String)"*/*"));
    private Collection<AcceptHeaderOverride> userAgentOverrides = new ArrayList();

    protected ContentTypeNegotiator() {
    }

    public MediaRangeSpec getBestMatch(String accept) {
        return this.getBestMatch(accept, null);
    }

    public MediaRangeSpec getBestMatch(String accept, String userAgent) {
        if (userAgent == null) {
            userAgent = "";
        }
        Iterator it = this.userAgentOverrides.iterator();
        String overriddenAccept = accept;
        while (it.hasNext()) {
            AcceptHeaderOverride override = (AcceptHeaderOverride)it.next();
            if (!override.matches(accept, userAgent)) continue;
            overriddenAccept = override.getReplacement();
        }
        return new Negotiation(this, this.toAcceptRanges(overriddenAccept)).negotiate();
    }

    protected VariantSpec addVariant(String mediaType) {
        VariantSpec result = new VariantSpec(this, mediaType);
        this.variantSpecs.add(result);
        return result;
    }

    protected void setDefaultAccept(String accept) {
        this.defaultAcceptRanges = MediaRangeSpec.parseAccept((String)accept);
    }

    protected void addUserAgentOverride(Pattern userAgentString, String originalAcceptHeader, String newAcceptHeader) {
        this.userAgentOverrides.add(new AcceptHeaderOverride(this, userAgentString, originalAcceptHeader, newAcceptHeader));
    }

    private List<MediaRangeSpec> toAcceptRanges(String accept) {
        if (accept == null) {
            return this.defaultAcceptRanges;
        }
        List result = MediaRangeSpec.parseAccept((String)accept);
        if (result.isEmpty()) {
            return this.defaultAcceptRanges;
        }
        return result;
    }

    static /* synthetic */ List access$000(ContentTypeNegotiator x0) {
        return x0.variantSpecs;
    }
}

