/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.mime;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.any23.mime.MIMEType;
import org.apache.any23.mime.MIMETypeDetector;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;

public class NaiveMIMETypeDetector
implements MIMETypeDetector {
    private static final Map<String, String> extensions = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("html", "text/html");
            this.put("htm", "text/html");
            this.put("xhtml", "application/xhtml+xml");
            this.put("xht", "application/xhtml+xml");
            this.put("xrdf", "application/rdf+xml");
            this.put("rdfx", "application/rdf+xml");
            this.put("owl", "application/rdf+xml");
            this.put("txt", "text/plain");
        }
    };
    private static final Pattern extensionRegex = Pattern.compile(".*\\.([a-z0-9]+)");

    public MIMEType guessMIMEType(String fileName, InputStream input, MIMEType mimeTypeFromMetadata) {
        if (mimeTypeFromMetadata != null) {
            return mimeTypeFromMetadata;
        }
        Optional parserFormatForFileName = Rio.getParserFormatForFileName((String)fileName);
        if (parserFormatForFileName.isPresent()) {
            return MIMEType.parse((String)((RDFFormat)parserFormatForFileName.get()).getDefaultMIMEType());
        }
        String extension = this.getExtension(fileName);
        if (extension == null) {
            extension = "html";
        }
        if (extensions.containsKey(extension)) {
            return MIMEType.parse((String)extensions.get(extension));
        }
        return null;
    }

    private String getExtension(String filename) {
        Matcher m = extensionRegex.matcher(filename);
        if (!m.matches()) {
            return null;
        }
        return m.group(1);
    }
}

