/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.any23.configuration.DefaultConfiguration;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVReaderBuilder {
    private static final String DEFAULT_FIELD_DELIMITER = ",";
    private static final String DEFAULT_COMMENT_DELIMITER = "#";
    private static final char[] popularDelimiters = new char[]{'\t', '|', ',', ';'};
    private static DefaultConfiguration defaultConfiguration = DefaultConfiguration.singleton();
    private static final CSVFormat[] strategies = new CSVFormat[popularDelimiters.length + 1];

    public static CSVParser build(InputStream is) throws IOException {
        CSVFormat bestStrategy = CSVReaderBuilder.getBestStrategy(is);
        if (bestStrategy == null) {
            bestStrategy = CSVReaderBuilder.getCSVStrategyFromConfiguration();
        }
        return new CSVParser((Reader)new InputStreamReader(is), bestStrategy);
    }

    public static boolean isCSV(InputStream is) throws IOException {
        return CSVReaderBuilder.getBestStrategy(is) != null;
    }

    private static CSVFormat getBestStrategy(InputStream is) throws IOException {
        for (CSVFormat strategy : strategies) {
            if (!CSVReaderBuilder.testStrategy(is, strategy)) continue;
            return strategy;
        }
        return null;
    }

    private static CSVFormat getCSVStrategyFromConfiguration() {
        char fieldDelimiter = CSVReaderBuilder.getCharValueFromConfiguration("any23.extraction.csv.field", DEFAULT_FIELD_DELIMITER);
        char commentDelimiter = CSVReaderBuilder.getCharValueFromConfiguration("any23.extraction.csv.comment", DEFAULT_COMMENT_DELIMITER);
        return CSVFormat.DEFAULT.withDelimiter(fieldDelimiter).withCommentMarker(commentDelimiter);
    }

    private static char getCharValueFromConfiguration(String property, String defaultValue) {
        String delimiter = defaultConfiguration.getProperty(property, defaultValue);
        if (delimiter.length() != 1) {
            throw new RuntimeException(property + " value must be a single character");
        }
        return delimiter.charAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testStrategy(InputStream is, CSVFormat strategy) throws IOException {
        int MIN_COLUMNS = 2;
        is.mark(Integer.MAX_VALUE);
        try {
            Iterator rows = new CSVParser((Reader)new InputStreamReader(is), strategy).iterator();
            int headerColumnCount = -1;
            for (int linesToCheck = 5; linesToCheck > 0 && rows.hasNext(); --linesToCheck) {
                int rowLength = ((CSVRecord)rows.next()).size();
                if (rowLength < 2) {
                    boolean bl = false;
                    return bl;
                }
                if (headerColumnCount == -1) {
                    headerColumnCount = rowLength;
                    continue;
                }
                if (rowLength < headerColumnCount) {
                    boolean bl = false;
                    return bl;
                }
                if (rowLength - 1 <= headerColumnCount) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            is.reset();
        }
    }

    static {
        CSVReaderBuilder.strategies[0] = CSVFormat.DEFAULT;
        int index = 1;
        for (char dlmt : popularDelimiters) {
            CSVReaderBuilder.strategies[index++] = CSVFormat.DEFAULT.withDelimiter(dlmt);
        }
    }
}

