/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.writer;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.any23.configuration.Settings;
import org.apache.any23.writer.BaseWriterFactory;
import org.apache.any23.writer.DecoratingWriterFactory;
import org.apache.any23.writer.FormatWriter;
import org.apache.any23.writer.TripleFormat;
import org.apache.any23.writer.TripleHandler;
import org.apache.any23.writer.TripleWriterFactory;
import org.apache.any23.writer.WriterFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterFactoryRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WriterFactoryRegistry.class);
    private static final WriterFactory[] EMPTY_WRITERS = new WriterFactory[0];
    private final List<WriterFactory> writers = new CopyOnWriteArrayList<WriterFactory>();
    private final Map<String, List<WriterFactory>> mimeToWriter = Collections.synchronizedMap(new HashMap());
    private final Map<String, WriterFactory> idToWriter = new HashMap<String, WriterFactory>();
    private final List<String> identifiers = new CopyOnWriteArrayList<String>();
    private final Collection<String> mimeTypes = new CopyOnWriteArraySet<String>();

    public WriterFactoryRegistry() {
        ServiceLoader<WriterFactory> serviceLoader = ServiceLoader.load(WriterFactory.class, this.getClass().getClassLoader());
        Iterator<WriterFactory> iterator = serviceLoader.iterator();
        ArrayList<WriterFactory> factories = new ArrayList<WriterFactory>();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    factories.add(iterator.next());
                }
            }
            catch (ServiceConfigurationError error) {
                LOG.error("Found error loading a WriterFactory", (Throwable)error);
                continue;
            }
            break;
        }
        this.registerAll(factories.toArray(EMPTY_WRITERS));
    }

    public static String getIdentifier(WriterFactory writerClass) {
        return writerClass.getIdentifier();
    }

    public static String getMimeType(WriterFactory writerClass) {
        if (writerClass instanceof TripleWriterFactory) {
            return ((TripleWriterFactory)writerClass).getTripleFormat().getMimeType();
        }
        if (writerClass instanceof DecoratingWriterFactory) {
            return null;
        }
        return WriterFactoryRegistry.reportAndGetCompatFormat(writerClass).getMimeType();
    }

    public static WriterFactoryRegistry getInstance() {
        return InstanceHolder.instance;
    }

    private static TripleFormat reportAndGetCompatFormat(WriterFactory f) {
        RDFFormat fmt;
        LOG.warn("{} must implement either {} or {}.", new Object[]{f.getClass(), TripleWriterFactory.class, DecoratingWriterFactory.class});
        String mimeType = f.getMimeType();
        try {
            fmt = f.getRdfFormat();
        }
        catch (RuntimeException e) {
            return TripleFormat.of(mimeType, Collections.singleton(mimeType), null, Collections.emptySet(), null, TripleFormat.NONSTANDARD);
        }
        if (mimeType == null || fmt.hasDefaultMIMEType(mimeType)) {
            return TripleFormat.of(fmt);
        }
        return TripleFormat.of(fmt.getName(), Collections.singleton(mimeType), fmt.getCharset(), fmt.getFileExtensions(), fmt.getStandardURI().stringValue(), TripleFormat.capabilities(fmt));
    }

    private static TripleWriterFactory getCompatFactory(final WriterFactory f) {
        final TripleFormat format = WriterFactoryRegistry.reportAndGetCompatFormat(f);
        return new TripleWriterFactory(){

            @Override
            public TripleFormat getTripleFormat() {
                return format;
            }

            @Override
            public TripleHandler getTripleWriter(OutputStream os, Settings settings) {
                return f.getRdfWriter(os);
            }

            @Override
            public Settings getSupportedSettings() {
                return Settings.of();
            }

            @Override
            public String getIdentifier() {
                return f.getIdentifier();
            }
        };
    }

    public void register(WriterFactory f) {
        if (f == null) {
            throw new NullPointerException("writerClass cannot be null.");
        }
        this.registerAll(new WriterFactory[]{f});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void registerAll(WriterFactory[] factories) {
        int count = factories.length;
        if (count == 0) {
            return;
        }
        HashMap<String, ArrayList> mimes = new HashMap<String, ArrayList>();
        String[] ids = new String[count];
        for (int i = 0; i < count; ++i) {
            String id;
            WriterFactory f = factories[i];
            if (!(f instanceof BaseWriterFactory)) {
                f = factories[i] = WriterFactoryRegistry.getCompatFactory(f);
            }
            if ((id = (ids[i] = f.getIdentifier())) == null || id.trim().isEmpty()) {
                throw new IllegalArgumentException("Invalid identifier returned by writer " + f);
            }
            if (!(f instanceof TripleWriterFactory)) continue;
            String mimeType = ((TripleWriterFactory)f).getTripleFormat().getMimeType();
            if (mimeType == null || mimeType.trim().isEmpty()) {
                throw new IllegalArgumentException("Invalid MIME type returned by writer " + f);
            }
            mimes.computeIfAbsent(mimeType, k -> new ArrayList()).add(f);
        }
        List<String> idList = Arrays.asList(ids);
        List<WriterFactory> factoryList = Arrays.asList(factories);
        Map<String, WriterFactory> idToWriter = this.idToWriter;
        Map<String, WriterFactory> map = idToWriter;
        synchronized (idToWriter) {
            void var9_11;
            boolean bl = false;
            while (var9_11 < count) {
                String id = ids[var9_11];
                if (idToWriter.putIfAbsent(id, factories[var9_11]) != null) {
                    idToWriter.keySet().removeAll(idList.subList(0, (int)var9_11));
                    throw new IllegalArgumentException("The writer identifier is already declared: " + id);
                }
                ++var9_11;
            }
            // ** MonitorExit[map] (shouldn't be in output)
            this.writers.addAll(factoryList);
            this.identifiers.addAll(idList);
            for (Map.Entry entry : mimes.entrySet()) {
                String mimeType = (String)entry.getKey();
                this.mimeTypes.add(mimeType);
                this.mimeToWriter.computeIfAbsent(mimeType, k -> new CopyOnWriteArrayList()).addAll((Collection)entry.getValue());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIdentifier(String id) {
        Map<String, WriterFactory> map = this.idToWriter;
        synchronized (map) {
            return this.idToWriter.containsKey(id);
        }
    }

    public List<String> getIdentifiers() {
        return Collections.unmodifiableList(this.identifiers);
    }

    public Collection<String> getMimeTypes() {
        return Collections.unmodifiableCollection(this.mimeTypes);
    }

    public List<WriterFactory> getWriters() {
        return Collections.unmodifiableList(this.writers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriterFactory getWriterByIdentifier(String id) {
        Map<String, WriterFactory> map = this.idToWriter;
        synchronized (map) {
            return this.idToWriter.get(id);
        }
    }

    public Collection<WriterFactory> getWritersByMimeType(String mimeType) {
        List<WriterFactory> list = this.mimeToWriter.get(mimeType);
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    @Deprecated
    public FormatWriter getWriterInstanceByIdentifier(String id, OutputStream os) {
        return Objects.requireNonNull(this.getWriterByIdentifier(id), "Cannot find writer with id " + id).getRdfWriter(os);
    }

    private static class InstanceHolder {
        private static final WriterFactoryRegistry instance = new WriterFactoryRegistry();

        private InstanceHolder() {
        }
    }
}

