/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.extractor;

import java.util.HashMap;
import java.util.Map;
import org.apache.any23.configuration.Configuration;
import org.apache.any23.configuration.DefaultConfiguration;

public class ExtractionParameters {
    private final Configuration configuration;
    private final ValidationMode extractionMode;
    private final Map<String, Boolean> extractionFlags;
    private final Map<String, String> extractionProperties;
    public static final String METADATA_DOMAIN_PER_ENTITY_FLAG = "any23.extraction.metadata.domain.per.entity";
    public static final String METADATA_NESTING_FLAG = "any23.extraction.metadata.nesting";
    public static final String METADATA_TIMESIZE_FLAG = "any23.extraction.metadata.timesize";
    public static final String EXTRACTION_CONTEXT_IRI_PROPERTY = "any23.extraction.context.iri";

    public ExtractionParameters(Configuration configuration, ValidationMode extractionMode, Map<String, Boolean> extractionFlags, Map<String, String> extractionProperties) {
        if (configuration == null) {
            throw new NullPointerException("Configuration cannot be null.");
        }
        if (extractionMode == null) {
            throw new NullPointerException("Extraction mode cannot be null.");
        }
        this.configuration = configuration;
        this.extractionMode = extractionMode;
        this.extractionFlags = extractionFlags == null ? new HashMap<String, Boolean>() : new HashMap<String, Boolean>(extractionFlags);
        this.extractionProperties = extractionProperties == null ? new HashMap<String, String>() : new HashMap<String, String>(extractionProperties);
    }

    public ExtractionParameters(Configuration configuration, ValidationMode extractionMode) {
        this(configuration, extractionMode, null, null);
    }

    public ExtractionParameters(Configuration configuration, ValidationMode extractionMode, final boolean nesting) {
        this(configuration, extractionMode, (Map<String, Boolean>)new HashMap<String, Boolean>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(ExtractionParameters.METADATA_NESTING_FLAG, nesting);
            }
        }, null);
    }

    public static final ExtractionParameters newDefault(Configuration c) {
        return new ExtractionParameters(c, ValidationMode.NONE);
    }

    public static final ExtractionParameters newDefault() {
        return new ExtractionParameters(DefaultConfiguration.singleton(), ValidationMode.NONE);
    }

    public boolean isValidate() {
        return this.extractionMode == ValidationMode.VALIDATE || this.extractionMode == ValidationMode.VALIDATE_AND_FIX;
    }

    public boolean isFix() {
        return this.extractionMode == ValidationMode.VALIDATE_AND_FIX;
    }

    public boolean getFlag(String flagName) {
        Boolean value = this.extractionFlags.get(flagName);
        if (value == null) {
            return this.configuration.getFlagProperty(flagName);
        }
        return value;
    }

    public Boolean setFlag(String flagName, boolean value) {
        this.checkPropertyExists(flagName);
        this.validateValue("flag name", flagName);
        return this.extractionFlags.put(flagName, value);
    }

    public String getProperty(String propertyName) {
        String propertyValue = this.extractionProperties.get(propertyName);
        if (propertyValue == null) {
            return this.configuration.getPropertyOrFail(propertyName);
        }
        return propertyValue;
    }

    public String setProperty(String propertyName, String propertyValue) {
        this.checkPropertyExists(propertyName);
        this.validateValue("property name", propertyName);
        this.validateValue("property value", propertyValue);
        return this.extractionProperties.put(propertyName, propertyValue);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ExtractionParameters) {
            ExtractionParameters other = (ExtractionParameters)obj;
            return this.extractionMode == other.extractionMode && this.extractionFlags.equals(other.extractionFlags) && this.extractionProperties.equals(other.extractionProperties);
        }
        return false;
    }

    public int hashCode() {
        return this.extractionMode.hashCode() * 2 * this.extractionFlags.hashCode() * 3 * this.extractionProperties.hashCode() * 5;
    }

    private void checkPropertyExists(String propertyName) {
        if (!this.configuration.defineProperty(propertyName)) {
            throw new IllegalArgumentException(String.format("Property '%s' is unknown and cannot be set.", propertyName));
        }
    }

    private void validateValue(String desc, String value) {
        if (value == null || value.trim().length() == 0) {
            throw new IllegalArgumentException(String.format("Invalid %s: '%s'", desc, value));
        }
    }

    public static enum ValidationMode {
        NONE,
        VALIDATE,
        VALIDATE_AND_FIX;

    }
}

