/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.mime;

public class MIMEType
implements Comparable<MIMEType> {
    private static final String MSG = "Cannot parse MIME type (expected type/subtype[;q=x.y] format): ";
    private final String type;
    private final String subtype;
    private final double q;

    public static MIMEType parse(String mimeType) {
        String type;
        int i2;
        if (mimeType == null) {
            return null;
        }
        int i = mimeType.indexOf(59);
        double q = 1.0;
        if (i > -1) {
            String[] params;
            for (String param : params = mimeType.substring(i + 1).split(";")) {
                int i22 = param.indexOf(61);
                if (i22 == -1 || !"q".equals(param.substring(0, i22).trim().toLowerCase())) continue;
                String value = param.substring(i22 + 1);
                try {
                    q = Double.parseDouble(value);
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (!(q <= 0.0) && !(q >= 1.0)) continue;
                q = 1.0;
            }
        } else {
            i = mimeType.length();
        }
        if ((i2 = (type = mimeType.substring(0, i)).indexOf(47)) == -1) {
            throw new IllegalArgumentException(MSG + mimeType);
        }
        String p1 = type.substring(0, i2).trim().toLowerCase();
        String p2 = type.substring(i2 + 1).trim().toLowerCase();
        if ("*".equals(p1)) {
            if (!"*".equals(p2)) {
                throw new IllegalArgumentException(MSG + mimeType);
            }
            return new MIMEType(null, null, q);
        }
        if ("*".equals(p2)) {
            return new MIMEType(p1, null, q);
        }
        return new MIMEType(p1, p2, q);
    }

    private MIMEType(String type, String subtype, double q) {
        this.type = type;
        this.subtype = subtype;
        this.q = q;
    }

    public String getMajorType() {
        return this.type == null ? "*" : this.type;
    }

    public String getSubtype() {
        return this.subtype == null ? "*" : this.subtype;
    }

    public String getFullType() {
        return this.getMajorType() + "/" + this.getSubtype();
    }

    public double getQuality() {
        return this.q;
    }

    public boolean isAnyMajorType() {
        return this.type == null;
    }

    public boolean isAnySubtype() {
        return this.subtype == null;
    }

    public String toString() {
        if (this.q == 1.0) {
            return this.getFullType();
        }
        return this.getFullType() + ";q=" + this.q;
    }

    @Override
    public int compareTo(MIMEType other) {
        return this.getFullType().compareTo(other.getFullType());
    }
}

