/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.rs.validator;

import javax.servlet.http.HttpServletRequest;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.utils.OAuthUtils;
import org.apache.amber.oauth2.common.validators.AbstractValidator;
import org.apache.amber.oauth2.rs.ResourceServer;

public class BearerQueryOAuthValidator
extends AbstractValidator {
    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
    }

    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
    }

    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        String[] tokens = ResourceServer.getQueryParameterValues(request, "access_token");
        if (OAuthUtils.hasEmptyValues((String[])tokens) && OAuthUtils.hasEmptyValues((String[])(tokens = ResourceServer.getQueryParameterValues(request, "oauth_token")))) {
            throw OAuthProblemException.error(null, (String)"Missing OAuth token.");
        }
        if (tokens != null && tokens.length > 1) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"Multiple tokens attached.");
        }
        String oauthVersionDiff = ResourceServer.getQueryParameterValue(request, "oauth_signature_method");
        if (!OAuthUtils.isEmpty((String)oauthVersionDiff)) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"Incorrect OAuth version. Found OAuth V1.0.");
        }
    }
}

