/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.rs.validator;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.utils.OAuthUtils;
import org.apache.amber.oauth2.common.validators.AbstractValidator;

public class BearerHeaderOAuthValidator
extends AbstractValidator {
    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
    }

    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
    }

    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        String authzHeader = request.getHeader("Authorization");
        if (OAuthUtils.isEmpty((String)authzHeader)) {
            throw OAuthProblemException.error((String)"", (String)"Missing authorization header.");
        }
        String authzMethod = OAuthUtils.getAuthzMethod((String)authzHeader);
        if (!"Bearer".equals(authzMethod)) {
            throw OAuthProblemException.error((String)"", (String)"Incorrect authorization method.");
        }
        String headerField = OAuthUtils.getAuthHeaderField((String)authzHeader);
        if (OAuthUtils.isEmpty((String)headerField)) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"Missing required parameter.");
        }
        Map values = OAuthUtils.decodeOAuthHeader((String)authzHeader);
        String oauthVersionDiff = (String)values.get("oauth_signature_method");
        if (!OAuthUtils.isEmpty((String)oauthVersionDiff)) {
            throw OAuthProblemException.error((String)"invalid_request", (String)"Incorrect OAuth version. Found OAuth V1.0.");
        }
    }
}

