/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.rs.validator;

import javax.servlet.http.HttpServletRequest;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.utils.OAuthUtils;
import org.apache.amber.oauth2.common.validators.AbstractValidator;

public class BearerBodyOAuthValidator
extends AbstractValidator {
    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
        String method = request.getMethod();
        if (!("POST".equals(method) || "PUT".equals(method) || "DELETE".equals(method))) {
            throw OAuthProblemException.error((String)"invalid_request").description("Incorrect method. POST, PUT, DELETE are supported.");
        }
    }

    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
        if (OAuthUtils.isMultipart((HttpServletRequest)request)) {
            throw OAuthProblemException.error((String)"invalid_request").description("Request is not single part.");
        }
        super.validateContentType(request);
    }

    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        if (OAuthUtils.isMultipart((HttpServletRequest)request)) {
            throw OAuthProblemException.error((String)"invalid_request").description("Request is not single part.");
        }
        String[] tokens = request.getParameterValues("access_token");
        if (OAuthUtils.hasEmptyValues((String[])tokens) && OAuthUtils.hasEmptyValues((String[])(tokens = request.getParameterValues("oauth_token")))) {
            throw OAuthProblemException.error(null, (String)"Missing OAuth token.");
        }
        if (tokens.length > 1) {
            throw OAuthProblemException.error((String)"invalid_request").description("Multiple tokens attached.");
        }
        String oauthVersionDiff = request.getParameter("oauth_signature_method");
        if (!OAuthUtils.isEmpty((String)oauthVersionDiff)) {
            throw OAuthProblemException.error((String)"invalid_request").description("Incorrect OAuth version. Found OAuth V1.0.");
        }
    }
}

