/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.msgbox.client;

import org.apache.airavata.wsmg.client.util.ClientUtil;
import org.apache.airavata.wsmg.commons.MsgBoxQNameConstants;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateMsgBox {
    private static final Logger logger = LoggerFactory.getLogger(CreateMsgBox.class);
    private final OMFactory factory = OMAbstractFactory.getOMFactory();
    protected String msgBoxEndPointReference;
    protected long timeoutInMilliSeconds;
    private String msgBoxId;
    private OMElement responseEl;

    public CreateMsgBox(String msgBoxLocation, long timeout) {
        this.msgBoxEndPointReference = msgBoxLocation;
        this.responseEl = OMAbstractFactory.getOMFactory().createOMElement(MsgBoxQNameConstants.MSG_BOXID_QNAME);
        this.timeoutInMilliSeconds = timeout;
    }

    public long getTimeoutInMilliSeconds() {
        return this.timeoutInMilliSeconds;
    }

    public void setTimeoutInMilliSeconds(long timeout) {
        this.timeoutInMilliSeconds = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointReference execute() throws AxisFault {
        ServiceClient serviceClient = this.createServiceClient();
        OMElement responseMessage = null;
        try {
            responseMessage = serviceClient.sendReceive(this.createMessageEl());
        }
        finally {
            serviceClient.cleanupTransport();
        }
        if (responseMessage == null) {
            throw AxisFault.makeFault((Throwable)new RuntimeException("no response recieved for subscription message"));
        }
        String response = responseMessage.getFirstElement().getText();
        this.responseEl.setText(response);
        this.msgBoxEndPointReference = ClientUtil.formatMessageBoxUrl(this.msgBoxEndPointReference, response);
        return new EndpointReference(this.msgBoxEndPointReference);
    }

    private OMElement createMessageEl() throws AxisFault {
        OMElement message = this.factory.createOMElement("createMsgBox", NameSpaceConstants.MSG_BOX);
        OMElement msgBoxId = this.factory.createOMElement("MsgBoxId", NameSpaceConstants.MSG_BOX);
        msgBoxId.setText("Create message box");
        message.addChild((OMNode)msgBoxId);
        message.declareNamespace(NameSpaceConstants.MSG_BOX);
        return message;
    }

    private ServiceClient createServiceClient() throws AxisFault {
        ServiceClient client;
        Options opts;
        block3: {
            String uuid = UUIDGenerator.getUUID();
            opts = new Options();
            opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
            opts.setTo(new EndpointReference(this.msgBoxEndPointReference));
            opts.setMessageId(uuid);
            opts.setAction(NameSpaceConstants.MSG_BOX.getNamespaceURI() + "/" + "createMsgBox");
            opts.setTimeOutInMilliSeconds(this.getTimeoutInMilliSeconds());
            client = new ServiceClient();
            try {
                client.engageModule("addressing");
                if (logger.isDebugEnabled()) {
                    logger.debug("Addressing module engaged");
                }
            }
            catch (AxisFault e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Addressing module not engaged :" + (Object)((Object)e));
            }
        }
        client.setOptions(opts);
        return client;
    }
}

