/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.gui;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.airavata.wsmg.client.ConsumerNotificationHandler;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.gui.NotificationViewerFrame;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsntViewerConsumerNotificationHandler
implements ConsumerNotificationHandler {
    private static final Logger logger = LoggerFactory.getLogger(WsntViewerConsumerNotificationHandler.class);
    public NotificationViewerFrame frame = null;

    public WsntViewerConsumerNotificationHandler() {
    }

    public WsntViewerConsumerNotificationHandler(NotificationViewerFrame f) {
        this.frame = f;
    }

    @Override
    public void handleNotification(SOAPEnvelope msgEnvelope) {
        logger.debug("*******lead message handler Received message********");
        logger.debug(msgEnvelope.toString());
        try {
            this.addBriefMsg(msgEnvelope);
            this.addWholeMsg(msgEnvelope);
        }
        catch (XMLStreamException e) {
            logger.error("invalid message received", (Throwable)e);
            throw new RuntimeException("invalid message recieved", e);
        }
    }

    private void addBriefMsg(SOAPEnvelope env) throws XMLStreamException {
        QName notify = new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "Notify", NameSpaceConstants.WSNT_NS.getPrefix());
        QName notifyMsg = new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "NotificationMessage", NameSpaceConstants.WSNT_NS.getPrefix());
        QName msg = new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "Message", NameSpaceConstants.WSNT_NS.getPrefix());
        if (env.getBody() == null) {
            throw new RuntimeException("invalid soap envelope - no soap body");
        }
        Iterator ite = env.getBody().getChildrenWithName(notify);
        if (!ite.hasNext()) {
            throw new RuntimeException(notify.getLocalPart() + " tag is not found");
        }
        OMElement ele = (OMElement)ite.next();
        if (!(ite = ele.getChildrenWithName(notifyMsg)).hasNext()) {
            throw new RuntimeException(notifyMsg.getLocalPart() + " tag is not found");
        }
        ele = (OMElement)ite.next();
        if (!(ite = ele.getChildrenWithName(msg)).hasNext()) {
            throw new RuntimeException(msg.getLocalPart() + " tags are not found");
        }
        while (ite.hasNext()) {
            ele = (OMElement)ite.next();
            if (ele.getFirstElement() != null) {
                this.frame.addBriefMessage(ele.getFirstElement().toString());
                continue;
            }
            throw new RuntimeException("raw message is not found");
        }
    }

    private void addWholeMsg(SOAPEnvelope envelope) throws XMLStreamException {
        this.frame.addWholeMessage(envelope.toStringWithConsume());
    }
}

