/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.airavata.wsmg.client.ConsumerServer;
import org.apache.airavata.wsmg.client.WsntMsgBrokerClient;
import org.apache.airavata.wsmg.gui.NotificationViewerFrame_jButton1_actionAdapter;
import org.apache.airavata.wsmg.gui.NotificationViewerFrame_jButtonClear_actionAdapter;
import org.apache.airavata.wsmg.gui.NotificationViewerFrame_jButtonStop_actionAdapter;
import org.apache.airavata.wsmg.gui.WsntViewerConsumerNotificationHandler;
import org.apache.axis2.AxisFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationViewerFrame
extends JFrame {
    private static final long serialVersionUID = -4924241323165353343L;
    private static final Logger logger = LoggerFactory.getLogger(NotificationViewerFrame.class);
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    Border border1 = BorderFactory.createLineBorder(Color.gray, 2);
    JLabel jLabel1 = new JLabel();
    JButton jButtonStart = new JButton();
    JLabel jLabel2 = new JLabel();
    JTextField jTextBrokerUrl = new JTextField();
    JLabel jLabel3 = new JLabel();
    JTextField jTextPort = new JTextField();
    JLabel jLabel4 = new JLabel();
    JTextField jTextTopic = new JTextField();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea jTextAreaBrief = new JTextArea();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea jTextAreaWhole = new JTextArea();
    JButton jButtonClear = new JButton();
    ConsumerServer consumerServer = null;
    WsntMsgBrokerClient client;
    String subId = null;
    JButton jButtonStop = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public NotificationViewerFrame() {
        try {
            this.setDefaultCloseOperation(3);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.client = new WsntMsgBrokerClient();
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(547, 429));
        this.setTitle("WS-Notification Viewer");
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setMaximumSize(new Dimension(180000, 180000));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jLabel1.setFont(new Font("Serif", 3, 28));
        this.jLabel1.setForeground(Color.blue);
        this.jLabel1.setText("WS-Notification Listener");
        this.jButtonStart.setToolTipText("Subscribe to the topic and start listening");
        this.jButtonStart.setText("Start");
        this.jButtonStart.addActionListener(new NotificationViewerFrame_jButton1_actionAdapter(this));
        this.jLabel2.setFont(new Font("Dialog", 1, 11));
        this.jLabel2.setText("BrokerURL");
        this.jTextBrokerUrl.setToolTipText("Enter Broker URL here.");
        this.jTextBrokerUrl.setText("http://localhost:8080/axis2/services/NotificationService");
        this.jLabel3.setFont(new Font("Dialog", 1, 11));
        this.jLabel3.setText("Listening Port");
        this.jTextPort.setToolTipText("Enter the port this listener will be listening to.");
        this.jTextPort.setText("19999");
        this.jLabel4.setFont(new Font("Dialog", 1, 11));
        this.jLabel4.setText("Topic");
        this.jTextTopic.setToolTipText("Enter the topic to subscribe.");
        this.jTextTopic.setText("topic");
        this.jTextAreaBrief.setToolTipText("Summary of the messages received.");
        this.jTextAreaBrief.setLineWrap(true);
        this.jTextAreaWhole.setToolTipText("Full content of the SOAP messages.");
        this.jButtonClear.setToolTipText("Clear messages in the two message panes.");
        this.jButtonClear.setText("Clear Messages");
        this.jButtonClear.addActionListener(new NotificationViewerFrame_jButtonClear_actionAdapter(this));
        this.jButtonStop.setEnabled(false);
        this.jButtonStop.setToolTipText("Unsubscribe to the topic and stop listening.");
        this.jButtonStop.setText("Stop");
        this.jButtonStop.addActionListener(new NotificationViewerFrame_jButtonStop_actionAdapter(this));
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane1.setToolTipText("Summary of the messages received.");
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jScrollPane2.setAutoscrolls(true);
        this.jScrollPane2.setToolTipText("Full content of the SOAP messages.");
        this.jTabbedPane1.add((Component)this.jScrollPane1, "Brief Messages");
        this.jTabbedPane1.add((Component)this.jScrollPane2, "Whole Messages");
        this.jPanel1.add((Component)this.jLabel1, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(7, 10, 0, 107), 20, -5));
        this.jPanel1.add((Component)this.jButtonStop, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 48, 0, 80), 55, -4));
        this.jPanel1.add((Component)this.jLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 36, 0, 8), 43, 4));
        this.jPanel1.add((Component)this.jLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 36, 0, 0), 1, 4));
        this.jPanel1.add((Component)this.jTextPort, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(7, 0, 0, 0), 144, -1));
        this.jPanel1.add((Component)this.jButtonClear, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 46, 0, 78), 3, -4));
        this.jPanel1.add((Component)this.jTextTopic, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 149, -1));
        this.jPanel1.add((Component)this.jTextBrokerUrl, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, -1, 5, 1), 10, -1));
        this.jPanel1.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 37, 5, 0), 21, 4));
        this.jPanel1.add((Component)this.jButtonStart, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 47, 0, 79), 57, -4));
        this.jScrollPane2.getViewport().add(this.jTextAreaWhole);
        this.jScrollPane1.getViewport().add(this.jTextAreaBrief);
        this.jPanel1.add((Component)this.jTabbedPane1, new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 18, 57, 30), 0, 206));
        this.contentPane.add((Component)this.jPanel1, "Center");
    }

    public void jButtonStart_actionPerformed(ActionEvent event) {
        String brokerUrl = this.jTextBrokerUrl.getText().trim();
        String topic = this.jTextTopic.getText();
        String listeningPort = this.jTextPort.getText();
        int port = -1;
        try {
            port = Integer.parseInt(listeningPort);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, nfe, "invalid port specified", 0);
            return;
        }
        this.client.init(brokerUrl);
        WsntViewerConsumerNotificationHandler handler = new WsntViewerConsumerNotificationHandler(this);
        String consumerUrl = null;
        try {
            String[] eprs = this.client.startConsumerService(port, handler);
            if (eprs.length <= 0) {
                throw new AxisFault("no consumer url given by wse client api");
            }
            consumerUrl = eprs[0];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "Unable to start consumer service", 0);
            return;
        }
        try {
            this.subId = this.client.subscribe(consumerUrl, topic, null);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e, "Unable to subscribe to topic", 0);
            this.client.shutdownConsumerService();
            return;
        }
        this.jButtonStart.setEnabled(false);
        this.jTextBrokerUrl.setEnabled(false);
        this.jTextTopic.setEnabled(false);
        this.jTextPort.setEnabled(false);
        this.jButtonStop.setEnabled(true);
        this.jTextAreaBrief.append("Listener started...\n");
        this.jTextAreaWhole.append("Listener started...\n");
    }

    public void jButtonStop_actionPerformed(ActionEvent e) {
        if (this.subId != null) {
            try {
                this.client.init(this.jTextBrokerUrl.getText().trim());
                this.client.unSubscribe(this.subId);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e, "Unable to unsubscribe from topic", 0);
            }
            this.subId = null;
        }
        this.client.shutdownConsumerService();
        this.jButtonStop.setEnabled(false);
        this.jButtonStart.setEnabled(true);
        this.jTextBrokerUrl.setEnabled(true);
        this.jTextTopic.setEnabled(true);
        this.jTextPort.setEnabled(true);
        this.jTextAreaBrief.append("Listener stoped.\n");
        this.jTextAreaWhole.append("Listener stoped.\n");
    }

    public void addBriefMessage(String message) {
        this.jTextAreaBrief.append(message + "\n");
        this.jTextAreaBrief.selectAll();
    }

    public void addWholeMessage(String message) {
        this.jTextAreaWhole.append(message + "\n");
        this.jTextAreaWhole.selectAll();
    }

    public void jButtonClear_actionPerformed(ActionEvent e) {
        this.jTextAreaBrief.setText("");
        this.jTextAreaWhole.setText("");
    }
}

