/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public final class DcDate
implements Cloneable {
    private String canonical;
    private int year;
    private int month;
    private int day;
    private int hh = -1;
    private int mm = -1;
    private int ss = -1;
    private String decimalFraction = null;
    private int zoneOffset;
    private Calendar instant;
    private int millisOffset = -1;
    public static final String LOCATION_PROPERTY = "http://xmlpull.org/v1/doc/properties.html#location";
    private static final int[] LOOKUP_10S = new int[]{1, 10, 100, 1000, 10000};

    public Object clone() throws CloneNotSupportedException {
        DcDate dd = (DcDate)super.clone();
        return dd;
    }

    public DcDate(TimeZone tz) throws RuntimeException {
        GregorianCalendar cal = new GregorianCalendar(tz);
        this.init(cal, tz);
    }

    public DcDate(Calendar cal) throws RuntimeException {
        this.init(cal, cal.getTimeZone());
    }

    private void init(Calendar cal, TimeZone tz) throws RuntimeException {
        int rawOffset = tz.getRawOffset();
        this.zoneOffset = rawOffset / 60000;
        this.instant = cal;
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.day = cal.get(5);
        this.hh = cal.get(11);
        this.mm = cal.get(12);
        this.ss = cal.get(13);
        this.canonical = this.computeCanonical();
    }

    public DcDate(String dcDate) throws RuntimeException {
        char zoneIndicator;
        assert (dcDate != null);
        this.canonical = dcDate;
        this.year = DcDate.getInt(dcDate, 1, 4);
        if (dcDate.length() == 4) {
            return;
        }
        DcDate.check(dcDate, 5, '-');
        this.month = DcDate.getInt(dcDate, 6, 2);
        if (dcDate.length() == 7) {
            return;
        }
        DcDate.check(dcDate, 8, '-');
        this.day = DcDate.getInt(dcDate, 9, 2);
        if (dcDate.length() == 10) {
            return;
        }
        DcDate.check(dcDate, 11, 'T');
        this.hh = DcDate.getInt(dcDate, 12, 2);
        DcDate.check(dcDate, 14, ':');
        this.mm = DcDate.getInt(dcDate, 15, 2);
        if (dcDate.length() == 16) {
            throw new RuntimeException("expected date formatted as YYYY-MM-DDThh:mm[:ss[.mmm]]TZD and not " + dcDate);
        }
        int pos = 17;
        char c17 = dcDate.charAt(pos - 1);
        if (c17 == ':') {
            DcDate.check(dcDate, 17, ':');
            this.ss = DcDate.getInt(dcDate, 18, 2);
            pos = 20;
        }
        if ((zoneIndicator = dcDate.charAt(pos - 1)) == '.') {
            char d;
            int oldPos = pos;
            do {
                d = dcDate.charAt(pos);
                ++pos;
            } while (d >= '0' && d <= '9');
            if (oldPos + 1 == pos) {
                throw new RuntimeException("expected date formtted as YYYY-MM-DDThh:mm[:ss[.s]]TZD and not " + dcDate);
            }
            zoneIndicator = d;
            int newPos = pos;
            this.decimalFraction = dcDate.substring(oldPos, newPos - 1);
            if (newPos - oldPos >= 3) {
                newPos = oldPos + 3;
            }
            int len = newPos - (oldPos + 1);
            int ii = DcDate.getInt(dcDate, oldPos + 1, len);
            if (len == 1) {
                this.millisOffset = 100 * ii;
            } else if (len == 2) {
                this.millisOffset = 10 * ii;
            } else if (len == 3) {
                this.millisOffset = ii;
            }
        }
        if (zoneIndicator != 'Z') {
            if (zoneIndicator == '-' || zoneIndicator == '+') {
                int zoneHH = DcDate.getInt(dcDate, pos + 1, 2);
                DcDate.check(dcDate, pos + 3, ':');
                int zoneMM = DcDate.getInt(dcDate, pos + 4, 2);
                this.zoneOffset = 60 * zoneHH + zoneMM;
                if (zoneIndicator == '-') {
                    this.zoneOffset *= -1;
                }
            } else {
                throw new RuntimeException("unknown zone indicator " + zoneIndicator + " in " + dcDate);
            }
        }
        this.instant = new GregorianCalendar();
        int rawOffset = this.zoneOffset * 60 * 1000;
        this.instant.set(15, rawOffset);
        this.instant.set(1, this.year);
        this.instant.set(2, this.month - 1);
        this.instant.set(5, this.day);
        this.instant.set(11, this.hh);
        this.instant.set(12, this.mm);
        this.instant.set(13, this.ss);
        this.instant.set(14, this.millisOffset);
        this.instant.getTimeInMillis();
    }

    public long getTimeInMillis() {
        return this.instant.getTimeInMillis();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hh;
    }

    public int getMinute() {
        return this.mm;
    }

    public int getSecond() {
        return this.ss;
    }

    public int getTimeZoneOffset() {
        return this.zoneOffset;
    }

    public String getDcDate() {
        return this.canonical;
    }

    public String getDecimalFraction() {
        return this.decimalFraction;
    }

    private String computeCanonical() {
        StringBuffer sb = new StringBuffer();
        DcDate.fill(sb, this.year, 4);
        if (this.month > 0) {
            sb.append('-');
            DcDate.fill(sb, this.month, 2);
            if (this.day > 0) {
                sb.append('-');
                DcDate.fill(sb, this.day, 2);
                if (this.hh > -1) {
                    sb.append('T');
                    DcDate.fill(sb, this.hh, 2);
                    sb.append(':');
                    DcDate.fill(sb, this.mm, 2);
                    if (this.ss > -1) {
                        sb.append(':');
                        DcDate.fill(sb, this.ss, 2);
                    }
                    if (this.decimalFraction != null) {
                        sb.append('.');
                        sb.append(this.decimalFraction);
                    }
                    if (this.zoneOffset == 0) {
                        sb.append('Z');
                    } else {
                        int off = this.zoneOffset;
                        if (this.zoneOffset > 0) {
                            sb.append('+');
                        } else {
                            sb.append('-');
                            off *= -1;
                        }
                        int zoneHH = off / 60;
                        int zoneMM = off % 60;
                        DcDate.fill(sb, zoneHH, 2);
                        sb.append(':');
                        DcDate.fill(sb, zoneMM, 2);
                    }
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.canonical;
    }

    public static String printable(char ch) {
        return "'" + DcDate.escape(ch) + "'";
    }

    public static String printable(String s) {
        return "\"" + DcDate.escape(s) + "\"";
    }

    public static String escape(char ch) {
        if (ch == '\n') {
            return "\\n";
        }
        if (ch == '\r') {
            return "\\r";
        }
        if (ch == '\t') {
            return "\\t";
        }
        if (ch == '\'') {
            return "\\'";
        }
        if (ch > '\u007f' || ch < ' ') {
            return "\\u" + Integer.toHexString(ch);
        }
        return "" + ch;
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        int sLen = s.length();
        StringBuffer buf = new StringBuffer(sLen + 10);
        for (int i = 0; i < sLen; ++i) {
            buf.append(DcDate.escape(s.charAt(i)));
        }
        s = buf.toString();
        return s;
    }

    public static void fill(StringBuffer sb, int value, int fields) {
        assert (fields > 0);
        assert (fields <= 4);
        assert (value >= 0);
        int mm = LOOKUP_10S[fields];
        assert (value < mm);
        while (fields-- > 0) {
            if (value >= (mm /= 10)) {
                sb.append(value / mm % 10);
                continue;
            }
            sb.append('0');
        }
    }

    public static void check(String dcDate, int pos, char ch) {
        if (pos > dcDate.length()) {
            throw new RuntimeException("expected " + DcDate.printable(ch) + " at position " + pos + " but " + dcDate + " is too short");
        }
        char c = dcDate.charAt(pos - 1);
        if (c != ch) {
            throw new RuntimeException("expected " + DcDate.printable(ch) + " but got " + DcDate.printable(c) + " in " + dcDate);
        }
    }

    public static int getInt(String dcDate, int pos, int len) throws RuntimeException {
        assert (len > 0);
        int end = pos + len - 1;
        String s = dcDate.substring(pos - 1, end);
        try {
            int i = Integer.parseInt(s);
            return i;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("expected number for " + DcDate.printable(s) + " in " + dcDate, e);
        }
    }

    public static String getWikiTitle(String title) {
        StringBuffer sb = new StringBuffer();
        List<String> words = DcDate.breakIntoWords(title);
        boolean start = true;
        for (String word : words) {
            boolean wordStart = true;
            for (int i = 0; i < word.length(); ++i) {
                char c = word.charAt(i);
                if (!Character.isLetterOrDigit(c)) continue;
                if (wordStart && !start) {
                    sb.append(Character.toUpperCase(c));
                } else {
                    sb.append(c);
                }
                wordStart = false;
            }
            start = false;
        }
        return sb.toString();
    }

    public static List<String> breakIntoWords(String s) {
        ArrayList<String> words = new ArrayList<String>(s.length() / 5);
        boolean inWord = true;
        int wordStart = 0;
        for (int pos = 0; pos < s.length(); ++pos) {
            char ch = s.charAt(pos);
            boolean isWordSeparator = Character.isWhitespace(ch);
            if (ch == ',') {
                isWordSeparator = true;
            }
            if (ch == '.') {
                isWordSeparator = true;
            }
            if (isWordSeparator) {
                if (inWord) {
                    words.add(s.substring(wordStart, pos));
                    inWord = false;
                }
            } else if (!inWord) {
                inWord = true;
                wordStart = pos;
            }
            assert (inWord == !isWordSeparator);
        }
        if (inWord) {
            words.add(s.substring(wordStart));
        }
        return words;
    }

    public static String makeTwoDigit(int oneOrTwoDigits) {
        if (oneOrTwoDigits < 0 || oneOrTwoDigits > 99) {
            throw new IllegalArgumentException();
        }
        if (oneOrTwoDigits < 10) {
            return "0" + oneOrTwoDigits;
        }
        return "" + oneOrTwoDigits;
    }
}

