/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client.protocol;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;

public class WSNTProtocolClient {
    public static OMElement createSubscriptionMsg(EndpointReference eventSinkLocation, String topicExpression, String xpathExpression) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement message = factory.createOMElement("SubscribeRequest", NameSpaceConstants.WSNT_NS);
        if (topicExpression != null) {
            OMElement topicExpEl = factory.createOMElement("TopicExpression", NameSpaceConstants.WSNT_NS, (OMContainer)message);
            topicExpEl.addAttribute("Dialect", "http://www.ibm.com/xmlns/stdwip/web-services/WS-Topics/TopicExpression/simple", NameSpaceConstants.WSNT_NS);
            topicExpEl.declareNamespace(NameSpaceConstants.WIDGET_NS);
            topicExpEl.setText(NameSpaceConstants.WIDGET_NS.getPrefix() + ":" + topicExpression);
        }
        if (xpathExpression != null) {
            OMElement xpathExpEl = factory.createOMElement("Selector", NameSpaceConstants.WSNT_NS, (OMContainer)message);
            xpathExpEl.addAttribute("Dialect", "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
            xpathExpEl.setText(xpathExpression);
        }
        OMElement useNotifyEl = factory.createOMElement("UseNotify", message.getNamespace(), (OMContainer)message);
        useNotifyEl.setText("true");
        OMElement eprCrEl = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)eventSinkLocation, (QName)new QName("ConsumerReference"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
        message.addChild((OMNode)eprCrEl);
        eprCrEl.setNamespace(message.getNamespace());
        return message;
    }

    public static String decodeSubscriptionResponse(OMElement subscriptionReference) throws AxisFault {
        String subscriptionId = null;
        EndpointReference subscriptionReferenceEPR = EndpointReferenceHelper.fromOM((OMElement)subscriptionReference);
        Map referenceParams = subscriptionReferenceEPR.getAllReferenceParameters();
        if (referenceParams != null) {
            QName identifierQName = new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "Identifier");
            OMElement identifierEl = (OMElement)referenceParams.get(identifierQName);
            subscriptionId = identifierEl != null ? identifierEl.getText() : null;
        }
        return subscriptionId;
    }

    public static OMElement createUnsubscribeMsg() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement message = factory.createOMElement("UnsubsribeRequest", NameSpaceConstants.WSNT_NS);
        return message;
    }

    public static OMElement encodeNotification(String topic, OMElement message, EndpointReference producerReference) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement topicExpEl = factory.createOMElement("Topic", NameSpaceConstants.WSNT_NS);
        topicExpEl.addAttribute("Dialect", "http://www.ibm.com/xmlns/stdwip/web-services/WS-Topics/TopicExpression/simple", null);
        topicExpEl.declareNamespace(NameSpaceConstants.WIDGET_NS);
        topicExpEl.setText(NameSpaceConstants.WIDGET_NS.getPrefix() + ":" + topic);
        OMElement messageToNotify = factory.createOMElement("Notify", NameSpaceConstants.WSNT_NS);
        messageToNotify.declareNamespace(NameSpaceConstants.WSNT_NS);
        messageToNotify.declareNamespace(NameSpaceConstants.WSA_NS);
        OMElement notificationMesssageEl = factory.createOMElement("NotificationMessage", messageToNotify.getNamespace(), (OMContainer)messageToNotify);
        notificationMesssageEl.addChild((OMNode)topicExpEl);
        notificationMesssageEl.addChild((OMNode)EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)producerReference, (QName)new QName(notificationMesssageEl.getNamespace().getNamespaceURI(), "ProducerReference", notificationMesssageEl.getNamespace().getPrefix()), (String)NameSpaceConstants.WSA_NS.getNamespaceURI()));
        OMElement messageEl = factory.createOMElement("Message", notificationMesssageEl.getNamespace(), (OMContainer)notificationMesssageEl);
        messageEl.addChild((OMNode)message);
        return messageToNotify;
    }
}

