/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client.commons;

import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;

public class NotificationProducer {
    private final OMFactory factory = OMAbstractFactory.getOMFactory();
    private final SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();

    public synchronized OMElement deliverMessage(OMElement notificationMessage, String type, EndpointReference brokerLocationEPR, long timeout) throws AxisFault {
        ServiceClient client = this.createServiceClient(type, notificationMessage, brokerLocationEPR, timeout, null);
        OMElement ret = client.sendReceive(notificationMessage);
        client.cleanupTransport();
        return ret;
    }

    public synchronized OMElement deliverMessage(OMElement notificationMessage, String type, EndpointReference brokerLocationEPR, long timeout, OMElement topicExpressionEl) throws AxisFault {
        ServiceClient client = this.createServiceClient(type, notificationMessage, brokerLocationEPR, timeout, topicExpressionEl);
        OMElement ret = client.sendReceive(notificationMessage);
        client.cleanupTransport();
        return ret;
    }

    private ServiceClient createServiceClient(String type, OMElement notificationMessage, EndpointReference brokerLocationEPR, long timeout, OMElement topicExpressionEl) throws AxisFault {
        ServiceClient client = new ServiceClient();
        if (client.getAxisConfiguration().getModule("addressing") != null) {
            brokerLocationEPR.addReferenceParameter(topicExpressionEl);
            client.engageModule("addressing");
        } else {
            SOAPHeaderBlock msgId = this.soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
            msgId.setText(UUIDGenerator.getUUID());
            SOAPHeaderBlock to = this.soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
            to.setText(brokerLocationEPR.getAddress());
            SOAPHeaderBlock action = this.soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
            action.setText("wsnt".equals(type) ? NameSpaceConstants.WSNT_NS.getNamespaceURI() + "/Notify" : "http://org.apache.airavata/WseNotification");
            if (topicExpressionEl != null) {
                try {
                    client.addHeader(ElementHelper.toSOAPHeaderBlock((OMElement)topicExpressionEl, (SOAPFactory)this.soapfactory));
                }
                catch (Exception e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
            }
            client.addHeader(action);
            client.addHeader(msgId);
            client.addHeader(to);
        }
        Options opts = new Options();
        opts.setAction("wsnt".equals(type) ? NameSpaceConstants.WSNT_NS.getNamespaceURI() + "/Notify" : "http://org.apache.airavata/WseNotification");
        opts.setTo(brokerLocationEPR);
        opts.setTimeOutInMilliSeconds(timeout);
        client.setOptions(opts);
        return client;
    }
}

