/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import java.util.HashMap;
import org.apache.airavata.wsmg.client.ConsumerMsgReceiver;
import org.apache.airavata.wsmg.client.ConsumerNotificationHandler;
import org.apache.airavata.wsmg.client.ConsumerService;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.SimpleHTTPServer;

public class ConsumerServer {
    private static final String ADDRESSING_VALIDATE_ACTION = "addressing.validateAction";
    public static final String SUPPORT_SINGLE_OP = "supportSingleOperation";
    private ConsumerNotificationHandler handler;
    private int listeningPort;
    private SimpleHTTPServer server;
    private AxisService consumerService = null;

    public ConsumerServer(int listenPort, ConsumerNotificationHandler h) {
        if (listenPort <= 0 || h == null) {
            throw new IllegalArgumentException("invalid arguments supplied");
        }
        this.listeningPort = listenPort;
        this.handler = h;
        this.server = null;
        this.consumerService = null;
    }

    public String[] getConsumerServiceEPRs() {
        return this.consumerService.getEPRs();
    }

    public void start() throws AxisFault {
        ConfigurationContext context = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        context.setProperty(ADDRESSING_VALIDATE_ACTION, (Object)false);
        context.getAxisConfiguration().addParameter(SUPPORT_SINGLE_OP, (Object)true);
        context.getAxisConfiguration().addParameter(ADDRESSING_VALIDATE_ACTION, (Object)false);
        HashMap<String, ConsumerMsgReceiver> msgRecieverMap = new HashMap<String, ConsumerMsgReceiver>();
        ConsumerMsgReceiver conMsgRcv = new ConsumerMsgReceiver(this.handler);
        msgRecieverMap.put("http://www.w3.org/ns/wsdl/in-only", conMsgRcv);
        AxisService service = AxisService.createService((String)ConsumerService.class.getName(), (AxisConfiguration)context.getAxisConfiguration(), msgRecieverMap, null, null, (ClassLoader)ConsumerServer.class.getClassLoader());
        context.getAxisConfiguration().addService(service);
        this.server = new SimpleHTTPServer(context, this.listeningPort);
        this.server.start();
        this.consumerService = service;
    }

    public void stop() {
        this.server.stop();
    }

    public int getListenPort() {
        return this.listeningPort;
    }
}

