/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.client;

import org.apache.airavata.wsmg.client.ConsumerServer;
import org.apache.airavata.wsmg.client.MessageBrokerClient;
import org.apache.airavata.wsmg.client.MsgBrokerClientException;
import org.apache.airavata.wsmg.client.NotificationHandler;
import org.apache.airavata.wsmg.client.msgbox.MessagePuller;
import org.apache.airavata.wsmg.client.msgbox.MsgboxHandler;
import org.apache.airavata.wsmg.commons.MsgBoxQNameConstants;
import org.apache.airavata.wsmg.commons.WsmgVersion;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.addressing.EndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CommonMsgBrokerClient
implements MessageBrokerClient {
    protected static final OMFactory factory = OMAbstractFactory.getOMFactory();
    private static final SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();
    private static final Logger logger = LoggerFactory.getLogger(CommonMsgBrokerClient.class);
    protected ConsumerServer xs;
    protected MsgboxHandler msgboxHandler = new MsgboxHandler();
    private long socketTimeout = 200000L;

    public CommonMsgBrokerClient(long timeout) {
        this.socketTimeout = timeout;
        WsmgVersion.requireVersionOrExit((String)WsmgVersion.getVersion());
    }

    @Override
    public String[] getConsumerServiceEndpointReference() {
        if (this.xs == null) {
            throw new RuntimeException("Consumer server is not started yet");
        }
        return this.xs.getConsumerServiceEPRs();
    }

    public void setTimeOutInMilliSeconds(long timeout) {
        this.socketTimeout = timeout;
    }

    public CommonMsgBrokerClient() {
        WsmgVersion.requireVersionOrExit((String)WsmgVersion.getVersion());
    }

    public long getTimeOutInMilliSeconds() {
        return this.socketTimeout;
    }

    @Override
    public String subscribeMsgBox(String brokerService, EndpointReference msgBoxEpr, String topic, String xpath) throws MsgBrokerClientException {
        int biginIndex;
        String msgBoxId = null;
        String msgBoxUrl = msgBoxEpr.getAddress();
        msgBoxId = msgBoxUrl.substring((biginIndex = msgBoxUrl.indexOf("clientid")) + "clientid".length() + 1);
        if (msgBoxId == null) {
            throw new RuntimeException("Invalid Message Box EPR, message box ID is missing");
        }
        return this.subscribe(msgBoxEpr.getAddress(), topic, xpath);
    }

    @Override
    public String subscribeMsgBox(EndpointReference msgBoxEpr, String topicExpression, String xpathExpression, long expireTime) throws MsgBrokerClientException {
        String msgBoxEventSink = msgBoxEpr.getAddress();
        String formattedEventSink = null;
        if (msgBoxEpr.getAddress().contains("clientid")) {
            formattedEventSink = msgBoxEventSink;
        } else {
            if (msgBoxEpr.getAllReferenceParameters() == null) {
                throw new MsgBrokerClientException("Invalid Message Box EPR, no reference parameters found");
            }
            String msgBoxId = ((OMElement)msgBoxEpr.getAllReferenceParameters().get(MsgBoxQNameConstants.MSG_BOXID_QNAME)).getText();
            if (msgBoxId == null) {
                throw new MsgBrokerClientException("Invalid Message Box EPR, reference parameter MsgBoxAddr is missing");
            }
            String format = msgBoxEventSink.endsWith("/") ? "%sclientid/%s" : "%s/clientid/%s";
            formattedEventSink = String.format(format, msgBoxEventSink, msgBoxId);
        }
        return this.subscribe(new EndpointReference(formattedEventSink), topicExpression, xpathExpression, expireTime);
    }

    @Override
    public EndpointReference createPullMsgBox(String msgBoxLocation, long timeout) throws MsgBrokerClientException {
        EndpointReference ret = null;
        ret = this.msgboxHandler.createPullMsgBox(msgBoxLocation, timeout);
        return ret;
    }

    @Override
    public EndpointReference createPullMsgBox(String msgBoxServerLoc) throws MsgBrokerClientException {
        EndpointReference ret = null;
        ret = this.msgboxHandler.createPullMsgBox(msgBoxServerLoc);
        return ret;
    }

    @Override
    public MessagePuller startPullingEventsFromMsgBox(EndpointReference msgBoxEpr, NotificationHandler handler, long interval, long timeout) throws MsgBrokerClientException {
        MessagePuller ret = null;
        ret = this.msgboxHandler.startPullingEventsFromMsgBox(msgBoxEpr, handler, interval, timeout);
        return ret;
    }

    @Override
    public MessagePuller startPullingFromExistingMsgBox(EndpointReference msgBoxAddr, NotificationHandler handler, long interval, long timeout) throws MsgBrokerClientException {
        MessagePuller ret = null;
        ret = this.msgboxHandler.startPullingFromExistingMsgBox(msgBoxAddr, handler, interval, timeout);
        return ret;
    }

    public String deleteMsgBox(EndpointReference msgBoxEpr, long timeout) throws MsgBrokerClientException {
        String ret = null;
        ret = this.msgboxHandler.deleteMsgBox(msgBoxEpr, timeout);
        return ret;
    }

    @Override
    public void stopPullingEventsFromMsgBox(MessagePuller msgPuller) {
        this.msgboxHandler.stopPullingEventsFromMsgBox(msgPuller);
    }
}

