/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Data;
import org.apache.airavata.persistance.registry.jpa.model.GFac_Job_Data;
import org.apache.airavata.persistance.registry.jpa.model.GFac_Job_Status;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.GFacJobStatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFacJobDataResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GFacJobDataResource.class);
    private ExperimentDataResource experimentDataResource;
    private WorkflowDataResource workflowDataResource;
    private String nodeID;
    private String applicationDescID;
    private String hostDescID;
    private String serviceDescID;
    private String jobData;
    private String localJobID;
    private Timestamp submittedTime;
    private Timestamp statusUpdateTime;
    private String status;
    private String metadata;

    public ExperimentDataResource getExperimentDataResource() {
        return this.experimentDataResource;
    }

    public WorkflowDataResource getWorkflowDataResource() {
        return this.workflowDataResource;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getApplicationDescID() {
        return this.applicationDescID;
    }

    public String getHostDescID() {
        return this.hostDescID;
    }

    public String getServiceDescID() {
        return this.serviceDescID;
    }

    public String getJobData() {
        return this.jobData;
    }

    public String getLocalJobID() {
        return this.localJobID;
    }

    public Timestamp getSubmittedTime() {
        return this.submittedTime;
    }

    public Timestamp getStatusUpdateTime() {
        return this.statusUpdateTime;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setExperimentDataResource(ExperimentDataResource experimentDataResource) {
        this.experimentDataResource = experimentDataResource;
    }

    public void setWorkflowDataResource(WorkflowDataResource workflowDataResource) {
        this.workflowDataResource = workflowDataResource;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public void setApplicationDescID(String applicationDescID) {
        this.applicationDescID = applicationDescID;
    }

    public void setHostDescID(String hostDescID) {
        this.hostDescID = hostDescID;
    }

    public void setServiceDescID(String serviceDescID) {
        this.serviceDescID = serviceDescID;
    }

    public void setJobData(String jobData) {
        this.jobData = jobData;
    }

    public void setLocalJobID(String localJobID) {
        this.localJobID = localJobID;
    }

    public void setSubmittedTime(Timestamp submittedTime) {
        this.submittedTime = submittedTime;
    }

    public void setStatusUpdateTime(Timestamp statusUpdateTime) {
        this.statusUpdateTime = statusUpdateTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public Resource create(ResourceType type) {
        switch (type) {
            case GFAC_JOB_STATUS: {
                GFacJobStatusResource gFacJobStatusResource = new GFacJobStatusResource();
                gFacJobStatusResource.setLocalJobID(this.localJobID);
                gFacJobStatusResource.setgFacJobDataResource(this);
                return gFacJobStatusResource;
            }
        }
        logger.error("Unsupported resource type for GFac Job status resource", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported resource type for GFac Job data resource", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported resource type for GFac Job data resource", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case GFAC_JOB_STATUS: {
                QueryGenerator generator = new QueryGenerator("GFac_Job_Status", new Object[0][]);
                generator.setParameter("local_Job_ID", this.localJobID);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() == 0) break;
                for (Object result : results) {
                    GFac_Job_Status gFacJobStatus = (GFac_Job_Status)result;
                    GFacJobStatusResource gFacJobStatusResource = (GFacJobStatusResource)Utils.getResource(ResourceType.GFAC_JOB_STATUS, gFacJobStatus);
                    resourceList.add(gFacJobStatusResource);
                }
                break;
            }
            default: {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for gfac job data resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for gfac job data resource.");
            }
        }
        em.getTransaction().commit();
        em.close();
        return resourceList;
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        GFac_Job_Data existingGfacJobData = (GFac_Job_Data)em.find(GFac_Job_Data.class, (Object)this.localJobID);
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        GFac_Job_Data gFacJobData = new GFac_Job_Data();
        Experiment_Data experiment_data = (Experiment_Data)em.find(Experiment_Data.class, (Object)this.experimentDataResource.getExperimentID());
        gFacJobData.setExperiment_data(experiment_data);
        gFacJobData.setExperiment_ID(this.experimentDataResource.getExperimentID());
        Workflow_Data workflow_data = (Workflow_Data)em.find(Workflow_Data.class, (Object)this.workflowDataResource.getWorkflowInstanceID());
        gFacJobData.setWorkflow_Data(workflow_data);
        gFacJobData.setWorkflow_instanceID(this.workflowDataResource.getWorkflowInstanceID());
        gFacJobData.setNode_id(this.nodeID);
        gFacJobData.setApplication_descriptor_ID(this.applicationDescID);
        gFacJobData.setLocal_Job_ID(this.localJobID);
        gFacJobData.setService_descriptor_ID(this.serviceDescID);
        gFacJobData.setHost_descriptor_ID(this.hostDescID);
        gFacJobData.setJob_data(this.jobData);
        gFacJobData.setSubmitted_time(this.submittedTime);
        gFacJobData.setStatus_update_time(this.statusUpdateTime);
        gFacJobData.setStatus(this.status);
        gFacJobData.setMetadata(this.metadata);
        if (existingGfacJobData != null) {
            Experiment_Data experiment_data1 = (Experiment_Data)em.find(Experiment_Data.class, (Object)this.experimentDataResource.getExperimentID());
            existingGfacJobData.setExperiment_data(experiment_data1);
            existingGfacJobData.setExperiment_ID(this.experimentDataResource.getExperimentID());
            Workflow_Data workflow_data1 = (Workflow_Data)em.find(Workflow_Data.class, (Object)this.workflowDataResource.getWorkflowInstanceID());
            existingGfacJobData.setWorkflow_Data(workflow_data1);
            existingGfacJobData.setWorkflow_instanceID(this.workflowDataResource.getWorkflowInstanceID());
            existingGfacJobData.setNode_id(this.nodeID);
            existingGfacJobData.setApplication_descriptor_ID(this.applicationDescID);
            existingGfacJobData.setLocal_Job_ID(this.localJobID);
            existingGfacJobData.setService_descriptor_ID(this.serviceDescID);
            existingGfacJobData.setHost_descriptor_ID(this.hostDescID);
            existingGfacJobData.setJob_data(this.jobData);
            existingGfacJobData.setSubmitted_time(this.submittedTime);
            existingGfacJobData.setStatus_update_time(this.statusUpdateTime);
            existingGfacJobData.setStatus(this.status);
            existingGfacJobData.setMetadata(this.metadata);
            gFacJobData = (GFac_Job_Data)em.merge((Object)existingGfacJobData);
        } else {
            em.persist((Object)gFacJobData);
        }
        em.getTransaction().commit();
        em.close();
    }
}

