/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker_PK;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.User_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkerResource.class);
    private String user;
    private GatewayResource gateway;

    public WorkerResource() {
    }

    public WorkerResource(String user, GatewayResource gateway) {
        this.setUser(user);
        this.gateway = gateway;
    }

    @Override
    public Resource create(ResourceType type) {
        AbstractResource result = null;
        switch (type) {
            case PROJECT: {
                ProjectResource projectResource = new ProjectResource();
                projectResource.setWorker(this);
                projectResource.setGateway(this.gateway);
                result = projectResource;
                break;
            }
            case USER_WORKFLOW: {
                UserWorkflowResource userWorkflowResource = new UserWorkflowResource();
                userWorkflowResource.setWorker(this);
                userWorkflowResource.setGateway(this.gateway);
                result = userWorkflowResource;
                break;
            }
            case EXPERIMENT: {
                ExperimentResource experimentResource = new ExperimentResource();
                experimentResource.setWorker(this);
                experimentResource.setGateway(this.gateway);
                result = experimentResource;
                break;
            }
            default: {
                logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for worker resource.");
            }
        }
        return result;
    }

    @Override
    public void remove(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case PROJECT: {
                QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                generator.setParameter("project_name", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case USER_WORKFLOW: {
                QueryGenerator generator = new QueryGenerator("User_Workflow", new Object[0][]);
                generator.setParameter("owner", this.getUser());
                generator.setParameter("template_name", name);
                generator.setParameter("gateway_name", this.gateway.getGatewayName());
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case EXPERIMENT: {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("user_name", this.getUser());
                generator.setParameter("experiment_ID", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            case WORKFLOW_DATA: {
                QueryGenerator generator = new QueryGenerator("Workflow_Data", new Object[0][]);
                generator.setParameter("workflow_instanceID", name);
                Query q = generator.deleteQuery(em);
                q.executeUpdate();
                break;
            }
            default: {
                logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
            }
        }
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        Resource result = null;
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case PROJECT: {
                QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                generator.setParameter("project_name", name);
                Query q = generator.selectQuery(em);
                Project project = (Project)q.getSingleResult();
                result = Utils.getResource(ResourceType.PROJECT, project);
                break;
            }
            case USER_WORKFLOW: {
                QueryGenerator generator = new QueryGenerator("User_Workflow", new Object[0][]);
                generator.setParameter("owner", this.getUser());
                generator.setParameter("template_name", name);
                generator.setParameter("gateway_name", this.gateway.getGatewayName());
                Query q = generator.selectQuery(em);
                User_Workflow userWorkflow = (User_Workflow)q.getSingleResult();
                result = Utils.getResource(ResourceType.USER_WORKFLOW, userWorkflow);
                break;
            }
            case EXPERIMENT: {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("user_name", this.getUser());
                generator.setParameter("experiment_ID", name);
                Query q = generator.selectQuery(em);
                Experiment experiment = (Experiment)q.getSingleResult();
                result = Utils.getResource(ResourceType.EXPERIMENT, experiment);
                break;
            }
            case WORKFLOW_DATA: {
                QueryGenerator generator = new QueryGenerator("Workflow_Data", new Object[0][]);
                generator.setParameter("workflow_instanceID", name);
                Query q = generator.selectQuery(em);
                Workflow_Data eworkflowData = (Workflow_Data)q.getSingleResult();
                WorkflowDataResource workflowDataResource = (WorkflowDataResource)Utils.getResource(ResourceType.WORKFLOW_DATA, eworkflowData);
                result = workflowDataResource;
                break;
            }
            default: {
                logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
            }
        }
        em.getTransaction().commit();
        em.close();
        return result;
    }

    @Override
    public List<Resource> get(ResourceType type) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        switch (type) {
            case PROJECT: {
                QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                Users users = (Users)em.find(Users.class, (Object)this.getUser());
                Gateway gatewayModel = (Gateway)em.find(Gateway.class, (Object)this.gateway.getGatewayName());
                generator.setParameter("users", users);
                generator.setParameter("gateway", gatewayModel);
                Query q = generator.selectQuery(em);
                for (Object o : q.getResultList()) {
                    Project project = (Project)o;
                    ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                    result.add(projectResource);
                }
                break;
            }
            case USER_WORKFLOW: {
                QueryGenerator generator = new QueryGenerator("User_Workflow", new Object[0][]);
                generator.setParameter("owner", this.getUser());
                Query q = generator.selectQuery(em);
                for (Object o : q.getResultList()) {
                    User_Workflow userWorkflow = (User_Workflow)o;
                    UserWorkflowResource userWorkflowResource = (UserWorkflowResource)Utils.getResource(ResourceType.USER_WORKFLOW, userWorkflow);
                    result.add(userWorkflowResource);
                }
                break;
            }
            case EXPERIMENT: {
                QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                generator.setParameter("user_name", this.getUser());
                generator.setParameter("gateway_name", this.gateway.getGatewayName());
                Query q = generator.selectQuery(em);
                for (Object o : q.getResultList()) {
                    Experiment experiment = (Experiment)o;
                    ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                    result.add(experimentResource);
                }
                break;
            }
            default: {
                logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
            }
        }
        em.getTransaction().commit();
        em.close();
        return result;
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Gateway_Worker existingWorker = (Gateway_Worker)em.find(Gateway_Worker.class, (Object)new Gateway_Worker_PK(this.gateway.getGatewayName(), this.user));
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Gateway_Worker gatewayWorker = new Gateway_Worker();
        Users users = new Users();
        users.setUser_name(this.user);
        gatewayWorker.setUser(users);
        Gateway gatewaymodel = new Gateway();
        gatewaymodel.setGateway_name(this.gateway.getGatewayName());
        gatewaymodel.setOwner(this.gateway.getOwner());
        gatewayWorker.setGateway(gatewaymodel);
        if (existingWorker != null) {
            gatewayWorker = (Gateway_Worker)em.merge((Object)existingWorker);
        } else {
            em.merge((Object)gatewayWorker);
        }
        em.getTransaction().commit();
        em.close();
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public boolean isProjectExists(String name) {
        return this.isExists(ResourceType.PROJECT, name);
    }

    public ProjectResource createProject(String name) {
        ProjectResource project = (ProjectResource)this.create(ResourceType.PROJECT);
        project.setName(name);
        return project;
    }

    public ProjectResource getProject(String name) {
        return (ProjectResource)this.get(ResourceType.PROJECT, name);
    }

    public void removeProject(String name) {
        this.remove(ResourceType.PROJECT, name);
    }

    public List<ProjectResource> getProjects() {
        ArrayList<ProjectResource> result = new ArrayList<ProjectResource>();
        List<Resource> list = this.get(ResourceType.PROJECT);
        for (Resource resource : list) {
            result.add((ProjectResource)resource);
        }
        return result;
    }

    public boolean isWorkflowTemplateExists(String templateName) {
        return this.isExists(ResourceType.USER_WORKFLOW, templateName);
    }

    public UserWorkflowResource createWorkflowTemplate(String templateName) {
        UserWorkflowResource workflow = (UserWorkflowResource)this.create(ResourceType.USER_WORKFLOW);
        workflow.setName(templateName);
        return workflow;
    }

    public UserWorkflowResource getWorkflowTemplate(String templateName) {
        return (UserWorkflowResource)this.get(ResourceType.USER_WORKFLOW, templateName);
    }

    public void removeWorkflowTemplate(String templateName) {
        this.remove(ResourceType.USER_WORKFLOW, templateName);
    }

    public List<UserWorkflowResource> getWorkflowTemplates() {
        ArrayList<UserWorkflowResource> result = new ArrayList<UserWorkflowResource>();
        List<Resource> list = this.get(ResourceType.USER_WORKFLOW);
        for (Resource resource : list) {
            result.add((UserWorkflowResource)resource);
        }
        return result;
    }

    public boolean isExperimentExists(String name) {
        return this.isExists(ResourceType.EXPERIMENT, name);
    }

    public ExperimentResource getExperiment(String name) {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, name);
    }

    public List<ExperimentResource> getExperiments() {
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        List<Resource> list = this.get(ResourceType.EXPERIMENT);
        for (Resource resource : list) {
            result.add((ExperimentResource)resource);
        }
        return result;
    }

    public void removeExperiment(String experimentId) {
        this.remove(ResourceType.EXPERIMENT, experimentId);
    }

    public boolean isWorkflowInstancePresent(String workflowInstanceId) {
        return this.isExists(ResourceType.WORKFLOW_DATA, workflowInstanceId);
    }

    public WorkflowDataResource getWorkflowInstance(String workflowInstanceId) {
        return (WorkflowDataResource)this.get(ResourceType.WORKFLOW_DATA, workflowInstanceId);
    }

    public void removeWorkflowInstance(String workflowInstanceId) {
        this.remove(ResourceType.WORKFLOW_DATA, workflowInstanceId);
    }
}

