/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.airavata.common.exception.AiravataConfigurationException;
import org.apache.airavata.common.utils.Version;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.persistance.registry.jpa.JPAResourceAccessor;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigurationResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataRetriever;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentMetadataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.GramDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.HostDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.PublishWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.ServiceDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.apache.airavata.registry.api.AiravataExperiment;
import org.apache.airavata.registry.api.AiravataRegistry2;
import org.apache.airavata.registry.api.AiravataRegistryFactory;
import org.apache.airavata.registry.api.AiravataSubRegistry;
import org.apache.airavata.registry.api.AiravataUser;
import org.apache.airavata.registry.api.ConfigurationRegistry;
import org.apache.airavata.registry.api.DescriptorRegistry;
import org.apache.airavata.registry.api.Gateway;
import org.apache.airavata.registry.api.PasswordCallback;
import org.apache.airavata.registry.api.ProjectsRegistry;
import org.apache.airavata.registry.api.ProvenanceRegistry;
import org.apache.airavata.registry.api.PublishedWorkflowRegistry;
import org.apache.airavata.registry.api.ResourceMetadata;
import org.apache.airavata.registry.api.UserWorkflowRegistry;
import org.apache.airavata.registry.api.WorkspaceProject;
import org.apache.airavata.registry.api.exception.RegistryAccessorInstantiateException;
import org.apache.airavata.registry.api.exception.RegistryAccessorNotFoundException;
import org.apache.airavata.registry.api.exception.RegistryAccessorUndefinedException;
import org.apache.airavata.registry.api.exception.RegistryException;
import org.apache.airavata.registry.api.exception.UnimplementedRegistryOperationException;
import org.apache.airavata.registry.api.exception.gateway.DescriptorAlreadyExistsException;
import org.apache.airavata.registry.api.exception.gateway.DescriptorDoesNotExistsException;
import org.apache.airavata.registry.api.exception.gateway.InsufficientDataException;
import org.apache.airavata.registry.api.exception.gateway.MalformedDescriptorException;
import org.apache.airavata.registry.api.exception.gateway.PublishedWorkflowAlreadyExistsException;
import org.apache.airavata.registry.api.exception.gateway.PublishedWorkflowDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.ExperimentDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.ExperimentLazyLoadedException;
import org.apache.airavata.registry.api.exception.worker.UserWorkflowAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.UserWorkflowDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceNodeAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceNodeDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkspaceProjectAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkspaceProjectDoesNotExistsException;
import org.apache.airavata.registry.api.impl.WorkflowExecutionDataImpl;
import org.apache.airavata.registry.api.workflow.ExperimentData;
import org.apache.airavata.registry.api.workflow.NodeExecutionData;
import org.apache.airavata.registry.api.workflow.NodeExecutionStatus;
import org.apache.airavata.registry.api.workflow.WorkflowExecution;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionData;
import org.apache.airavata.registry.api.workflow.WorkflowExecutionStatus;
import org.apache.airavata.registry.api.workflow.WorkflowIOData;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.registry.api.workflow.WorkflowNodeGramData;
import org.apache.airavata.registry.api.workflow.WorkflowNodeIOData;
import org.apache.airavata.registry.api.workflow.WorkflowNodeType;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataJPARegistry
extends AiravataRegistry2 {
    private static final Logger logger = LoggerFactory.getLogger(AiravataJPARegistry.class);
    private JPAResourceAccessor jpa;
    private boolean active = false;
    private static final String DEFAULT_PROJECT_NAME = "default";
    private static final Version API_VERSION = new Version("Airavata Registry API", Integer.valueOf(0), Integer.valueOf(6), null, null, null);
    private URI registryConnectionURI;
    private ConfigurationRegistry configurationRegistry;
    private DescriptorRegistry descriptorRegistry;
    private ProjectsRegistry projectsRegistry;
    private ProvenanceRegistry provenanceRegistry;
    private UserWorkflowRegistry userWorkflowRegistry;
    private PublishedWorkflowRegistry publishedWorkflowRegistry;
    private PasswordCallback callback;
    private static final String GFAC_URL = "gfac.url";
    private static final String INTERPRETER_URL = "interpreter.url";
    private static final String MESSAGE_BOX_URL = "messagebox.url";
    private static final String EVENTING_URL = "eventing.url";

    protected void initialize() throws RegistryException {
        this.jpa = new JPAResourceAccessor(this);
        this.active = true;
        this.initializeCustomRegistries();
    }

    private void initializeCustomRegistries() throws RegistryException {
        try {
            this.configurationRegistry = (ConfigurationRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.configuration.registry.accessor");
            this.descriptorRegistry = (DescriptorRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.descriptor.registry.accessor");
            this.projectsRegistry = (ProjectsRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.project.registry.accessor");
            this.provenanceRegistry = (ProvenanceRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.provenance.registry.accessor");
            this.userWorkflowRegistry = (UserWorkflowRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.user.workflow.registry.accessor");
            this.publishedWorkflowRegistry = (PublishedWorkflowRegistry)this.getClassInstance(ConfigurationRegistry.class, "class.published.workflow.registry.accessor");
        }
        catch (AiravataConfigurationException e) {
            throw new RegistryException("An error occured when attempting to determine any custom implementations of the registries!!!", (Throwable)e);
        }
    }

    private <T extends AiravataSubRegistry> Object getClassInstance(Class<T> c, String registryAccessorKey) throws AiravataConfigurationException {
        try {
            AiravataSubRegistry registryClass = (AiravataSubRegistry)c.cast(AiravataRegistryFactory.getRegistryClass((String)registryAccessorKey));
            registryClass.setAiravataRegistry((AiravataRegistry2)this);
            return registryClass;
        }
        catch (ClassCastException e) {
            logger.error("The class defined for accessor type " + registryAccessorKey + " MUST be an extention of the interface " + c.getName(), (Throwable)e);
        }
        catch (RegistryAccessorNotFoundException e) {
            logger.error("Error in loading class for registry accessor " + registryAccessorKey, (Throwable)e);
        }
        catch (RegistryAccessorUndefinedException e) {
        }
        catch (RegistryAccessorInstantiateException e) {
            logger.error("Error in instantiating instance from class for registry accessor " + registryAccessorKey, (Throwable)e);
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public Object getConfiguration(String key) {
        ConfigurationResource configuration = ResourceUtils.getConfiguration(key);
        return configuration == null ? null : configuration.getConfigVal();
    }

    public List<Object> getConfigurationList(String key) {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getConfigurationList(key);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        List<ConfigurationResource> configurations = ResourceUtils.getConfigurations(key);
        for (ConfigurationResource configurationResource : configurations) {
            values.add(configurationResource.getConfigVal());
        }
        return values;
    }

    public void setConfiguration(String key, String value, Date expire) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setConfiguration(key, value, expire);
        } else {
            ConfigurationResource config = ResourceUtils.isConfigurationExist(key) ? ResourceUtils.getConfiguration(key) : ResourceUtils.createConfiguration(key);
            config.setConfigVal(value);
            config.setExpireDate(new Timestamp(expire.getTime()));
            config.save();
        }
    }

    public void addConfiguration(String key, String value, Date expire) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addConfiguration(key, value, expire);
        } else {
            ConfigurationResource config = ResourceUtils.createConfiguration(key);
            config.setConfigVal(value);
            config.setExpireDate(new Timestamp(expire.getTime()));
            config.save();
        }
    }

    public void removeAllConfiguration(String key) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeAllConfiguration(key);
        } else {
            ResourceUtils.removeConfiguration(key);
        }
    }

    public void removeConfiguration(String key, String value) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeConfiguration(key, value);
        } else {
            ResourceUtils.removeConfiguration(key, value);
        }
    }

    public List<URI> getGFacURIs() {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getGFacURIs();
        }
        return this.retrieveURIsFromConfiguration(GFAC_URL);
    }

    private List<URI> retrieveURIsFromConfiguration(String urlType) {
        ArrayList<URI> urls = new ArrayList<URI>();
        List<Object> configurationList = this.getConfigurationList(urlType);
        for (Object o : configurationList) {
            try {
                urls.add(new URI(o.toString()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public List<URI> getWorkflowInterpreterURIs() {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getWorkflowInterpreterURIs();
        }
        return this.retrieveURIsFromConfiguration(INTERPRETER_URL);
    }

    public URI getEventingServiceURI() {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getEventingServiceURI();
        }
        List<URI> eventingURLs = this.retrieveURIsFromConfiguration(EVENTING_URL);
        return eventingURLs.size() == 0 ? null : eventingURLs.get(0);
    }

    public URI getMessageBoxURI() {
        if (this.configurationRegistry != null) {
            return this.configurationRegistry.getMessageBoxURI();
        }
        List<URI> messageboxURLs = this.retrieveURIsFromConfiguration(MESSAGE_BOX_URL);
        return messageboxURLs.size() == 0 ? null : messageboxURLs.get(0);
    }

    public void addGFacURI(URI uri) {
        if (this.configurationRegistry != null) {
            this.addGFacURI(uri);
        } else {
            this.addConfigurationURL(GFAC_URL, uri);
        }
    }

    private void addConfigurationURL(String urlType, URI uri) {
        Calendar instance = Calendar.getInstance();
        instance.add(12, 180);
        Date expire = instance.getTime();
        this.addConfigurationURL(urlType, uri, expire);
    }

    private void addConfigurationURL(String urlType, URI uri, Date expire) {
        this.addConfiguration(urlType, uri.toString(), expire);
    }

    public void addWorkflowInterpreterURI(URI uri) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addWorkflowInterpreterURI(uri);
        } else {
            this.addConfigurationURL(INTERPRETER_URL, uri);
        }
    }

    public void setEventingURI(URI uri) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setEventingURI(uri);
        } else {
            this.addConfigurationURL(EVENTING_URL, uri);
        }
    }

    public void setMessageBoxURI(URI uri) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setMessageBoxURI(uri);
        } else {
            this.addConfigurationURL(MESSAGE_BOX_URL, uri);
        }
    }

    public void addGFacURI(URI uri, Date expire) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addGFacURI(uri, expire);
        } else {
            this.addConfigurationURL(GFAC_URL, uri, expire);
        }
    }

    public void addWorkflowInterpreterURI(URI uri, Date expire) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.addWorkflowInterpreterURI(uri, expire);
        } else {
            this.addConfigurationURL(INTERPRETER_URL, uri, expire);
        }
    }

    public void setEventingURI(URI uri, Date expire) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setEventingURI(uri, expire);
        } else {
            this.addConfigurationURL(EVENTING_URL, uri, expire);
        }
    }

    public void setMessageBoxURI(URI uri, Date expire) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.setMessageBoxURI(uri, expire);
        } else {
            this.addConfigurationURL(MESSAGE_BOX_URL, uri, expire);
        }
    }

    public void removeGFacURI(URI uri) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeGFacURI(uri);
        } else {
            this.removeConfiguration(GFAC_URL, uri.toString());
        }
    }

    public void removeWorkflowInterpreterURI(URI uri) {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeWorkflowInterpreterURI(uri);
        } else {
            this.removeConfiguration(INTERPRETER_URL, uri.toString());
        }
    }

    public void removeAllGFacURI() {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeAllGFacURI();
        } else {
            this.removeAllConfiguration(GFAC_URL);
        }
    }

    public void removeAllWorkflowInterpreterURI() {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.removeAllWorkflowInterpreterURI();
        } else {
            this.removeAllConfiguration(INTERPRETER_URL);
        }
    }

    public void unsetEventingURI() {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.unsetEventingURI();
        } else {
            this.removeAllConfiguration(EVENTING_URL);
        }
    }

    public void unsetMessageBoxURI() {
        if (this.configurationRegistry != null) {
            this.configurationRegistry.unsetMessageBoxURI();
        } else {
            this.removeAllConfiguration(MESSAGE_BOX_URL);
        }
    }

    public boolean isHostDescriptorExists(String descriptorName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.isHostDescriptorExists(descriptorName);
        }
        return this.jpa.getGateway().isHostDescriptorExists(descriptorName);
    }

    public void addHostDescriptor(HostDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addHostDescriptor(descriptor);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            WorkerResource workerResource = this.jpa.getWorker();
            String hostName = descriptor.getType().getHostName();
            if (this.isHostDescriptorExists(hostName)) {
                throw new DescriptorAlreadyExistsException(hostName);
            }
            HostDescriptorResource hostDescriptorResource = gateway.createHostDescriptorResource(hostName);
            hostDescriptorResource.setUserName(workerResource.getUser());
            hostDescriptorResource.setContent(descriptor.toXML());
            hostDescriptorResource.save();
        }
    }

    public void updateHostDescriptor(HostDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.updateHostDescriptor(descriptor);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            String hostName = descriptor.getType().getHostName();
            if (!this.isHostDescriptorExists(hostName)) {
                throw new DescriptorDoesNotExistsException(hostName);
            }
            HostDescriptorResource hostDescriptorResource = gateway.getHostDescriptorResource(hostName);
            hostDescriptorResource.setContent(descriptor.toXML());
            hostDescriptorResource.save();
        }
    }

    public HostDescription getHostDescriptor(String hostName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getHostDescriptor(hostName);
        }
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isHostDescriptorExists(hostName)) {
            return null;
        }
        HostDescriptorResource hostDescriptorResource = gateway.getHostDescriptorResource(hostName);
        return this.createHostDescriptor(hostDescriptorResource);
    }

    private HostDescription createHostDescriptor(HostDescriptorResource hostDescriptorResource) throws MalformedDescriptorException {
        try {
            return HostDescription.fromXML((String)hostDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(hostDescriptorResource.getHostDescName(), (Throwable)e);
        }
    }

    public void removeHostDescriptor(String hostName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.removeHostDescriptor(hostName);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            if (!this.isHostDescriptorExists(hostName)) {
                throw new DescriptorDoesNotExistsException(hostName);
            }
            gateway.removeHostDescriptor(hostName);
        }
    }

    public List<HostDescription> getHostDescriptors() throws MalformedDescriptorException, RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getHostDescriptors();
        }
        GatewayResource gateway = this.jpa.getGateway();
        ArrayList<HostDescription> list = new ArrayList<HostDescription>();
        List<HostDescriptorResource> hostDescriptorResources = gateway.getHostDescriptorResources();
        for (HostDescriptorResource resource : hostDescriptorResources) {
            list.add(this.createHostDescriptor(resource));
        }
        return list;
    }

    public ResourceMetadata getHostDescriptorMetadata(String hostName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getHostDescriptorMetadata(hostName);
        }
        throw new UnimplementedRegistryOperationException();
    }

    public boolean isServiceDescriptorExists(String descriptorName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.isServiceDescriptorExists(descriptorName);
        }
        return this.jpa.getGateway().isServiceDescriptorExists(descriptorName);
    }

    public void addServiceDescriptor(ServiceDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addServiceDescriptor(descriptor);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            WorkerResource workerResource = this.jpa.getWorker();
            String serviceName = descriptor.getType().getName();
            if (this.isServiceDescriptorExists(serviceName)) {
                throw new DescriptorAlreadyExistsException(serviceName);
            }
            ServiceDescriptorResource serviceDescriptorResource = gateway.createServiceDescriptorResource(serviceName);
            serviceDescriptorResource.setUserName(workerResource.getUser());
            serviceDescriptorResource.setContent(descriptor.toXML());
            serviceDescriptorResource.save();
        }
    }

    public void updateServiceDescriptor(ServiceDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.updateServiceDescriptor(descriptor);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            String serviceName = descriptor.getType().getName();
            if (!this.isServiceDescriptorExists(serviceName)) {
                throw new DescriptorDoesNotExistsException(serviceName);
            }
            ServiceDescriptorResource serviceDescriptorResource = gateway.getServiceDescriptorResource(serviceName);
            serviceDescriptorResource.setContent(descriptor.toXML());
            serviceDescriptorResource.save();
        }
    }

    public ServiceDescription getServiceDescriptor(String serviceName) throws RegistryException, MalformedDescriptorException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getServiceDescriptor(serviceName);
        }
        GatewayResource gateway = this.jpa.getGateway();
        if (!gateway.isServiceDescriptorExists(serviceName)) {
            return null;
        }
        ServiceDescriptorResource serviceDescriptorResource = gateway.getServiceDescriptorResource(serviceName);
        return this.createServiceDescriptor(serviceDescriptorResource);
    }

    private ServiceDescription createServiceDescriptor(ServiceDescriptorResource serviceDescriptorResource) throws MalformedDescriptorException {
        try {
            return ServiceDescription.fromXML((String)serviceDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(serviceDescriptorResource.getServiceDescName(), (Throwable)e);
        }
    }

    public void removeServiceDescriptor(String serviceName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.removeServiceDescriptor(serviceName);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            if (!this.isServiceDescriptorExists(serviceName)) {
                throw new DescriptorDoesNotExistsException(serviceName);
            }
            gateway.removeServiceDescriptor(serviceName);
        }
    }

    public List<ServiceDescription> getServiceDescriptors() throws MalformedDescriptorException, RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getServiceDescriptors();
        }
        GatewayResource gateway = this.jpa.getGateway();
        ArrayList<ServiceDescription> list = new ArrayList<ServiceDescription>();
        List<ServiceDescriptorResource> serviceDescriptorResources = gateway.getServiceDescriptorResources();
        for (ServiceDescriptorResource resource : serviceDescriptorResources) {
            list.add(this.createServiceDescriptor(resource));
        }
        return list;
    }

    public ResourceMetadata getServiceDescriptorMetadata(String serviceName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getServiceDescriptorMetadata(serviceName);
        }
        throw new UnimplementedRegistryOperationException();
    }

    private String createAppName(String serviceName, String hostName, String applicationName) {
        return serviceName + "/" + hostName + "/" + applicationName;
    }

    public boolean isApplicationDescriptorExists(String serviceName, String hostName, String descriptorName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.isApplicationDescriptorExists(serviceName, hostName, descriptorName);
        }
        return this.jpa.getGateway().isApplicationDescriptorExists(this.createAppName(serviceName, hostName, descriptorName));
    }

    public void addApplicationDescriptor(ServiceDescription serviceDescription, HostDescription hostDescriptor, ApplicationDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addApplicationDescriptor(serviceDescription, hostDescriptor, descriptor);
        } else {
            this.addApplicationDescriptor(serviceDescription.getType().getName(), hostDescriptor.getType().getHostName(), descriptor);
        }
    }

    public void addApplicationDescriptor(String serviceName, String hostName, ApplicationDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.addApplicationDescriptor(serviceName, hostName, descriptor);
        } else {
            if (serviceName == null || hostName == null) {
                throw new InsufficientDataException("Service name or Host name cannot be null");
            }
            GatewayResource gateway = this.jpa.getGateway();
            WorkerResource workerResource = this.jpa.getWorker();
            String applicationName = descriptor.getType().getApplicationName().getStringValue();
            applicationName = this.createAppName(serviceName, hostName, applicationName);
            if (this.isApplicationDescriptorExists(serviceName, hostName, descriptor.getType().getApplicationName().getStringValue())) {
                throw new DescriptorAlreadyExistsException(applicationName);
            }
            ApplicationDescriptorResource applicationDescriptorResource = gateway.createApplicationDescriptorResource(applicationName);
            applicationDescriptorResource.setUpdatedUser(workerResource.getUser());
            applicationDescriptorResource.setServiceDescName(serviceName);
            applicationDescriptorResource.setHostDescName(hostName);
            applicationDescriptorResource.setContent(descriptor.toXML());
            applicationDescriptorResource.save();
        }
    }

    public void udpateApplicationDescriptor(ServiceDescription serviceDescription, HostDescription hostDescriptor, ApplicationDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.udpateApplicationDescriptor(serviceDescription, hostDescriptor, descriptor);
        } else {
            this.updateApplicationDescriptor(serviceDescription.getType().getName(), hostDescriptor.getType().getHostName(), descriptor);
        }
    }

    public void updateApplicationDescriptor(String serviceName, String hostName, ApplicationDescription descriptor) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.updateApplicationDescriptor(serviceName, hostName, descriptor);
        } else {
            if (serviceName == null || hostName == null) {
                throw new InsufficientDataException("Service name or Host name cannot be null");
            }
            GatewayResource gateway = this.jpa.getGateway();
            String applicationName = descriptor.getType().getApplicationName().getStringValue();
            applicationName = this.createAppName(serviceName, hostName, applicationName);
            if (!this.isApplicationDescriptorExists(serviceName, hostName, descriptor.getType().getApplicationName().getStringValue())) {
                throw new DescriptorDoesNotExistsException(applicationName);
            }
            ApplicationDescriptorResource serviceDescriptorResource = gateway.getApplicationDescriptorResource(applicationName);
            serviceDescriptorResource.setContent(descriptor.toXML());
            serviceDescriptorResource.save();
        }
    }

    private ApplicationDescription createApplicationDescriptor(ApplicationDescriptorResource applicationDescriptorResource) throws MalformedDescriptorException {
        try {
            return ApplicationDescription.fromXML((String)applicationDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(applicationDescriptorResource.getName(), (Throwable)e);
        }
    }

    public ApplicationDescription getApplicationDescriptor(String serviceName, String hostname, String applicationName) throws DescriptorDoesNotExistsException, MalformedDescriptorException, RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptor(serviceName, hostname, applicationName);
        }
        if (serviceName == null || hostname == null) {
            throw new InsufficientDataException("Service name or Host name cannot be null");
        }
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isApplicationDescriptorExists(serviceName, hostname, applicationName)) {
            throw new DescriptorDoesNotExistsException(this.createAppName(serviceName, hostname, applicationName));
        }
        return this.createApplicationDescriptor(gateway.getApplicationDescriptorResource(this.createAppName(serviceName, hostname, applicationName)));
    }

    public ApplicationDescription getApplicationDescriptors(String serviceName, String hostname) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptors(serviceName, hostname);
        }
        GatewayResource gateway = this.jpa.getGateway();
        List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources(serviceName, hostname);
        if (applicationDescriptorResources.size() > 0) {
            return this.createApplicationDescriptor(applicationDescriptorResources.get(0));
        }
        return null;
    }

    public Map<String, ApplicationDescription> getApplicationDescriptors(String serviceName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptors(serviceName);
        }
        GatewayResource gateway = this.jpa.getGateway();
        HashMap<String, ApplicationDescription> map = new HashMap<String, ApplicationDescription>();
        List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources(serviceName, null);
        for (ApplicationDescriptorResource resource : applicationDescriptorResources) {
            map.put(resource.getHostDescName(), this.createApplicationDescriptor(resource));
        }
        return map;
    }

    public Map<String[], ApplicationDescription> getApplicationDescriptors() throws MalformedDescriptorException, RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptors();
        }
        GatewayResource gateway = this.jpa.getGateway();
        HashMap<String[], ApplicationDescription> map = new HashMap<String[], ApplicationDescription>();
        List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources();
        for (ApplicationDescriptorResource resource : applicationDescriptorResources) {
            map.put(new String[]{resource.getServiceDescName(), resource.getHostDescName()}, this.createApplicationDescriptor(resource));
        }
        return map;
    }

    public void removeApplicationDescriptor(String serviceName, String hostName, String applicationName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            this.descriptorRegistry.removeApplicationDescriptor(serviceName, hostName, applicationName);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            String appName = this.createAppName(serviceName, hostName, applicationName);
            if (!this.isApplicationDescriptorExists(serviceName, hostName, applicationName)) {
                throw new DescriptorDoesNotExistsException(appName);
            }
            gateway.removeApplicationDescriptor(appName);
        }
    }

    public ResourceMetadata getApplicationDescriptorMetadata(String serviceName, String hostName, String applicationName) throws RegistryException {
        if (this.descriptorRegistry != null) {
            return this.descriptorRegistry.getApplicationDescriptorMetadata(serviceName, hostName, applicationName);
        }
        throw new UnimplementedRegistryOperationException();
    }

    private String createProjName(String projectName) {
        return this.createProjName(this.getGateway().getGatewayName(), this.getUser().getUserName(), projectName);
    }

    private String createProjName(String gatewayName, String userName, String projectName) {
        return gatewayName + "\n" + userName + "\n" + projectName;
    }

    private String getProjName(String projectLongName) {
        String[] s = projectLongName.split("\n");
        return s[s.length - 1];
    }

    public boolean isWorkspaceProjectExists(String projectName) throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.isWorkspaceProjectExists(projectName);
        }
        return this.isWorkspaceProjectExists(projectName, false);
    }

    public boolean isWorkspaceProjectExists(String projectName, boolean createIfNotExists) throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.isWorkspaceProjectExists(projectName, createIfNotExists);
        }
        if (this.jpa.getWorker().isProjectExists(this.createProjName(projectName))) {
            return true;
        }
        if (createIfNotExists) {
            this.addWorkspaceProject(new WorkspaceProject(projectName, (ProjectsRegistry)this));
            return this.isWorkspaceProjectExists(projectName);
        }
        return false;
    }

    public void addWorkspaceProject(WorkspaceProject project) throws RegistryException {
        if (this.projectsRegistry != null) {
            this.projectsRegistry.addWorkspaceProject(project);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (this.isWorkspaceProjectExists(project.getProjectName())) {
                throw new WorkspaceProjectAlreadyExistsException(this.createProjName(project.getProjectName()));
            }
            ProjectResource projectResource = worker.createProject(this.createProjName(project.getProjectName()));
            projectResource.save();
        }
    }

    public void updateWorkspaceProject(WorkspaceProject project) throws RegistryException {
        if (this.projectsRegistry != null) {
            this.projectsRegistry.updateWorkspaceProject(project);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (!this.isWorkspaceProjectExists(project.getProjectName())) {
                throw new WorkspaceProjectDoesNotExistsException(this.createProjName(project.getProjectName()));
            }
            ProjectResource projectResource = worker.getProject(this.createProjName(project.getProjectName()));
            projectResource.save();
        }
    }

    public void deleteWorkspaceProject(String projectName) throws RegistryException {
        if (this.projectsRegistry != null) {
            this.projectsRegistry.deleteWorkspaceProject(projectName);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (!this.isWorkspaceProjectExists(projectName)) {
                throw new WorkspaceProjectDoesNotExistsException(this.createProjName(projectName));
            }
            worker.removeProject(this.createProjName(projectName));
        }
    }

    public WorkspaceProject getWorkspaceProject(String projectName) throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.getWorkspaceProject(projectName);
        }
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkspaceProjectExists(projectName)) {
            throw new WorkspaceProjectDoesNotExistsException(this.createProjName(projectName));
        }
        ProjectResource projectResource = worker.getProject(this.createProjName(projectName));
        return new WorkspaceProject(this.getProjName(projectResource.getName()), (ProjectsRegistry)this);
    }

    public List<WorkspaceProject> getWorkspaceProjects() throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.getWorkspaceProjects();
        }
        WorkerResource worker = this.jpa.getWorker();
        ArrayList<WorkspaceProject> projects = new ArrayList<WorkspaceProject>();
        List<ProjectResource> projectResouces = worker.getProjects();
        for (ProjectResource resource : projectResouces) {
            projects.add(new WorkspaceProject(this.getProjName(resource.getName()), (ProjectsRegistry)this));
        }
        return projects;
    }

    public void addExperiment(String projectName, AiravataExperiment experiment) throws RegistryException {
        if (this.projectsRegistry != null) {
            this.projectsRegistry.addExperiment(projectName, experiment);
        } else {
            WorkspaceProject workspaceProject = this.getWorkspaceProject(projectName);
            ProjectResource project = this.jpa.getWorker().getProject(this.createProjName(workspaceProject.getProjectName()));
            String experimentId = experiment.getExperimentId();
            if (this.isExperimentExists(experimentId)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
            ExperimentResource experimentResource = project.createExperiment(experimentId);
            if (experiment.getSubmittedDate() != null) {
                experimentResource.setSubmittedDate(new Timestamp(experiment.getSubmittedDate().getTime()));
            }
            experimentResource.save();
        }
    }

    public void removeExperiment(String experimentId) throws ExperimentDoesNotExistsException {
        if (this.projectsRegistry != null) {
            this.projectsRegistry.removeExperiment(experimentId);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (!worker.isExperimentExists(experimentId)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
            worker.removeExperiment(experimentId);
        }
    }

    public List<AiravataExperiment> getExperiments() throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.getExperiments();
        }
        WorkerResource worker = this.jpa.getWorker();
        ArrayList<AiravataExperiment> result = new ArrayList<AiravataExperiment>();
        List<ExperimentResource> experiments = worker.getExperiments();
        for (ExperimentResource resource : experiments) {
            AiravataExperiment e = this.createAiravataExperimentObj(resource);
            result.add(e);
        }
        return result;
    }

    private AiravataExperiment createAiravataExperimentObj(ExperimentResource resource) {
        AiravataExperiment e = new AiravataExperiment();
        e.setExperimentId(resource.getExpID());
        e.setUser(new AiravataUser(resource.getWorker().getUser()));
        e.setSubmittedDate(new Date(resource.getSubmittedDate().getTime()));
        e.setGateway(new Gateway(resource.getGateway().getGatewayName()));
        e.setProject(new WorkspaceProject(this.getProjName(resource.getProject().getName()), (ProjectsRegistry)this));
        return e;
    }

    public List<AiravataExperiment> getExperiments(String projectName) throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.getExperiments(projectName);
        }
        ProjectResource project = this.jpa.getWorker().getProject(this.createProjName(projectName));
        List<ExperimentResource> experiments = project.getExperiments();
        ArrayList<AiravataExperiment> result = new ArrayList<AiravataExperiment>();
        for (ExperimentResource resource : experiments) {
            AiravataExperiment e = this.createAiravataExperimentObj(resource);
            result.add(e);
        }
        return result;
    }

    public List<AiravataExperiment> getExperiments(Date from, Date to) throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.getExperiments(from, to);
        }
        List<AiravataExperiment> experiments = this.getExperiments();
        ArrayList<AiravataExperiment> newExperiments = new ArrayList<AiravataExperiment>();
        for (AiravataExperiment exp : experiments) {
            Date submittedDate = exp.getSubmittedDate();
            if (!submittedDate.after(from) || !submittedDate.before(to)) continue;
            newExperiments.add(exp);
        }
        return newExperiments;
    }

    public List<AiravataExperiment> getExperiments(String projectName, Date from, Date to) throws RegistryException {
        if (this.projectsRegistry != null) {
            return this.projectsRegistry.getExperiments(projectName, from, to);
        }
        List<AiravataExperiment> experiments = this.getExperiments(projectName);
        ArrayList<AiravataExperiment> newExperiments = new ArrayList<AiravataExperiment>();
        for (AiravataExperiment exp : experiments) {
            Date submittedDate = exp.getSubmittedDate();
            if (!submittedDate.after(from) || !submittedDate.before(to)) continue;
            newExperiments.add(exp);
        }
        return newExperiments;
    }

    public boolean isPublishedWorkflowExists(String workflowName) throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.isPublishedWorkflowExists(workflowName);
        }
        return this.jpa.getGateway().isPublishedWorkflowExists(workflowName);
    }

    public void publishWorkflow(String workflowName, String publishWorkflowName) throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            this.publishedWorkflowRegistry.publishWorkflow(workflowName, publishWorkflowName);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            String workflowGraphXML = this.getWorkflowGraphXML(workflowName);
            if (gateway.isPublishedWorkflowExists(publishWorkflowName)) {
                throw new PublishedWorkflowAlreadyExistsException(publishWorkflowName);
            }
            PublishWorkflowResource publishedWorkflow = gateway.createPublishedWorkflow(publishWorkflowName);
            publishedWorkflow.setCreatedUser(this.getUser().getUserName());
            publishedWorkflow.setContent(workflowGraphXML);
            publishedWorkflow.setPublishedDate(new Timestamp(Calendar.getInstance().getTime().getTime()));
            publishedWorkflow.save();
        }
    }

    public void publishWorkflow(String workflowName) throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            this.publishedWorkflowRegistry.publishWorkflow(workflowName);
        } else {
            this.publishWorkflow(workflowName, workflowName);
        }
    }

    public String getPublishedWorkflowGraphXML(String workflowName) throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflowGraphXML(workflowName);
        }
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isPublishedWorkflowExists(workflowName)) {
            throw new PublishedWorkflowDoesNotExistsException(workflowName);
        }
        return gateway.getPublishedWorkflow(workflowName).getContent();
    }

    public List<String> getPublishedWorkflowNames() throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflowNames();
        }
        GatewayResource gateway = this.jpa.getGateway();
        ArrayList<String> result = new ArrayList<String>();
        List<PublishWorkflowResource> publishedWorkflows = gateway.getPublishedWorkflows();
        for (PublishWorkflowResource resource : publishedWorkflows) {
            result.add(resource.getName());
        }
        return result;
    }

    public Map<String, String> getPublishedWorkflows() throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflows();
        }
        GatewayResource gateway = this.jpa.getGateway();
        HashMap<String, String> result = new HashMap<String, String>();
        List<PublishWorkflowResource> publishedWorkflows = gateway.getPublishedWorkflows();
        for (PublishWorkflowResource resource : publishedWorkflows) {
            result.put(resource.getName(), resource.getContent());
        }
        return result;
    }

    public void removePublishedWorkflow(String workflowName) throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            this.publishedWorkflowRegistry.removePublishedWorkflow(workflowName);
        } else {
            GatewayResource gateway = this.jpa.getGateway();
            if (!this.isPublishedWorkflowExists(workflowName)) {
                throw new PublishedWorkflowDoesNotExistsException(workflowName);
            }
            gateway.removePublishedWorkflow(workflowName);
        }
    }

    public ResourceMetadata getPublishedWorkflowMetadata(String workflowName) throws RegistryException {
        if (this.publishedWorkflowRegistry != null) {
            return this.publishedWorkflowRegistry.getPublishedWorkflowMetadata(workflowName);
        }
        throw new UnimplementedRegistryOperationException();
    }

    public boolean isWorkflowExists(String workflowName) throws RegistryException {
        if (this.userWorkflowRegistry != null) {
            return this.userWorkflowRegistry.isWorkflowExists(workflowName);
        }
        return this.jpa.getWorker().isWorkflowTemplateExists(workflowName);
    }

    public void addWorkflow(String workflowName, String workflowGraphXml) throws RegistryException {
        if (this.userWorkflowRegistry != null) {
            this.userWorkflowRegistry.addWorkflow(workflowName, workflowGraphXml);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (this.isWorkflowExists(workflowName)) {
                throw new UserWorkflowAlreadyExistsException(workflowName);
            }
            UserWorkflowResource workflowResource = worker.createWorkflowTemplate(workflowName);
            workflowResource.setContent(workflowGraphXml);
            workflowResource.save();
        }
    }

    public void updateWorkflow(String workflowName, String workflowGraphXml) throws RegistryException {
        if (this.userWorkflowRegistry != null) {
            this.userWorkflowRegistry.updateWorkflow(workflowName, workflowGraphXml);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (!this.isWorkflowExists(workflowName)) {
                throw new UserWorkflowDoesNotExistsException(workflowName);
            }
            UserWorkflowResource workflowResource = worker.getWorkflowTemplate(workflowName);
            workflowResource.setContent(workflowGraphXml);
            workflowResource.save();
        }
    }

    public String getWorkflowGraphXML(String workflowName) throws RegistryException {
        if (this.userWorkflowRegistry != null) {
            return this.userWorkflowRegistry.getWorkflowGraphXML(workflowName);
        }
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkflowExists(workflowName)) {
            throw new UserWorkflowDoesNotExistsException(workflowName);
        }
        return worker.getWorkflowTemplate(workflowName).getContent();
    }

    public Map<String, String> getWorkflows() throws RegistryException {
        if (this.userWorkflowRegistry != null) {
            return this.userWorkflowRegistry.getWorkflows();
        }
        WorkerResource worker = this.jpa.getWorker();
        HashMap<String, String> workflows = new HashMap<String, String>();
        List<UserWorkflowResource> workflowTemplates = worker.getWorkflowTemplates();
        for (UserWorkflowResource resource : workflowTemplates) {
            workflows.put(resource.getName(), resource.getContent());
        }
        return workflows;
    }

    public void removeWorkflow(String workflowName) throws RegistryException {
        if (this.userWorkflowRegistry != null) {
            this.userWorkflowRegistry.removeWorkflow(workflowName);
        } else {
            WorkerResource worker = this.jpa.getWorker();
            if (!this.isWorkflowExists(workflowName)) {
                throw new UserWorkflowDoesNotExistsException(workflowName);
            }
            worker.removeWorkflowTemplate(workflowName);
        }
    }

    public ResourceMetadata getWorkflowMetadata(String workflowName) throws RegistryException {
        if (this.userWorkflowRegistry != null) {
            return this.userWorkflowRegistry.getWorkflowMetadata(workflowName);
        }
        throw new UnimplementedRegistryOperationException();
    }

    public void setAiravataRegistry(AiravataRegistry2 registry) {
    }

    public void setAiravataUser(AiravataUser user) {
        this.setUser(user);
    }

    public AiravataUser getAiravataUser() {
        return this.getUser();
    }

    public boolean isExperimentExists(String experimentId, boolean createIfNotPresent) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isExperimentExists(experimentId, createIfNotPresent);
        }
        if (this.jpa.getWorker().isExperimentExists(experimentId)) {
            return true;
        }
        if (createIfNotPresent) {
            if (!this.isWorkspaceProjectExists(DEFAULT_PROJECT_NAME, true)) {
                throw new WorkspaceProjectDoesNotExistsException(this.createProjName(DEFAULT_PROJECT_NAME));
            }
            AiravataExperiment experiment = new AiravataExperiment();
            experiment.setExperimentId(experimentId);
            experiment.setSubmittedDate(Calendar.getInstance().getTime());
            experiment.setGateway(this.getGateway());
            experiment.setUser(this.getUser());
            this.addExperiment(DEFAULT_PROJECT_NAME, experiment);
            return this.jpa.getWorker().isExperimentExists(experimentId);
        }
        return false;
    }

    public boolean isExperimentExists(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isExperimentExists(experimentId);
        }
        return this.isExperimentExists(experimentId, false);
    }

    public void updateExperimentExecutionUser(String experimentId, String user) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateExperimentExecutionUser(experimentId, user);
        } else {
            if (!this.isExperimentExists(experimentId, true)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
            ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
            ExperimentDataResource data = experiment.getData();
            data.setUserName(user);
            data.save();
        }
    }

    public String getExperimentExecutionUser(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentExecutionUser(experimentId);
        }
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        return experiment.getData().getUserName();
    }

    public boolean isExperimentNameExist(String experimentName) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isExperimentNameExist(experimentName);
        }
        return new ExperimentDataRetriever().isExperimentNameExist(experimentName);
    }

    public String getExperimentName(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentName(experimentId);
        }
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        return new ExperimentDataRetriever().getExperimentName(experimentId);
    }

    public void updateExperimentName(String experimentId, String experimentName) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateExperimentName(experimentId, experimentName);
        } else {
            if (!this.isExperimentExists(experimentId, true)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
            ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
            ExperimentDataResource data = experiment.getData();
            data.setExpName(experimentName);
            data.save();
        }
    }

    public String getExperimentMetadata(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentMetadata(experimentId);
        }
        if (!this.isExperimentExists(experimentId, true)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        if (data.isExperimentMetadataPresent()) {
            return data.getExperimentMetadata().getMetadata();
        }
        return null;
    }

    public void updateExperimentMetadata(String experimentId, String metadata) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateExperimentMetadata(experimentId, metadata);
        } else {
            ExperimentMetadataResource experimentMetadata;
            if (!this.isExperimentExists(experimentId, true)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
            ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
            ExperimentDataResource data = experiment.getData();
            if (data.isExperimentMetadataPresent()) {
                experimentMetadata = data.getExperimentMetadata();
                experimentMetadata.setMetadata(metadata);
            } else {
                experimentMetadata = data.createExperimentMetadata();
                experimentMetadata.setMetadata(metadata);
            }
            experimentMetadata.save();
        }
    }

    public String getWorkflowExecutionTemplateName(String workflowInstanceId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionTemplateName(workflowInstanceId);
        }
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId);
        return wi.getTemplateName();
    }

    public void setWorkflowInstanceTemplateName(String workflowInstanceId, String templateName) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.setWorkflowInstanceTemplateName(workflowInstanceId, templateName);
        } else {
            if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
                throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
            }
            WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId);
            wi.setTemplateName(templateName);
            wi.save();
        }
    }

    public List<WorkflowExecution> getExperimentWorkflowInstances(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentWorkflowInstances(experimentId);
        }
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        ArrayList<WorkflowExecution> result = new ArrayList<WorkflowExecution>();
        List<WorkflowDataResource> workflowInstances = data.getWorkflowInstances();
        for (WorkflowDataResource resource : workflowInstances) {
            WorkflowExecution workflowInstance = new WorkflowExecution(resource.getExperimentID(), resource.getWorkflowInstanceID());
            workflowInstance.setTemplateName(resource.getTemplateName());
            result.add(workflowInstance);
        }
        return result;
    }

    public boolean isWorkflowInstanceExists(String instanceId, boolean createIfNotPresent) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isWorkflowInstanceExists(instanceId, createIfNotPresent);
        }
        if (this.jpa.getWorker().isWorkflowInstancePresent(instanceId)) {
            return true;
        }
        if (createIfNotPresent) {
            if (!this.isExperimentExists(instanceId, true)) {
                throw new ExperimentDoesNotExistsException(instanceId);
            }
            this.addWorkflowInstance(instanceId, instanceId, null);
            return this.isWorkflowInstanceExists(instanceId);
        }
        return false;
    }

    public boolean isWorkflowInstanceExists(String instanceId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isWorkflowInstanceExists(instanceId);
        }
        return this.isWorkflowInstanceExists(instanceId, false);
    }

    public void updateWorkflowInstanceStatus(String instanceId, WorkflowExecutionStatus.State status) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowInstanceStatus(instanceId, status);
        } else {
            if (!this.isWorkflowInstanceExists(instanceId, true)) {
                throw new WorkflowInstanceDoesNotExistsException(instanceId);
            }
            WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(instanceId);
            Timestamp currentTime = new Timestamp(Calendar.getInstance().getTime().getTime());
            wi.setStatus(status.toString());
            if (status == WorkflowExecutionStatus.State.STARTED) {
                wi.setStartTime(currentTime);
            }
            wi.setLastUpdatedTime(currentTime);
            wi.save();
        }
    }

    public void updateWorkflowInstanceStatus(WorkflowExecutionStatus status) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowInstanceStatus(status);
        } else {
            if (!this.isWorkflowInstanceExists(status.getWorkflowInstance().getWorkflowExecutionId(), true)) {
                throw new WorkflowInstanceDoesNotExistsException(status.getWorkflowInstance().getWorkflowExecutionId());
            }
            WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(status.getWorkflowInstance().getWorkflowExecutionId());
            Timestamp currentTime = new Timestamp(status.getStatusUpdateTime().getTime());
            if (status.getExecutionStatus() != null) {
                wi.setStatus(status.getExecutionStatus().toString());
            }
            if (status.getExecutionStatus() == WorkflowExecutionStatus.State.STARTED) {
                wi.setStartTime(currentTime);
            }
            wi.setLastUpdatedTime(currentTime);
            wi.save();
        }
    }

    public WorkflowExecutionStatus getWorkflowInstanceStatus(String instanceId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceStatus(instanceId);
        }
        if (!this.isWorkflowInstanceExists(instanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(instanceId);
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(instanceId);
        return new WorkflowExecutionStatus(new WorkflowExecution(wi.getExperimentID(), wi.getWorkflowInstanceID()), wi.getStatus() == null ? null : WorkflowExecutionStatus.State.valueOf((String)wi.getStatus()), (Date)wi.getLastUpdatedTime());
    }

    public void updateWorkflowNodeInput(WorkflowInstanceNode node, String data) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeInput(node, data);
        } else {
            if (!this.isWorkflowInstanceNodePresent(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId(), true)) {
                throw new WorkflowInstanceNodeDoesNotExistsException(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId());
            }
            WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(node.getWorkflowInstance().getWorkflowExecutionId());
            NodeDataResource nodeData = wi.getNodeData(node.getNodeId());
            nodeData.setInputs(data);
            nodeData.save();
        }
    }

    public void updateWorkflowNodeOutput(WorkflowInstanceNode node, String data) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeOutput(node, data);
        } else {
            try {
                if (!this.isWorkflowInstanceNodePresent(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId(), true)) {
                    throw new WorkflowInstanceNodeDoesNotExistsException(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId());
                }
                WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(node.getWorkflowInstance().getWorkflowExecutionId());
                NodeDataResource nodeData = wi.getNodeData(node.getNodeId());
                nodeData.setOutputs(data);
                nodeData.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public List<WorkflowNodeIOData> searchWorkflowInstanceNodeInput(String experimentIdRegEx, String workflowNameRegEx, String nodeNameRegEx) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.searchWorkflowInstanceNodeInput(experimentIdRegEx, workflowNameRegEx, nodeNameRegEx);
        }
        return null;
    }

    public List<WorkflowNodeIOData> searchWorkflowInstanceNodeOutput(String experimentIdRegEx, String workflowNameRegEx, String nodeNameRegEx) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.searchWorkflowInstanceNodeOutput(experimentIdRegEx, workflowNameRegEx, nodeNameRegEx);
        }
        return null;
    }

    public List<WorkflowNodeIOData> getWorkflowInstanceNodeInput(String workflowInstanceId, String nodeType) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceNodeInput(workflowInstanceId, nodeType);
        }
        return null;
    }

    public List<WorkflowNodeIOData> getWorkflowInstanceNodeOutput(String workflowInstanceId, String nodeType) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceNodeOutput(workflowInstanceId, nodeType);
        }
        return null;
    }

    @Deprecated
    public void saveWorkflowExecutionOutput(String experimentId, String outputNodeName, String output) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.saveWorkflowExecutionOutput(experimentId, outputNodeName, output);
        }
    }

    @Deprecated
    public void saveWorkflowExecutionOutput(String experimentId, WorkflowIOData data) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.saveWorkflowExecutionOutput(experimentId, data);
        }
    }

    @Deprecated
    public WorkflowIOData getWorkflowExecutionOutput(String experimentId, String outputNodeName) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionOutput(experimentId, outputNodeName);
        }
        return null;
    }

    @Deprecated
    public List<WorkflowIOData> getWorkflowExecutionOutput(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionOutput(experimentId);
        }
        return null;
    }

    @Deprecated
    public String[] getWorkflowExecutionOutputNames(String exeperimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowExecutionOutputNames(exeperimentId);
        }
        return null;
    }

    public ExperimentData getExperiment(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperiment(experimentId);
        }
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        return new ExperimentDataRetriever().getExperiment(experimentId);
    }

    public List<String> getExperimentIdByUser(String user) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentIdByUser(user);
        }
        if (user == null) {
            user = this.jpa.getWorker().getUser();
        }
        return new ExperimentDataRetriever().getExperimentIdByUser(user);
    }

    public List<ExperimentData> getExperimentByUser(String user) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentByUser(user);
        }
        if (user == null) {
            user = this.jpa.getWorker().getUser();
        }
        return new ExperimentDataRetriever().getExperiments(user);
    }

    public List<ExperimentData> getExperimentByUser(String user, int pageSize, int pageNo) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentByUser(user, pageSize, pageNo);
        }
        return null;
    }

    public void updateWorkflowNodeStatus(NodeExecutionStatus workflowStatusNode) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeStatus(workflowStatusNode);
        } else {
            WorkflowExecution workflowInstance = workflowStatusNode.getWorkflowInstanceNode().getWorkflowInstance();
            String nodeId = workflowStatusNode.getWorkflowInstanceNode().getNodeId();
            if (!this.isWorkflowInstanceNodePresent(workflowInstance.getWorkflowExecutionId(), nodeId, true)) {
                throw new WorkflowInstanceNodeDoesNotExistsException(workflowInstance.getWorkflowExecutionId(), nodeId);
            }
            NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(workflowInstance.getWorkflowExecutionId()).getNodeData(nodeId);
            nodeData.setStatus(workflowStatusNode.getExecutionStatus().toString());
            Timestamp t = new Timestamp(workflowStatusNode.getStatusUpdateTime().getTime());
            if (workflowStatusNode.getExecutionStatus() == WorkflowExecutionStatus.State.STARTED) {
                nodeData.setStartTime(t);
            }
            nodeData.setLastUpdateTime(t);
            nodeData.save();
            WorkflowExecutionStatus currentWorkflowInstanceStatus = this.getWorkflowInstanceStatus(workflowInstance.getWorkflowExecutionId());
            this.updateWorkflowInstanceStatus(new WorkflowExecutionStatus(workflowInstance, currentWorkflowInstanceStatus.getExecutionStatus(), (Date)t));
        }
    }

    public void updateWorkflowNodeStatus(String workflowInstanceId, String nodeId, WorkflowExecutionStatus.State status) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeStatus(workflowInstanceId, nodeId, status);
        } else {
            this.updateWorkflowNodeStatus(new WorkflowInstanceNode(new WorkflowExecution(workflowInstanceId, workflowInstanceId), nodeId), status);
        }
    }

    public void updateWorkflowNodeStatus(WorkflowInstanceNode workflowNode, WorkflowExecutionStatus.State status) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeStatus(workflowNode, status);
        } else {
            this.updateWorkflowNodeStatus(new NodeExecutionStatus(workflowNode, status, Calendar.getInstance().getTime()));
        }
    }

    public NodeExecutionStatus getWorkflowNodeStatus(WorkflowInstanceNode workflowNode) throws RegistryException {
        String nodeId;
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowNodeStatus(workflowNode);
        }
        String id = workflowNode.getWorkflowInstance().getWorkflowExecutionId();
        if (!this.isWorkflowInstanceNodePresent(id, nodeId = workflowNode.getNodeId())) {
            throw new WorkflowInstanceNodeDoesNotExistsException(id, nodeId);
        }
        WorkflowDataResource workflowInstance = this.jpa.getWorker().getWorkflowInstance(id);
        NodeDataResource nodeData = workflowInstance.getNodeData(nodeId);
        return new NodeExecutionStatus(new WorkflowInstanceNode(new WorkflowExecution(workflowInstance.getExperimentID(), workflowInstance.getWorkflowInstanceID()), nodeData.getNodeID()), nodeData.getStatus() == null ? null : WorkflowExecutionStatus.State.valueOf((String)nodeData.getStatus()), (Date)nodeData.getLastUpdateTime());
    }

    public Date getWorkflowNodeStartTime(WorkflowInstanceNode workflowNode) throws RegistryException {
        String nodeId;
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowNodeStartTime(workflowNode);
        }
        String id = workflowNode.getWorkflowInstance().getWorkflowExecutionId();
        if (!this.isWorkflowInstanceNodePresent(id, nodeId = workflowNode.getNodeId())) {
            throw new WorkflowInstanceNodeDoesNotExistsException(id, nodeId);
        }
        WorkflowDataResource workflowInstance = this.jpa.getWorker().getWorkflowInstance(id);
        NodeDataResource nodeData = workflowInstance.getNodeData(nodeId);
        return nodeData.getStartTime();
    }

    public Date getWorkflowStartTime(WorkflowExecution workflowInstance) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowStartTime(workflowInstance);
        }
        if (!this.isWorkflowInstanceExists(workflowInstance.getWorkflowExecutionId(), true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstance.getWorkflowExecutionId());
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(workflowInstance.getWorkflowExecutionId());
        return wi.getStartTime();
    }

    public void updateWorkflowNodeGramData(WorkflowNodeGramData workflowNodeGramData) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeGramData(workflowNodeGramData);
        } else {
            if (!this.isWorkflowInstanceNodePresent(workflowNodeGramData.getWorkflowInstanceId(), workflowNodeGramData.getNodeID(), true)) {
                throw new WorkflowInstanceNodeDoesNotExistsException(workflowNodeGramData.getWorkflowInstanceId(), workflowNodeGramData.getNodeID());
            }
            WorkflowDataResource workflowInstance = this.jpa.getWorker().getWorkflowInstance(workflowNodeGramData.getWorkflowInstanceId());
            GramDataResource gramData = workflowInstance.isGramDataExists(workflowNodeGramData.getNodeID()) ? workflowInstance.getGramData(workflowNodeGramData.getNodeID()) : workflowInstance.createGramData(workflowNodeGramData.getNodeID());
            gramData.setInvokedHost(workflowNodeGramData.getInvokedHost());
            gramData.setLocalJobID(workflowNodeGramData.getGramJobID());
            gramData.setRsl(workflowNodeGramData.getRsl());
            gramData.save();
        }
    }

    public WorkflowExecutionData getWorkflowInstanceData(String workflowInstanceId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceData(workflowInstanceId);
        }
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        try {
            WorkflowDataResource resource = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId);
            WorkflowExecution workflowInstance = new WorkflowExecution(resource.getExperimentID(), resource.getWorkflowInstanceID());
            workflowInstance.setTemplateName(resource.getTemplateName());
            WorkflowExecutionDataImpl workflowInstanceData = new WorkflowExecutionDataImpl(null, workflowInstance, new WorkflowExecutionStatus(workflowInstance, resource.getStatus() == null ? null : WorkflowExecutionStatus.State.valueOf((String)resource.getStatus()), (Date)resource.getLastUpdatedTime()), null);
            List<NodeDataResource> nodeData = resource.getNodeData();
            for (NodeDataResource nodeDataResource : nodeData) {
                workflowInstanceData.getNodeDataList().add(this.getWorkflowInstanceNodeData(workflowInstanceId, nodeDataResource.getNodeID()));
            }
            return workflowInstanceData;
        }
        catch (ExperimentLazyLoadedException e) {
            throw new RegistryException((Throwable)e);
        }
    }

    public NodeExecutionData getWorkflowInstanceNodeData(String workflowInstanceId, String nodeId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getWorkflowInstanceNodeData(workflowInstanceId, nodeId);
        }
        if (!this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId)) {
            throw new WorkflowInstanceNodeDoesNotExistsException(workflowInstanceId, nodeId);
        }
        NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId).getNodeData(nodeId);
        NodeExecutionData data = new NodeExecutionData(new WorkflowInstanceNode(new WorkflowExecution(nodeData.getWorkflowDataResource().getExperimentID(), nodeData.getWorkflowDataResource().getWorkflowInstanceID()), nodeData.getNodeID()));
        data.setInput(nodeData.getInputs());
        data.setOutput(nodeData.getOutputs());
        data.setType(WorkflowNodeType.getType((String)nodeData.getNodeType()).getNodeType());
        return data;
    }

    public boolean isWorkflowInstanceNodePresent(String workflowInstanceId, String nodeId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId);
        }
        return this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId, false);
    }

    public boolean isWorkflowInstanceNodePresent(String workflowInstanceId, String nodeId, boolean createIfNotPresent) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId, createIfNotPresent);
        }
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        if (this.jpa.getWorker().getWorkflowInstance(workflowInstanceId).isNodeExists(nodeId)) {
            return true;
        }
        if (createIfNotPresent) {
            this.addWorkflowInstanceNode(workflowInstanceId, nodeId);
            return this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId);
        }
        return false;
    }

    public void addWorkflowInstance(String experimentId, String workflowInstanceId, String templateName) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.addWorkflowInstance(experimentId, workflowInstanceId, templateName);
        } else {
            if (!this.isExperimentExists(experimentId, true)) {
                throw new ExperimentDoesNotExistsException(experimentId);
            }
            if (this.isWorkflowInstanceExists(workflowInstanceId)) {
                throw new WorkflowInstanceAlreadyExistsException(workflowInstanceId);
            }
            ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
            ExperimentDataResource data = experiment.getData();
            WorkflowDataResource workflowInstanceResource = data.createWorkflowInstanceResource(workflowInstanceId);
            workflowInstanceResource.setTemplateName(templateName);
            workflowInstanceResource.save();
        }
    }

    public void updateWorkflowNodeType(WorkflowInstanceNode node, WorkflowNodeType type) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.updateWorkflowNodeType(node, type);
        } else {
            try {
                if (!this.isWorkflowInstanceNodePresent(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId(), true)) {
                    throw new WorkflowInstanceNodeDoesNotExistsException(node.getWorkflowInstance().getWorkflowExecutionId(), node.getNodeId());
                }
                NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(node.getWorkflowInstance().getWorkflowExecutionId()).getNodeData(node.getNodeId());
                nodeData.setNodeType(type.getNodeType().toString());
                nodeData.save();
            }
            catch (RegistryException e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    public void addWorkflowInstanceNode(String workflowInstanceId, String nodeId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            this.provenanceRegistry.addWorkflowInstanceNode(workflowInstanceId, nodeId);
        } else {
            if (this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId)) {
                throw new WorkflowInstanceNodeAlreadyExistsException(workflowInstanceId, nodeId);
            }
            NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId).createNodeData(nodeId);
            nodeData.save();
        }
    }

    public ExperimentData getExperimentMetaInformation(String experimentId) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getExperimentMetaInformation(experimentId);
        }
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getExperimentMetaInformation(experimentId);
    }

    public List<ExperimentData> getAllExperimentMetaInformation(String user) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.getAllExperimentMetaInformation(user);
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getAllExperimentMetaInformation(user);
    }

    public List<ExperimentData> searchExperiments(String user, String experimentNameRegex) throws RegistryException {
        if (this.provenanceRegistry != null) {
            return this.provenanceRegistry.searchExperiments(user, experimentNameRegex);
        }
        Pattern pattern = Pattern.compile(experimentNameRegex);
        ArrayList<ExperimentData> filteredExperiments = new ArrayList<ExperimentData>();
        List<ExperimentData> allExperimentMetaInformation = this.getAllExperimentMetaInformation(user);
        for (ExperimentData experimentData : allExperimentMetaInformation) {
            if (experimentData.getExperimentName() == null || !pattern.matcher(experimentData.getExperimentName()).find()) continue;
            filteredExperiments.add(experimentData);
        }
        return filteredExperiments;
    }

    public Version getVersion() {
        return API_VERSION;
    }

    public void setConnectionURI(URI connectionURI) {
        this.registryConnectionURI = connectionURI;
    }

    public URI getConnectionURI() {
        return this.registryConnectionURI;
    }

    public void setCallback(PasswordCallback callback) {
        this.callback = callback;
    }

    public PasswordCallback getCallback() {
        return this.callback;
    }
}

