/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ProjectResource.class);
    private String name;
    private GatewayResource gateway;
    private WorkerResource worker;

    public ProjectResource() {
    }

    public ProjectResource(WorkerResource worker, GatewayResource gateway, String projectName) {
        this.setWorker(worker);
        this.setGateway(gateway);
        this.name = projectName;
    }

    @Override
    public Resource create(ResourceType type) {
        if (type == ResourceType.EXPERIMENT) {
            ExperimentResource experimentResource = new ExperimentResource();
            experimentResource.setGateway(this.getGateway());
            experimentResource.setProject(this);
            experimentResource.setWorker(this.getWorker());
            return experimentResource;
        }
        logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for project resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) {
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        if (type != ResourceType.EXPERIMENT) {
            logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
            throw new IllegalArgumentException("Unsupported resource type for project resource.");
        }
        QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
        generator.setParameter("experiment_ID", name);
        Query q = generator.deleteQuery(em);
        q.executeUpdate();
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        if (type == ResourceType.EXPERIMENT) {
            EntityManager em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
            generator.setParameter("experiment_ID", name);
            Query q = generator.selectQuery(em);
            Experiment experiment = (Experiment)q.getSingleResult();
            ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
            em.getTransaction().commit();
            em.close();
            return experimentResource;
        }
        logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for project resource.");
    }

    public List<Resource> populate(Object[] keys) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        EntityManager em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        QueryGenerator queryGenerator = new QueryGenerator("Project", new Object[0][]);
        queryGenerator.setParameter("project_name", keys[0]);
        Query q = queryGenerator.selectQuery(em);
        List resultList = q.getResultList();
        if (resultList.size() != 0) {
            for (Object result : resultList) {
                Project project = (Project)result;
                ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                list.add(projectResource);
            }
        }
        em.getTransaction().commit();
        em.close();
        return list;
    }

    @Override
    public List<Resource> get(ResourceType type) {
        EntityManager em;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        if (type == ResourceType.EXPERIMENT) {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
            generator.setParameter("project_name", this.name);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            if (results.size() != 0) {
                for (Object result : results) {
                    Experiment experiment = (Experiment)result;
                    ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                    resourceList.add(experimentResource);
                }
            }
        } else {
            logger.error("Unsupported resource type for project resource.", (Throwable)new IllegalArgumentException());
            throw new IllegalArgumentException("Unsupported resource type for project resource.");
        }
        em.getTransaction().commit();
        em.close();
        return resourceList;
    }

    @Override
    public void save() {
        EntityManager em = ResourceUtils.getEntityManager();
        Project existingprojectResource = (Project)em.find(Project.class, (Object)this.name);
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Project project = new Project();
        project.setProject_name(this.name);
        Gateway modelGateway = (Gateway)em.find(Gateway.class, (Object)this.gateway.getGatewayName());
        project.setGateway(modelGateway);
        Users user = (Users)em.find(Users.class, (Object)this.worker.getUser());
        project.setUsers(user);
        if (existingprojectResource != null) {
            existingprojectResource.setGateway(modelGateway);
            existingprojectResource.setUsers(user);
            project = (Project)em.merge((Object)existingprojectResource);
        } else {
            em.persist((Object)project);
        }
        em.getTransaction().commit();
        em.close();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WorkerResource getWorker() {
        return this.worker;
    }

    public void setWorker(WorkerResource worker) {
        this.worker = worker;
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public boolean isExperimentExists(String experimentId) {
        return this.isExists(ResourceType.EXPERIMENT, experimentId);
    }

    public ExperimentResource createExperiment(String experimentId) {
        ExperimentResource experimentResource = (ExperimentResource)this.create(ResourceType.EXPERIMENT);
        experimentResource.setExpID(experimentId);
        return experimentResource;
    }

    public ExperimentResource getExperiment(String experimentId) {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, experimentId);
    }

    public List<ExperimentResource> getExperiments() {
        List<Resource> list = this.get(ResourceType.EXPERIMENT);
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        for (Resource resource : list) {
            result.add((ExperimentResource)resource);
        }
        return result;
    }

    public void removeExperiment(String experimentId) {
        this.remove(ResourceType.EXPERIMENT, experimentId);
    }
}

