/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Node_Data;
import org.apache.airavata.persistance.registry.jpa.model.Node_DataPK;
import org.apache.airavata.persistance.registry.jpa.model.Workflow_Data;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDataResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(NodeDataResource.class);
    private WorkflowDataResource workflowDataResource;
    private String nodeID;
    private String nodeType;
    private String inputs;
    private String outputs;
    private String status;
    private Timestamp startTime;
    private Timestamp lastUpdateTime;

    public WorkflowDataResource getWorkflowDataResource() {
        return this.workflowDataResource;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getInputs() {
        return this.inputs;
    }

    public String getOutputs() {
        return this.outputs;
    }

    public String getStatus() {
        return this.status;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setWorkflowDataResource(WorkflowDataResource workflowDataResource) {
        this.workflowDataResource = workflowDataResource;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setInputs(String inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(String outputs) {
        this.outputs = outputs;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public void setLastUpdateTime(Timestamp lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public Resource create(ResourceType type) {
        logger.error("Unsupported resource type for node data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) {
        logger.error("Unsupported resource type for node data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) {
        logger.error("Unsupported resource type for node data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) {
        logger.error("Unsupported resource type for node data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() {
        if (this.lastUpdateTime == null) {
            Date date = new Date();
            this.lastUpdateTime = new Timestamp(date.getTime());
        }
        EntityManager em = ResourceUtils.getEntityManager();
        Node_Data existingNodeData = (Node_Data)em.find(Node_Data.class, (Object)new Node_DataPK(this.workflowDataResource.getWorkflowInstanceID(), this.nodeID));
        em.close();
        em = ResourceUtils.getEntityManager();
        em.getTransaction().begin();
        Node_Data nodeData = new Node_Data();
        nodeData.setNode_id(this.nodeID);
        Workflow_Data workflow_data = (Workflow_Data)em.find(Workflow_Data.class, (Object)this.workflowDataResource.getWorkflowInstanceID());
        nodeData.setWorkflow_Data(workflow_data);
        byte[] inputsByte = null;
        if (this.inputs != null) {
            inputsByte = this.inputs.getBytes();
            nodeData.setInputs(inputsByte);
        }
        byte[] outputsByte = null;
        if (this.outputs != null) {
            outputsByte = this.outputs.getBytes();
            nodeData.setOutputs(outputsByte);
        }
        nodeData.setNode_type(this.nodeType);
        nodeData.setLast_update_time(this.lastUpdateTime);
        nodeData.setStart_time(this.startTime);
        nodeData.setStatus(this.status);
        if (existingNodeData != null) {
            existingNodeData.setInputs(inputsByte);
            existingNodeData.setOutputs(outputsByte);
            existingNodeData.setLast_update_time(this.lastUpdateTime);
            existingNodeData.setNode_type(this.nodeType);
            existingNodeData.setStart_time(this.startTime);
            existingNodeData.setStatus(this.status);
            nodeData = (Node_Data)em.merge((Object)existingNodeData);
        } else {
            em.persist((Object)nodeData);
        }
        em.getTransaction().commit();
        em.close();
    }
}

