/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.registry.api.exception.worker.ExperimentLazyLoadedException;
import org.apache.airavata.registry.api.impl.ExperimentDataImpl;
import org.apache.airavata.registry.api.workflow.ExperimentData;
import org.apache.airavata.registry.api.workflow.WorkflowInstance;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceData;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNodeData;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentDataRetriever {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentDataRetriever.class);

    public ExperimentData getExperiment(String experimentId) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<WorkflowInstance> experimentWorkflowInstances = new ArrayList<WorkflowInstance>();
        ExperimentDataImpl experimentData = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.experiment_ID, ed.name, ed.username, em.metadata, wd.workflow_instanceID, wd.template_name, wd.status, wd.start_time,wd.last_update_time, nd.node_id, nd.inputs, nd.outputs, e.project_name, e.submitted_date, nd.node_type, nd.status,nd.start_time, nd.last_update_time FROM Experiment e LEFT JOIN Experiment_Data ed ON e.experiment_ID = ed.experiment_ID LEFT JOIN Experiment_Metadata em ON ed.experiment_ID = em.experiment_ID  LEFT JOIN Workflow_Data wd ON e.experiment_ID = wd.experiment_ID LEFT JOIN Node_Data nd ON wd.workflow_instanceID = nd.workflow_instanceID WHERE e.experiment_ID ='" + experimentId + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    if (experimentData == null) {
                        experimentData = new ExperimentDataImpl();
                        experimentData.setExperimentId(rs.getString(1));
                        experimentData.setExperimentName(rs.getString(2));
                        experimentData.setUser(rs.getString(3));
                        experimentData.setMetadata(rs.getString(4));
                        experimentData.setTopic(rs.getString(1));
                    }
                    this.fillWorkflowInstanceData((ExperimentData)experimentData, rs, experimentWorkflowInstances);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExperimentLazyLoadedException e) {
            e.printStackTrace();
        }
        return experimentData;
    }

    private void fillWorkflowInstanceData(ExperimentData experimentData, ResultSet rs, List<WorkflowInstance> workflowInstances) throws SQLException, ExperimentLazyLoadedException, ParseException {
        WorkflowInstanceData workflowInstanceData = experimentData.getWorkflowInstance(rs.getString(5));
        if (workflowInstanceData == null) {
            WorkflowInstance workflowInstance = new WorkflowInstance(experimentData.getExperimentId(), rs.getString(5));
            workflowInstance.setTemplateName(rs.getString(6));
            workflowInstance.setExperimentId(rs.getString(1));
            workflowInstance.setWorkflowInstanceId(rs.getString(5));
            workflowInstances.add(workflowInstance);
            Date lastUpdateDate = this.getTime(rs.getString(9));
            String wdStatus = rs.getString(7);
            workflowInstanceData = new WorkflowInstanceData(null, workflowInstance, new WorkflowInstanceStatus(workflowInstance, this.createExecutionStatus(wdStatus), lastUpdateDate), null);
            workflowInstanceData.setExperimentData(experimentData);
            experimentData.getWorkflowInstanceData().add(workflowInstanceData);
        }
        WorkflowInstanceNode workflowInstanceNode = new WorkflowInstanceNode(workflowInstanceData.getWorkflowInstance(), rs.getString(10));
        WorkflowInstanceNodeData workflowInstanceNodeData = new WorkflowInstanceNodeData(workflowInstanceNode);
        workflowInstanceNodeData.setInput(rs.getString(11));
        workflowInstanceNodeData.setOutput(rs.getString(12));
        workflowInstanceNodeData.setStatus(this.createExecutionStatus(rs.getString(16)), this.getTime(rs.getString(18)));
        workflowInstanceData.getNodeDataList().add(workflowInstanceNodeData);
    }

    private WorkflowInstanceStatus.ExecutionStatus createExecutionStatus(String status) {
        return status == null ? WorkflowInstanceStatus.ExecutionStatus.UNKNOWN : WorkflowInstanceStatus.ExecutionStatus.valueOf((String)status);
    }

    private Date getTime(String date) throws ParseException {
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return dateFormat.parse(date);
        }
        return null;
    }

    public List<String> getExperimentIdByUser(String user) {
        ArrayList<String> result = new ArrayList<String>();
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        Statement statement = null;
        try {
            String jdbcDriver = Utils.getJDBCDriver();
            Class.forName(jdbcDriver).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            statement = connection.createStatement();
            String queryString = "SELECT ed.experiment_ID FROM Experiment_Data ed LEFT JOIN Experiment e ON ed.experiment_ID = e.experiment_ID WHERE ed.username ='" + user + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getExperimentName(String experimentId) {
        String connectionURL = Utils.getJDBCURL();
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            Connection connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT ed.name FROM Experiment e LEFT JOIN Experiment_Data ed ON e.experiment_ID = ed.experiment_ID WHERE e.experiment_ID='" + experimentId + "'";
            ResultSet rs = statement.executeQuery(queryString);
            if (rs != null && rs.next()) {
                return rs.getString(1);
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public List<ExperimentData> getExperiments(String user) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        HashMap<String, ExperimentDataImpl> experimentDataMap = new HashMap<String, ExperimentDataImpl>();
        ArrayList<ExperimentData> experimentDataList = new ArrayList<ExperimentData>();
        ArrayList<WorkflowInstance> experimentWorkflowInstances = new ArrayList<WorkflowInstance>();
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.experiment_ID, ed.name, ed.username, em.metadata, wd.workflow_instanceID, wd.template_name, wd.status, wd.start_time,wd.last_update_time, nd.node_id, nd.inputs, nd.outputs, e.project_name, e.submitted_date, nd.node_type, nd.status,nd.start_time, nd.last_update_time FROM Experiment e INNER JOIN Experiment_Data ed ON e.experiment_ID = ed.experiment_ID LEFT JOIN Experiment_Metadata em ON ed.experiment_ID = em.experiment_ID  LEFT JOIN Workflow_Data wd ON e.experiment_ID = wd.experiment_ID LEFT JOIN Node_Data nd ON wd.workflow_instanceID = nd.workflow_instanceID WHERE ed.username='" + user + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    ExperimentDataImpl experimentData = null;
                    if (experimentDataMap.containsKey(rs.getString(1))) {
                        experimentData = (ExperimentData)experimentDataMap.get(rs.getString(1));
                    } else {
                        experimentData = new ExperimentDataImpl();
                        experimentData.setExperimentId(rs.getString(1));
                        experimentData.setExperimentName(rs.getString(2));
                        experimentData.setUser(rs.getString(3));
                        experimentData.setMetadata(rs.getString(4));
                        experimentData.setTopic(rs.getString(1));
                        experimentDataMap.put(experimentData.getExperimentId(), experimentData);
                        experimentDataList.add((ExperimentData)experimentData);
                    }
                    this.fillWorkflowInstanceData((ExperimentData)experimentData, rs, experimentWorkflowInstances);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ExperimentLazyLoadedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return experimentDataList;
    }

    public ExperimentData getExperimentMetaInformation(String experimentId) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<WorkflowInstance> experimentWorkflowInstances = new ArrayList<WorkflowInstance>();
        ExperimentDataImpl experimentData = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.experiment_ID, ed.name, ed.username, em.metadata, e.project_name, e.submitted_date FROM Experiment e LEFT JOIN Experiment_Data ed ON e.experiment_ID = ed.experiment_ID LEFT JOIN Experiment_Metadata em ON ed.experiment_ID = em.experiment_ID  WHERE e.experiment_ID ='" + experimentId + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    experimentData = new ExperimentDataImpl(true);
                    experimentData.setExperimentId(rs.getString(1));
                    experimentData.setExperimentName(rs.getString(2));
                    experimentData.setUser(rs.getString(3));
                    experimentData.setMetadata(rs.getString(4));
                    experimentData.setTopic(rs.getString(1));
                    WorkflowInstance workflowInstance = new WorkflowInstance(experimentId, rs.getString(5));
                    workflowInstance.setTemplateName(rs.getString(6));
                    workflowInstance.setExperimentId(rs.getString(1));
                    workflowInstance.setWorkflowInstanceId(rs.getString(5));
                    experimentWorkflowInstances.add(workflowInstance);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return experimentData;
    }

    public boolean isExperimentNameExist(String experimentName) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT name FROM Experiment_Data WHERE name='" + experimentName + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null && rs.next()) {
                return true;
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public List<ExperimentData> getAllExperimentMetaInformation(String user) {
        String connectionURL = Utils.getJDBCURL();
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<ExperimentData> experimentDataList = new ArrayList<ExperimentData>();
        ArrayList<WorkflowInstance> experimentWorkflowInstances = new ArrayList<WorkflowInstance>();
        ExperimentDataImpl experimentData = null;
        try {
            Class.forName(Utils.getJDBCDriver()).newInstance();
            connection = DriverManager.getConnection(connectionURL, Utils.getJDBCUser(), Utils.getJDBCPassword());
            Statement statement = connection.createStatement();
            String queryString = "SELECT e.experiment_ID, ed.name, ed.username, em.metadata, e.project_name, e.submitted_date FROM Experiment e LEFT JOIN Experiment_Data ed ON e.experiment_ID = ed.experiment_ID LEFT JOIN Experiment_Metadata em ON ed.experiment_ID = em.experiment_ID  WHERE ed.username ='" + user + "'";
            rs = statement.executeQuery(queryString);
            if (rs != null) {
                while (rs.next()) {
                    experimentData = new ExperimentDataImpl(true);
                    experimentData.setExperimentId(rs.getString(1));
                    experimentData.setExperimentName(rs.getString(2));
                    experimentData.setUser(rs.getString(3));
                    experimentData.setMetadata(rs.getString(4));
                    experimentData.setTopic(rs.getString(1));
                    WorkflowInstance workflowInstance = new WorkflowInstance(rs.getString(1), rs.getString(5));
                    workflowInstance.setTemplateName(rs.getString(6));
                    workflowInstance.setExperimentId(rs.getString(1));
                    workflowInstance.setWorkflowInstanceId(rs.getString(5));
                    experimentWorkflowInstances.add(workflowInstance);
                    experimentDataList.add((ExperimentData)experimentData);
                }
            }
            if (rs != null) {
                rs.close();
            }
            statement.close();
            connection.close();
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return experimentDataList;
    }
}

