/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.commons.gfac.type.ApplicationDeploymentDescription;
import org.apache.airavata.commons.gfac.type.HostDescription;
import org.apache.airavata.commons.gfac.type.ServiceDescription;
import org.apache.airavata.persistance.registry.jpa.JPAResourceAccessor;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigurationResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentDataRetriever;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentMetadataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.GramDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.HostDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeDataResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.PublishWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.ServiceDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowDataResource;
import org.apache.airavata.registry.api.AiravataExperiment;
import org.apache.airavata.registry.api.AiravataRegistry2;
import org.apache.airavata.registry.api.AiravataUser;
import org.apache.airavata.registry.api.Gateway;
import org.apache.airavata.registry.api.ProjectsRegistry;
import org.apache.airavata.registry.api.ResourceMetadata;
import org.apache.airavata.registry.api.WorkspaceProject;
import org.apache.airavata.registry.api.exception.RegistryException;
import org.apache.airavata.registry.api.exception.UnimplementedRegistryOperationException;
import org.apache.airavata.registry.api.exception.gateway.DescriptorAlreadyExistsException;
import org.apache.airavata.registry.api.exception.gateway.DescriptorDoesNotExistsException;
import org.apache.airavata.registry.api.exception.gateway.InsufficientDataException;
import org.apache.airavata.registry.api.exception.gateway.MalformedDescriptorException;
import org.apache.airavata.registry.api.exception.gateway.PublishedWorkflowAlreadyExistsException;
import org.apache.airavata.registry.api.exception.gateway.PublishedWorkflowDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.ExperimentDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.UserWorkflowAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.UserWorkflowDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceNodeAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkflowInstanceNodeDoesNotExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkspaceProjectAlreadyExistsException;
import org.apache.airavata.registry.api.exception.worker.WorkspaceProjectDoesNotExistsException;
import org.apache.airavata.registry.api.workflow.ExperimentData;
import org.apache.airavata.registry.api.workflow.WorkflowIOData;
import org.apache.airavata.registry.api.workflow.WorkflowInstance;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceData;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNode;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNodeData;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceNodeStatus;
import org.apache.airavata.registry.api.workflow.WorkflowInstanceStatus;
import org.apache.airavata.registry.api.workflow.WorkflowNodeGramData;
import org.apache.airavata.registry.api.workflow.WorkflowNodeIOData;
import org.apache.airavata.registry.api.workflow.WorkflowNodeType;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataJPARegistry
extends AiravataRegistry2 {
    private static final Logger logger = LoggerFactory.getLogger(AiravataJPARegistry.class);
    private JPAResourceAccessor jpa;
    private boolean active = false;
    private static final String DEFAULT_PROJECT_NAME = "default";
    private static final String GFAC_URL = "gfac.url";
    private static final String INTERPRETER_URL = "interpreter.url";
    private static final String MESSAGE_BOX_URL = "messagebox.url";
    private static final String EVENTING_URL = "eventing.url";

    protected void initialize() {
        this.jpa = new JPAResourceAccessor(this);
        this.active = true;
    }

    public boolean isActive() {
        return this.active;
    }

    public Object getConfiguration(String key) {
        ConfigurationResource configuration = ResourceUtils.getConfiguration(key);
        return configuration == null ? null : configuration.getConfigVal();
    }

    public List<Object> getConfigurationList(String key) {
        ArrayList<Object> values = new ArrayList<Object>();
        List<ConfigurationResource> configurations = ResourceUtils.getConfigurations(key);
        for (ConfigurationResource configurationResource : configurations) {
            values.add(configurationResource.getConfigVal());
        }
        return values;
    }

    public void setConfiguration(String key, String value, Date expire) {
        ConfigurationResource config = ResourceUtils.isConfigurationExist(key) ? ResourceUtils.getConfiguration(key) : ResourceUtils.createConfiguration(key);
        config.setConfigVal(value);
        config.setExpireDate(new Timestamp(expire.getTime()));
        config.save();
    }

    public void addConfiguration(String key, String value, Date expire) {
        ConfigurationResource config = ResourceUtils.createConfiguration(key);
        config.setConfigVal(value);
        config.setExpireDate(new Timestamp(expire.getTime()));
        config.save();
    }

    public void removeAllConfiguration(String key) {
        ResourceUtils.removeConfiguration(key);
    }

    public void removeConfiguration(String key, String value) {
        ResourceUtils.removeConfiguration(key, value);
    }

    public List<URI> getGFacURIs() {
        return this.retrieveURIsFromConfiguration(GFAC_URL);
    }

    private List<URI> retrieveURIsFromConfiguration(String urlType) {
        ArrayList<URI> urls = new ArrayList<URI>();
        List<Object> configurationList = this.getConfigurationList(urlType);
        for (Object o : configurationList) {
            try {
                urls.add(new URI(o.toString()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return urls;
    }

    public List<URI> getWorkflowInterpreterURIs() {
        return this.retrieveURIsFromConfiguration(INTERPRETER_URL);
    }

    public URI getEventingServiceURI() {
        List<URI> eventingURLs = this.retrieveURIsFromConfiguration(EVENTING_URL);
        return eventingURLs.size() == 0 ? null : eventingURLs.get(0);
    }

    public URI getMessageBoxURI() {
        List<URI> messageboxURLs = this.retrieveURIsFromConfiguration(MESSAGE_BOX_URL);
        return messageboxURLs.size() == 0 ? null : messageboxURLs.get(0);
    }

    public void addGFacURI(URI uri) {
        this.addConfigurationURL(GFAC_URL, uri);
    }

    private void addConfigurationURL(String urlType, URI uri) {
        Calendar instance = Calendar.getInstance();
        instance.add(12, 180);
        Date expire = instance.getTime();
        this.addConfigurationURL(urlType, uri, expire);
    }

    private void addConfigurationURL(String urlType, URI uri, Date expire) {
        this.addConfiguration(urlType, uri.toString(), expire);
    }

    public void addWorkflowInterpreterURI(URI uri) {
        this.addConfigurationURL(INTERPRETER_URL, uri);
    }

    public void setEventingURI(URI uri) {
        this.addConfigurationURL(EVENTING_URL, uri);
    }

    public void setMessageBoxURI(URI uri) {
        this.addConfigurationURL(MESSAGE_BOX_URL, uri);
    }

    public void addGFacURI(URI uri, Date expire) {
        this.addConfigurationURL(GFAC_URL, uri, expire);
    }

    public void addWorkflowInterpreterURI(URI uri, Date expire) {
        this.addConfigurationURL(INTERPRETER_URL, uri, expire);
    }

    public void setEventingURI(URI uri, Date expire) {
        this.addConfigurationURL(EVENTING_URL, uri, expire);
    }

    public void setMessageBoxURI(URI uri, Date expire) {
        this.addConfigurationURL(MESSAGE_BOX_URL, uri, expire);
    }

    public void removeGFacURI(URI uri) {
        this.removeConfiguration(GFAC_URL, uri.toString());
    }

    public void removeWorkflowInterpreterURI(URI uri) {
        this.removeConfiguration(INTERPRETER_URL, uri.toString());
    }

    public void removeAllGFacURI() {
        this.removeAllConfiguration(GFAC_URL);
    }

    public void removeAllWorkflowInterpreterURI() {
        this.removeAllConfiguration(INTERPRETER_URL);
    }

    public void unsetEventingURI() {
        this.removeAllConfiguration(EVENTING_URL);
    }

    public void unsetMessageBoxURI() {
        this.removeAllConfiguration(MESSAGE_BOX_URL);
    }

    public boolean isHostDescriptorExists(String descriptorName) throws RegistryException {
        return this.jpa.getGateway().isHostDescriptorExists(descriptorName);
    }

    public void addHostDescriptor(HostDescription descriptor) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        WorkerResource workerResource = this.jpa.getWorker();
        String hostName = descriptor.getType().getHostName();
        if (this.isHostDescriptorExists(hostName)) {
            throw new DescriptorAlreadyExistsException(hostName);
        }
        HostDescriptorResource hostDescriptorResource = gateway.createHostDescriptorResource(hostName);
        hostDescriptorResource.setUserName(workerResource.getUser());
        hostDescriptorResource.setContent(descriptor.toXML());
        hostDescriptorResource.save();
    }

    public void updateHostDescriptor(HostDescription descriptor) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        String hostName = descriptor.getType().getHostName();
        if (!this.isHostDescriptorExists(hostName)) {
            throw new DescriptorDoesNotExistsException(hostName);
        }
        HostDescriptorResource hostDescriptorResource = gateway.getHostDescriptorResource(hostName);
        hostDescriptorResource.setContent(descriptor.toXML());
        hostDescriptorResource.save();
    }

    public HostDescription getHostDescriptor(String hostName) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isHostDescriptorExists(hostName)) {
            return null;
        }
        HostDescriptorResource hostDescriptorResource = gateway.getHostDescriptorResource(hostName);
        return this.createHostDescriptor(hostDescriptorResource);
    }

    private HostDescription createHostDescriptor(HostDescriptorResource hostDescriptorResource) throws MalformedDescriptorException {
        try {
            return HostDescription.fromXML((String)hostDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(hostDescriptorResource.getHostDescName(), (Throwable)e);
        }
    }

    public void removeHostDescriptor(String hostName) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isHostDescriptorExists(hostName)) {
            throw new DescriptorDoesNotExistsException(hostName);
        }
        gateway.removeHostDescriptor(hostName);
    }

    public List<HostDescription> getHostDescriptors() throws MalformedDescriptorException, RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        ArrayList<HostDescription> list = new ArrayList<HostDescription>();
        List<HostDescriptorResource> hostDescriptorResources = gateway.getHostDescriptorResources();
        for (HostDescriptorResource resource : hostDescriptorResources) {
            list.add(this.createHostDescriptor(resource));
        }
        return list;
    }

    public ResourceMetadata getHostDescriptorMetadata(String hostName) throws RegistryException {
        throw new UnimplementedRegistryOperationException();
    }

    public boolean isServiceDescriptorExists(String descriptorName) throws RegistryException {
        return this.jpa.getGateway().isServiceDescriptorExists(descriptorName);
    }

    public void addServiceDescriptor(ServiceDescription descriptor) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        WorkerResource workerResource = this.jpa.getWorker();
        String serviceName = descriptor.getType().getName();
        if (this.isServiceDescriptorExists(serviceName)) {
            throw new DescriptorAlreadyExistsException(serviceName);
        }
        ServiceDescriptorResource serviceDescriptorResource = gateway.createServiceDescriptorResource(serviceName);
        serviceDescriptorResource.setUserName(workerResource.getUser());
        serviceDescriptorResource.setContent(descriptor.toXML());
        serviceDescriptorResource.save();
    }

    public void updateServiceDescriptor(ServiceDescription descriptor) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        String serviceName = descriptor.getType().getName();
        if (!this.isServiceDescriptorExists(serviceName)) {
            throw new DescriptorDoesNotExistsException(serviceName);
        }
        ServiceDescriptorResource serviceDescriptorResource = gateway.getServiceDescriptorResource(serviceName);
        serviceDescriptorResource.setContent(descriptor.toXML());
        serviceDescriptorResource.save();
    }

    public ServiceDescription getServiceDescriptor(String serviceName) throws DescriptorDoesNotExistsException, MalformedDescriptorException {
        GatewayResource gateway = this.jpa.getGateway();
        if (!gateway.isServiceDescriptorExists(serviceName)) {
            return null;
        }
        ServiceDescriptorResource serviceDescriptorResource = gateway.getServiceDescriptorResource(serviceName);
        return this.createServiceDescriptor(serviceDescriptorResource);
    }

    private ServiceDescription createServiceDescriptor(ServiceDescriptorResource serviceDescriptorResource) throws MalformedDescriptorException {
        try {
            return ServiceDescription.fromXML((String)serviceDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(serviceDescriptorResource.getServiceDescName(), (Throwable)e);
        }
    }

    public void removeServiceDescriptor(String serviceName) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isServiceDescriptorExists(serviceName)) {
            throw new DescriptorDoesNotExistsException(serviceName);
        }
        gateway.removeServiceDescriptor(serviceName);
    }

    public List<ServiceDescription> getServiceDescriptors() throws MalformedDescriptorException, RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        ArrayList<ServiceDescription> list = new ArrayList<ServiceDescription>();
        List<ServiceDescriptorResource> serviceDescriptorResources = gateway.getServiceDescriptorResources();
        for (ServiceDescriptorResource resource : serviceDescriptorResources) {
            list.add(this.createServiceDescriptor(resource));
        }
        return list;
    }

    public ResourceMetadata getServiceDescriptorMetadata(String serviceName) throws UnimplementedRegistryOperationException {
        throw new UnimplementedRegistryOperationException();
    }

    private String createAppName(String serviceName, String hostName, String applicationName) {
        return serviceName + "/" + hostName + "/" + applicationName;
    }

    public boolean isApplicationDescriptorExists(String serviceName, String hostName, String descriptorName) throws RegistryException {
        return this.jpa.getGateway().isApplicationDescriptorExists(this.createAppName(serviceName, hostName, descriptorName));
    }

    public void addApplicationDescriptor(ServiceDescription serviceDescription, HostDescription hostDescriptor, ApplicationDeploymentDescription descriptor) throws RegistryException {
        this.addApplicationDescriptor(serviceDescription.getType().getName(), hostDescriptor.getType().getHostName(), descriptor);
    }

    public void addApplicationDescriptor(String serviceName, String hostName, ApplicationDeploymentDescription descriptor) throws RegistryException {
        if (serviceName == null || hostName == null) {
            throw new InsufficientDataException("Service name or Host name cannot be null");
        }
        GatewayResource gateway = this.jpa.getGateway();
        WorkerResource workerResource = this.jpa.getWorker();
        String applicationName = descriptor.getType().getApplicationName().getStringValue();
        applicationName = this.createAppName(serviceName, hostName, applicationName);
        if (this.isApplicationDescriptorExists(serviceName, hostName, descriptor.getType().getApplicationName().getStringValue())) {
            throw new DescriptorAlreadyExistsException(applicationName);
        }
        ApplicationDescriptorResource applicationDescriptorResource = gateway.createApplicationDescriptorResource(applicationName);
        applicationDescriptorResource.setUpdatedUser(workerResource.getUser());
        applicationDescriptorResource.setServiceDescName(serviceName);
        applicationDescriptorResource.setHostDescName(hostName);
        applicationDescriptorResource.setContent(descriptor.toXML());
        applicationDescriptorResource.save();
    }

    public void udpateApplicationDescriptor(ServiceDescription serviceDescription, HostDescription hostDescriptor, ApplicationDeploymentDescription descriptor) throws RegistryException {
        this.updateApplicationDescriptor(serviceDescription.getType().getName(), hostDescriptor.getType().getHostName(), descriptor);
    }

    public void updateApplicationDescriptor(String serviceName, String hostName, ApplicationDeploymentDescription descriptor) throws RegistryException {
        if (serviceName == null || hostName == null) {
            throw new InsufficientDataException("Service name or Host name cannot be null");
        }
        GatewayResource gateway = this.jpa.getGateway();
        String applicationName = descriptor.getType().getApplicationName().getStringValue();
        applicationName = this.createAppName(serviceName, hostName, applicationName);
        if (!this.isApplicationDescriptorExists(serviceName, hostName, descriptor.getType().getApplicationName().getStringValue())) {
            throw new DescriptorDoesNotExistsException(applicationName);
        }
        ApplicationDescriptorResource serviceDescriptorResource = gateway.getApplicationDescriptorResource(applicationName);
        serviceDescriptorResource.setContent(descriptor.toXML());
        serviceDescriptorResource.save();
    }

    private ApplicationDeploymentDescription createApplicationDescriptor(ApplicationDescriptorResource applicationDescriptorResource) throws MalformedDescriptorException {
        try {
            return ApplicationDeploymentDescription.fromXML((String)applicationDescriptorResource.getContent());
        }
        catch (XmlException e) {
            throw new MalformedDescriptorException(applicationDescriptorResource.getName(), (Throwable)e);
        }
    }

    public ApplicationDeploymentDescription getApplicationDescriptor(String serviceName, String hostname, String applicationName) throws DescriptorDoesNotExistsException, MalformedDescriptorException, RegistryException {
        if (serviceName == null || hostname == null) {
            throw new InsufficientDataException("Service name or Host name cannot be null");
        }
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isApplicationDescriptorExists(serviceName, hostname, applicationName)) {
            throw new DescriptorDoesNotExistsException(this.createAppName(serviceName, hostname, applicationName));
        }
        return this.createApplicationDescriptor(gateway.getApplicationDescriptorResource(this.createAppName(serviceName, hostname, applicationName)));
    }

    public ApplicationDeploymentDescription getApplicationDescriptors(String serviceName, String hostname) throws MalformedDescriptorException {
        GatewayResource gateway = this.jpa.getGateway();
        List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources(serviceName, hostname);
        if (applicationDescriptorResources.size() > 0) {
            return this.createApplicationDescriptor(applicationDescriptorResources.get(0));
        }
        return null;
    }

    public Map<String, ApplicationDeploymentDescription> getApplicationDescriptors(String serviceName) throws MalformedDescriptorException {
        GatewayResource gateway = this.jpa.getGateway();
        HashMap<String, ApplicationDeploymentDescription> map = new HashMap<String, ApplicationDeploymentDescription>();
        List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources(serviceName, null);
        for (ApplicationDescriptorResource resource : applicationDescriptorResources) {
            map.put(resource.getHostDescName(), this.createApplicationDescriptor(resource));
        }
        return map;
    }

    public Map<String[], ApplicationDeploymentDescription> getApplicationDescriptors() throws MalformedDescriptorException, RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        HashMap<String[], ApplicationDeploymentDescription> map = new HashMap<String[], ApplicationDeploymentDescription>();
        List<ApplicationDescriptorResource> applicationDescriptorResources = gateway.getApplicationDescriptorResources();
        for (ApplicationDescriptorResource resource : applicationDescriptorResources) {
            map.put(new String[]{resource.getServiceDescName(), resource.getHostDescName()}, this.createApplicationDescriptor(resource));
        }
        return map;
    }

    public void removeApplicationDescriptor(String serviceName, String hostName, String applicationName) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        String appName = this.createAppName(serviceName, hostName, applicationName);
        if (!this.isApplicationDescriptorExists(serviceName, hostName, applicationName)) {
            throw new DescriptorDoesNotExistsException(appName);
        }
        gateway.removeApplicationDescriptor(appName);
    }

    public ResourceMetadata getApplicationDescriptorMetadata(String serviceName, String hostName, String applicationName) throws UnimplementedRegistryOperationException {
        throw new UnimplementedRegistryOperationException();
    }

    private String createProjName(String projectName) {
        return this.createProjName(this.getGateway().getGatewayName(), this.getUser().getUserName(), projectName);
    }

    private String createProjName(String gatewayName, String userName, String projectName) {
        return gatewayName + "\n" + userName + "\n" + projectName;
    }

    private String getProjName(String projectLongName) {
        String[] s = projectLongName.split("\n");
        return s[s.length - 1];
    }

    public boolean isWorkspaceProjectExists(String projectName) throws RegistryException {
        return this.isWorkspaceProjectExists(projectName, false);
    }

    public boolean isWorkspaceProjectExists(String projectName, boolean createIfNotExists) throws RegistryException {
        if (this.jpa.getWorker().isProjectExists(this.createProjName(projectName))) {
            return true;
        }
        if (createIfNotExists) {
            this.addWorkspaceProject(new WorkspaceProject(projectName, (ProjectsRegistry)this));
            return this.isWorkspaceProjectExists(projectName);
        }
        return false;
    }

    public void addWorkspaceProject(WorkspaceProject project) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (this.isWorkspaceProjectExists(project.getProjectName())) {
            throw new WorkspaceProjectAlreadyExistsException(this.createProjName(project.getProjectName()));
        }
        ProjectResource projectResource = worker.createProject(this.createProjName(project.getProjectName()));
        projectResource.save();
    }

    public void updateWorkspaceProject(WorkspaceProject project) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkspaceProjectExists(project.getProjectName())) {
            throw new WorkspaceProjectDoesNotExistsException(this.createProjName(project.getProjectName()));
        }
        ProjectResource projectResource = worker.getProject(this.createProjName(project.getProjectName()));
        projectResource.save();
    }

    public void deleteWorkspaceProject(String projectName) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkspaceProjectExists(projectName)) {
            throw new WorkspaceProjectDoesNotExistsException(this.createProjName(projectName));
        }
        worker.removeProject(this.createProjName(projectName));
    }

    public WorkspaceProject getWorkspaceProject(String projectName) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkspaceProjectExists(projectName)) {
            throw new WorkspaceProjectDoesNotExistsException(this.createProjName(projectName));
        }
        ProjectResource projectResource = worker.getProject(this.createProjName(projectName));
        return new WorkspaceProject(this.getProjName(projectResource.getName()), (ProjectsRegistry)this);
    }

    public List<WorkspaceProject> getWorkspaceProjects() throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        ArrayList<WorkspaceProject> projects = new ArrayList<WorkspaceProject>();
        List<ProjectResource> projectResouces = worker.getProjects();
        for (ProjectResource resource : projectResouces) {
            projects.add(new WorkspaceProject(this.getProjName(resource.getName()), (ProjectsRegistry)this));
        }
        return projects;
    }

    public void addExperiment(String projectName, AiravataExperiment experiment) throws RegistryException {
        WorkspaceProject workspaceProject = this.getWorkspaceProject(projectName);
        ProjectResource project = this.jpa.getWorker().getProject(this.createProjName(workspaceProject.getProjectName()));
        String experimentId = experiment.getExperimentId();
        if (this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experimentResource = project.createExperiment(experimentId);
        if (experiment.getSubmittedDate() != null) {
            experimentResource.setSubmittedDate(new Timestamp(experiment.getSubmittedDate().getTime()));
        }
        experimentResource.save();
    }

    public void removeExperiment(String experimentId) throws ExperimentDoesNotExistsException {
        WorkerResource worker = this.jpa.getWorker();
        if (!worker.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        worker.removeExperiment(experimentId);
    }

    public List<AiravataExperiment> getExperiments() throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        ArrayList<AiravataExperiment> result = new ArrayList<AiravataExperiment>();
        List<ExperimentResource> experiments = worker.getExperiments();
        for (ExperimentResource resource : experiments) {
            AiravataExperiment e = this.createAiravataExperimentObj(resource);
            result.add(e);
        }
        return result;
    }

    private AiravataExperiment createAiravataExperimentObj(ExperimentResource resource) {
        AiravataExperiment e = new AiravataExperiment();
        e.setExperimentId(resource.getExpID());
        e.setUser(new AiravataUser(resource.getWorker().getUser()));
        e.setSubmittedDate(new Date(resource.getSubmittedDate().getTime()));
        e.setGateway(new Gateway(resource.getGateway().getGatewayName()));
        e.setProject(new WorkspaceProject(this.getProjName(resource.getProject().getName()), (ProjectsRegistry)this));
        return e;
    }

    public List<AiravataExperiment> getExperiments(String projectName) throws RegistryException {
        ProjectResource project = this.jpa.getWorker().getProject(this.createProjName(projectName));
        List<ExperimentResource> experiments = project.getExperiments();
        ArrayList<AiravataExperiment> result = new ArrayList<AiravataExperiment>();
        for (ExperimentResource resource : experiments) {
            AiravataExperiment e = this.createAiravataExperimentObj(resource);
            result.add(e);
        }
        return result;
    }

    public List<AiravataExperiment> getExperiments(Date from, Date to) throws RegistryException {
        List<AiravataExperiment> experiments = this.getExperiments();
        ArrayList<AiravataExperiment> newExperiments = new ArrayList<AiravataExperiment>();
        for (AiravataExperiment exp : experiments) {
            Date submittedDate = exp.getSubmittedDate();
            if (!submittedDate.after(from) || !submittedDate.before(to)) continue;
            newExperiments.add(exp);
        }
        return newExperiments;
    }

    public List<AiravataExperiment> getExperiments(String projectName, Date from, Date to) throws RegistryException {
        List<AiravataExperiment> experiments = this.getExperiments(projectName);
        ArrayList<AiravataExperiment> newExperiments = new ArrayList<AiravataExperiment>();
        for (AiravataExperiment exp : experiments) {
            Date submittedDate = exp.getSubmittedDate();
            if (!submittedDate.after(from) || !submittedDate.before(to)) continue;
            newExperiments.add(exp);
        }
        return newExperiments;
    }

    public boolean isPublishedWorkflowExists(String workflowName) throws RegistryException {
        return this.jpa.getGateway().isPublishedWorkflowExists(workflowName);
    }

    public void publishWorkflow(String workflowName, String publishWorkflowName) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        String workflowGraphXML = this.getWorkflowGraphXML(workflowName);
        if (gateway.isPublishedWorkflowExists(publishWorkflowName)) {
            throw new PublishedWorkflowAlreadyExistsException(publishWorkflowName);
        }
        PublishWorkflowResource publishedWorkflow = gateway.createPublishedWorkflow(publishWorkflowName);
        publishedWorkflow.setCreatedUser(this.getUser().getUserName());
        publishedWorkflow.setContent(workflowGraphXML);
        publishedWorkflow.setPublishedDate(new Timestamp(Calendar.getInstance().getTime().getTime()));
        publishedWorkflow.save();
    }

    public void publishWorkflow(String workflowName) throws RegistryException {
        this.publishWorkflow(workflowName, workflowName);
    }

    public String getPublishedWorkflowGraphXML(String workflowName) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isPublishedWorkflowExists(workflowName)) {
            throw new PublishedWorkflowDoesNotExistsException(workflowName);
        }
        return gateway.getPublishedWorkflow(workflowName).getContent();
    }

    public List<String> getPublishedWorkflowNames() throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        ArrayList<String> result = new ArrayList<String>();
        List<PublishWorkflowResource> publishedWorkflows = gateway.getPublishedWorkflows();
        for (PublishWorkflowResource resource : publishedWorkflows) {
            result.add(resource.getName());
        }
        return result;
    }

    public Map<String, String> getPublishedWorkflows() throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        HashMap<String, String> result = new HashMap<String, String>();
        List<PublishWorkflowResource> publishedWorkflows = gateway.getPublishedWorkflows();
        for (PublishWorkflowResource resource : publishedWorkflows) {
            result.put(resource.getName(), resource.getContent());
        }
        return result;
    }

    public void removePublishedWorkflow(String workflowName) throws RegistryException {
        GatewayResource gateway = this.jpa.getGateway();
        if (!this.isPublishedWorkflowExists(workflowName)) {
            throw new PublishedWorkflowDoesNotExistsException(workflowName);
        }
        gateway.removePublishedWorkflow(workflowName);
    }

    public ResourceMetadata getPublishedWorkflowMetadata(String workflowName) throws RegistryException {
        throw new UnimplementedRegistryOperationException();
    }

    public boolean isWorkflowExists(String workflowName) throws RegistryException {
        return this.jpa.getWorker().isWorkflowTemplateExists(workflowName);
    }

    public void addWorkflow(String workflowName, String workflowGraphXml) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (this.isWorkflowExists(workflowName)) {
            throw new UserWorkflowAlreadyExistsException(workflowName);
        }
        UserWorkflowResource workflowResource = worker.createWorkflowTemplate(workflowName);
        workflowResource.setContent(workflowGraphXml);
        workflowResource.save();
    }

    public void updateWorkflow(String workflowName, String workflowGraphXml) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkflowExists(workflowName)) {
            throw new UserWorkflowDoesNotExistsException(workflowName);
        }
        UserWorkflowResource workflowResource = worker.getWorkflowTemplate(workflowName);
        workflowResource.setContent(workflowGraphXml);
        workflowResource.save();
    }

    public String getWorkflowGraphXML(String workflowName) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkflowExists(workflowName)) {
            throw new UserWorkflowDoesNotExistsException(workflowName);
        }
        return worker.getWorkflowTemplate(workflowName).getContent();
    }

    public Map<String, String> getWorkflows() throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        HashMap<String, String> workflows = new HashMap<String, String>();
        List<UserWorkflowResource> workflowTemplates = worker.getWorkflowTemplates();
        for (UserWorkflowResource resource : workflowTemplates) {
            workflows.put(resource.getName(), resource.getContent());
        }
        return workflows;
    }

    public void removeWorkflow(String workflowName) throws RegistryException {
        WorkerResource worker = this.jpa.getWorker();
        if (!this.isWorkflowExists(workflowName)) {
            throw new UserWorkflowDoesNotExistsException(workflowName);
        }
        worker.removeWorkflowTemplate(workflowName);
    }

    public ResourceMetadata getWorkflowMetadata(String workflowName) throws UnimplementedRegistryOperationException {
        throw new UnimplementedRegistryOperationException();
    }

    public void setAiravataRegistry(AiravataRegistry2 registry) {
    }

    public void setAiravataUser(AiravataUser user) {
        this.setUser(user);
    }

    public boolean isExperimentExists(String experimentId, boolean createIfNotPresent) throws RegistryException {
        if (this.jpa.getWorker().isExperimentExists(experimentId)) {
            return true;
        }
        if (createIfNotPresent) {
            if (!this.isWorkspaceProjectExists(DEFAULT_PROJECT_NAME, true)) {
                throw new WorkspaceProjectDoesNotExistsException(this.createProjName(DEFAULT_PROJECT_NAME));
            }
            AiravataExperiment experiment = new AiravataExperiment();
            experiment.setExperimentId(experimentId);
            experiment.setSubmittedDate(Calendar.getInstance().getTime());
            experiment.setGateway(this.getGateway());
            experiment.setUser(this.getUser());
            this.addExperiment(DEFAULT_PROJECT_NAME, experiment);
            return this.jpa.getWorker().isExperimentExists(experimentId);
        }
        return false;
    }

    public boolean isExperimentExists(String experimentId) throws RegistryException {
        return this.isExperimentExists(experimentId, false);
    }

    public boolean updateExperimentExecutionUser(String experimentId, String user) throws RegistryException {
        if (!this.isExperimentExists(experimentId, true)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        data.setUserName(user);
        data.save();
        return true;
    }

    public String getExperimentExecutionUser(String experimentId) throws RegistryException {
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        return experiment.getData().getUserName();
    }

    public boolean isExperimentNameExist(String experimentName) throws RegistryException {
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.isExperimentNameExist(experimentName);
    }

    public String getExperimentName(String experimentId) throws RegistryException {
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getExperimentName(experimentId);
    }

    public void updateExperimentName(String experimentId, String experimentName) throws RegistryException {
        if (!this.isExperimentExists(experimentId, true)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        data.setExpName(experimentName);
        data.save();
    }

    public String getExperimentMetadata(String experimentId) throws RegistryException {
        if (!this.isExperimentExists(experimentId, true)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        if (data.isExperimentMetadataPresent()) {
            return data.getExperimentMetadata().getMetadata();
        }
        return null;
    }

    public boolean updateExperimentMetadata(String experimentId, String metadata) throws RegistryException {
        ExperimentMetadataResource experimentMetadata;
        if (!this.isExperimentExists(experimentId, true)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        if (data.isExperimentMetadataPresent()) {
            experimentMetadata = data.getExperimentMetadata();
            experimentMetadata.setMetadata(metadata);
        } else {
            experimentMetadata = data.createExperimentMetadata();
            experimentMetadata.setMetadata(metadata);
        }
        experimentMetadata.save();
        return true;
    }

    public String getWorkflowExecutionTemplateName(String workflowInstanceId) throws RegistryException {
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId);
        return wi.getTemplateName();
    }

    public void setWorkflowInstanceTemplateName(String workflowInstanceId, String templateName) throws RegistryException {
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId);
        wi.setTemplateName(templateName);
        wi.save();
    }

    public List<WorkflowInstance> getExperimentWorkflowInstances(String experimentId) throws RegistryException {
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        ArrayList<WorkflowInstance> result = new ArrayList<WorkflowInstance>();
        List<WorkflowDataResource> workflowInstances = data.getWorkflowInstances();
        for (WorkflowDataResource resource : workflowInstances) {
            WorkflowInstance workflowInstance = new WorkflowInstance(resource.getExperimentID(), resource.getWorkflowInstanceID());
            workflowInstance.setTemplateName(resource.getTemplateName());
            result.add(workflowInstance);
        }
        return result;
    }

    public boolean isWorkflowInstanceExists(String instanceId, boolean createIfNotPresent) throws RegistryException {
        if (this.jpa.getWorker().isWorkflowInstancePresent(instanceId)) {
            return true;
        }
        if (createIfNotPresent) {
            if (!this.isExperimentExists(instanceId, true)) {
                throw new ExperimentDoesNotExistsException(instanceId);
            }
            this.addWorkflowInstance(instanceId, instanceId, null);
            return this.isWorkflowInstanceExists(instanceId);
        }
        return false;
    }

    public boolean isWorkflowInstanceExists(String instanceId) throws RegistryException {
        return this.isWorkflowInstanceExists(instanceId, false);
    }

    public void updateWorkflowInstanceStatus(String instanceId, WorkflowInstanceStatus.ExecutionStatus status) throws RegistryException {
        if (!this.isWorkflowInstanceExists(instanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(instanceId);
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(instanceId);
        Timestamp currentTime = new Timestamp(Calendar.getInstance().getTime().getTime());
        wi.setStatus(status.toString());
        if (status == WorkflowInstanceStatus.ExecutionStatus.STARTED) {
            wi.setStartTime(currentTime);
        }
        wi.setLastUpdatedTime(currentTime);
        wi.save();
    }

    public void updateWorkflowInstanceStatus(WorkflowInstanceStatus status) throws RegistryException {
        if (!this.isWorkflowInstanceExists(status.getWorkflowInstance().getWorkflowInstanceId(), true)) {
            throw new WorkflowInstanceDoesNotExistsException(status.getWorkflowInstance().getWorkflowInstanceId());
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(status.getWorkflowInstance().getWorkflowInstanceId());
        Timestamp currentTime = new Timestamp(status.getStatusUpdateTime().getTime());
        wi.setStatus(status.getExecutionStatus().toString());
        if (status.getExecutionStatus() == WorkflowInstanceStatus.ExecutionStatus.STARTED) {
            wi.setStartTime(currentTime);
        }
        wi.setLastUpdatedTime(currentTime);
        wi.save();
    }

    public WorkflowInstanceStatus getWorkflowInstanceStatus(String instanceId) throws RegistryException {
        if (!this.isWorkflowInstanceExists(instanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(instanceId);
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(instanceId);
        return new WorkflowInstanceStatus(new WorkflowInstance(wi.getExperimentID(), wi.getWorkflowInstanceID()), wi.getStatus() == null ? null : WorkflowInstanceStatus.ExecutionStatus.valueOf((String)wi.getStatus()), (Date)wi.getLastUpdatedTime());
    }

    public void updateWorkflowNodeInput(WorkflowInstanceNode node, String data) throws RegistryException {
        if (!this.isWorkflowInstanceNodePresent(node.getWorkflowInstance().getWorkflowInstanceId(), node.getNodeId(), true)) {
            throw new WorkflowInstanceNodeDoesNotExistsException(node.getWorkflowInstance().getWorkflowInstanceId(), node.getNodeId());
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(node.getWorkflowInstance().getWorkflowInstanceId());
        NodeDataResource nodeData = wi.getNodeData(node.getNodeId());
        nodeData.setInputs(data);
        nodeData.save();
    }

    public void updateWorkflowNodeOutput(WorkflowInstanceNode node, String data) throws RegistryException {
        try {
            if (!this.isWorkflowInstanceNodePresent(node.getWorkflowInstance().getWorkflowInstanceId(), node.getNodeId(), true)) {
                throw new WorkflowInstanceNodeDoesNotExistsException(node.getWorkflowInstance().getWorkflowInstanceId(), node.getNodeId());
            }
            WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(node.getWorkflowInstance().getWorkflowInstanceId());
            NodeDataResource nodeData = wi.getNodeData(node.getNodeId());
            nodeData.setOutputs(data);
            nodeData.save();
        }
        catch (RegistryException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<WorkflowNodeIOData> searchWorkflowInstanceNodeInput(String experimentIdRegEx, String workflowNameRegEx, String nodeNameRegEx) throws RegistryException {
        return null;
    }

    public List<WorkflowNodeIOData> searchWorkflowInstanceNodeOutput(String experimentIdRegEx, String workflowNameRegEx, String nodeNameRegEx) throws RegistryException {
        return null;
    }

    public List<WorkflowNodeIOData> getWorkflowInstanceNodeInput(String workflowInstanceId, String nodeType) throws RegistryException {
        return null;
    }

    public List<WorkflowNodeIOData> getWorkflowInstanceNodeOutput(String workflowInstanceId, String nodeType) throws RegistryException {
        return null;
    }

    @Deprecated
    public void saveWorkflowExecutionOutput(String experimentId, String outputNodeName, String output) throws RegistryException {
    }

    @Deprecated
    public void saveWorkflowExecutionOutput(String experimentId, WorkflowIOData data) throws RegistryException {
    }

    @Deprecated
    public WorkflowIOData getWorkflowExecutionOutput(String experimentId, String outputNodeName) throws RegistryException {
        return null;
    }

    @Deprecated
    public List<WorkflowIOData> getWorkflowExecutionOutput(String experimentId) throws RegistryException {
        return null;
    }

    @Deprecated
    public String[] getWorkflowExecutionOutputNames(String exeperimentId) throws RegistryException {
        return null;
    }

    public ExperimentData getExperiment(String experimentId) throws RegistryException {
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        ExperimentData experimentData = experimentDataRetriever.getExperiment(experimentId);
        return experimentDataRetriever.getExperiment(experimentId);
    }

    public List<String> getExperimentIdByUser(String user) throws RegistryException {
        if (user == null) {
            user = this.jpa.getWorker().getUser();
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getExperimentIdByUser(user);
    }

    public List<ExperimentData> getExperimentByUser(String user) throws RegistryException {
        if (user == null) {
            user = this.jpa.getWorker().getUser();
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getExperiments(user);
    }

    public List<ExperimentData> getExperimentByUser(String user, int pageSize, int pageNo) throws RegistryException {
        return null;
    }

    public void updateWorkflowNodeStatus(WorkflowInstanceNodeStatus workflowStatusNode) throws RegistryException {
        WorkflowInstance workflowInstance = workflowStatusNode.getWorkflowInstanceNode().getWorkflowInstance();
        String nodeId = workflowStatusNode.getWorkflowInstanceNode().getNodeId();
        if (!this.isWorkflowInstanceNodePresent(workflowInstance.getWorkflowInstanceId(), nodeId, true)) {
            throw new WorkflowInstanceNodeDoesNotExistsException(workflowInstance.getWorkflowInstanceId(), nodeId);
        }
        NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(workflowInstance.getWorkflowInstanceId()).getNodeData(nodeId);
        nodeData.setStatus(workflowStatusNode.getExecutionStatus().toString());
        Timestamp t = new Timestamp(workflowStatusNode.getStatusUpdateTime().getTime());
        if (workflowStatusNode.getExecutionStatus() == WorkflowInstanceStatus.ExecutionStatus.STARTED) {
            nodeData.setStartTime(t);
        }
        nodeData.setLastUpdateTime(t);
        nodeData.save();
        WorkflowInstanceStatus currentWorkflowInstanceStatus = this.getWorkflowInstanceStatus(workflowInstance.getWorkflowInstanceId());
        this.updateWorkflowInstanceStatus(new WorkflowInstanceStatus(workflowInstance, currentWorkflowInstanceStatus.getExecutionStatus(), (Date)t));
    }

    public void updateWorkflowNodeStatus(String workflowInstanceId, String nodeId, WorkflowInstanceStatus.ExecutionStatus status) throws RegistryException {
        this.updateWorkflowNodeStatus(new WorkflowInstanceNode(new WorkflowInstance(workflowInstanceId, workflowInstanceId), nodeId), status);
    }

    public void updateWorkflowNodeStatus(WorkflowInstanceNode workflowNode, WorkflowInstanceStatus.ExecutionStatus status) throws RegistryException {
        this.updateWorkflowNodeStatus(new WorkflowInstanceNodeStatus(workflowNode, status, Calendar.getInstance().getTime()));
    }

    public WorkflowInstanceNodeStatus getWorkflowNodeStatus(WorkflowInstanceNode workflowNode) throws RegistryException {
        String nodeId;
        String id = workflowNode.getWorkflowInstance().getWorkflowInstanceId();
        if (!this.isWorkflowInstanceNodePresent(id, nodeId = workflowNode.getNodeId())) {
            throw new WorkflowInstanceNodeDoesNotExistsException(id, nodeId);
        }
        WorkflowDataResource workflowInstance = this.jpa.getWorker().getWorkflowInstance(id);
        NodeDataResource nodeData = workflowInstance.getNodeData(nodeId);
        return new WorkflowInstanceNodeStatus(new WorkflowInstanceNode(new WorkflowInstance(workflowInstance.getExperimentID(), workflowInstance.getWorkflowInstanceID()), nodeData.getNodeID()), nodeData.getStatus() == null ? null : WorkflowInstanceStatus.ExecutionStatus.valueOf((String)nodeData.getStatus()), (Date)nodeData.getLastUpdateTime());
    }

    public Date getWorkflowNodeStartTime(WorkflowInstanceNode workflowNode) throws RegistryException {
        String nodeId;
        String id = workflowNode.getWorkflowInstance().getWorkflowInstanceId();
        if (!this.isWorkflowInstanceNodePresent(id, nodeId = workflowNode.getNodeId())) {
            throw new WorkflowInstanceNodeDoesNotExistsException(id, nodeId);
        }
        WorkflowDataResource workflowInstance = this.jpa.getWorker().getWorkflowInstance(id);
        NodeDataResource nodeData = workflowInstance.getNodeData(nodeId);
        return nodeData.getStartTime();
    }

    public Date getWorkflowStartTime(WorkflowInstance workflowInstance) throws RegistryException {
        if (!this.isWorkflowInstanceExists(workflowInstance.getWorkflowInstanceId(), true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstance.getWorkflowInstanceId());
        }
        WorkflowDataResource wi = this.jpa.getWorker().getWorkflowInstance(workflowInstance.getWorkflowInstanceId());
        return wi.getStartTime();
    }

    public void updateWorkflowNodeGramData(WorkflowNodeGramData workflowNodeGramData) throws RegistryException {
        if (!this.isWorkflowInstanceNodePresent(workflowNodeGramData.getWorkflowInstanceId(), workflowNodeGramData.getNodeID(), true)) {
            throw new WorkflowInstanceNodeDoesNotExistsException(workflowNodeGramData.getWorkflowInstanceId(), workflowNodeGramData.getNodeID());
        }
        WorkflowDataResource workflowInstance = this.jpa.getWorker().getWorkflowInstance(workflowNodeGramData.getWorkflowInstanceId());
        GramDataResource gramData = workflowInstance.isGramDataExists(workflowNodeGramData.getNodeID()) ? workflowInstance.getGramData(workflowNodeGramData.getNodeID()) : workflowInstance.createGramData(workflowNodeGramData.getNodeID());
        gramData.setInvokedHost(workflowNodeGramData.getInvokedHost());
        gramData.setLocalJobID(workflowNodeGramData.getGramJobID());
        gramData.setRsl(workflowNodeGramData.getRsl());
        gramData.save();
    }

    public WorkflowInstanceData getWorkflowInstanceData(String workflowInstanceId) throws RegistryException {
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        WorkflowDataResource resource = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId);
        WorkflowInstance workflowInstance = new WorkflowInstance(resource.getExperimentID(), resource.getWorkflowInstanceID());
        workflowInstance.setTemplateName(resource.getTemplateName());
        WorkflowInstanceData workflowInstanceData = new WorkflowInstanceData(null, workflowInstance, new WorkflowInstanceStatus(workflowInstance, resource.getStatus() == null ? null : WorkflowInstanceStatus.ExecutionStatus.valueOf((String)resource.getStatus()), (Date)resource.getLastUpdatedTime()), null);
        List<NodeDataResource> nodeData = resource.getNodeData();
        for (NodeDataResource nodeDataResource : nodeData) {
            workflowInstanceData.getNodeDataList().add(this.getWorkflowInstanceNodeData(workflowInstanceId, nodeDataResource.getNodeID()));
        }
        return workflowInstanceData;
    }

    public WorkflowInstanceNodeData getWorkflowInstanceNodeData(String workflowInstanceId, String nodeId) throws RegistryException {
        if (!this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId)) {
            throw new WorkflowInstanceNodeDoesNotExistsException(workflowInstanceId, nodeId);
        }
        NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId).getNodeData(nodeId);
        WorkflowInstanceNodeData data = new WorkflowInstanceNodeData(new WorkflowInstanceNode(new WorkflowInstance(nodeData.getWorkflowDataResource().getExperimentID(), nodeData.getWorkflowDataResource().getWorkflowInstanceID()), nodeData.getNodeID()));
        data.setInput(nodeData.getInputs());
        data.setOutput(nodeData.getOutputs());
        return data;
    }

    public boolean isWorkflowInstanceNodePresent(String workflowInstanceId, String nodeId) throws RegistryException {
        return this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId, false);
    }

    public boolean isWorkflowInstanceNodePresent(String workflowInstanceId, String nodeId, boolean createIfNotPresent) throws RegistryException {
        if (!this.isWorkflowInstanceExists(workflowInstanceId, true)) {
            throw new WorkflowInstanceDoesNotExistsException(workflowInstanceId);
        }
        if (this.jpa.getWorker().getWorkflowInstance(workflowInstanceId).isNodeExists(nodeId)) {
            return true;
        }
        if (createIfNotPresent) {
            this.addWorkflowInstanceNode(workflowInstanceId, nodeId);
            return this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId);
        }
        return false;
    }

    public void addWorkflowInstance(String experimentId, String workflowInstanceId, String templateName) throws RegistryException {
        if (!this.isExperimentExists(experimentId, true)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        if (this.isWorkflowInstanceExists(workflowInstanceId)) {
            throw new WorkflowInstanceAlreadyExistsException(workflowInstanceId);
        }
        ExperimentResource experiment = this.jpa.getWorker().getExperiment(experimentId);
        ExperimentDataResource data = experiment.getData();
        WorkflowDataResource workflowInstanceResource = data.createWorkflowInstanceResource(workflowInstanceId);
        workflowInstanceResource.setTemplateName(templateName);
        workflowInstanceResource.save();
    }

    public void updateWorkflowNodeType(WorkflowInstanceNode node, WorkflowNodeType type) throws RegistryException {
        try {
            if (!this.isWorkflowInstanceNodePresent(node.getWorkflowInstance().getWorkflowInstanceId(), node.getNodeId(), true)) {
                throw new WorkflowInstanceNodeDoesNotExistsException(node.getWorkflowInstance().getWorkflowInstanceId(), node.getNodeId());
            }
            NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(node.getWorkflowInstance().getWorkflowInstanceId()).getNodeData(node.getNodeId());
            nodeData.setNodeType(type.getNodeType().toString());
            nodeData.save();
        }
        catch (RegistryException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void addWorkflowInstanceNode(String workflowInstanceId, String nodeId) throws RegistryException {
        if (this.isWorkflowInstanceNodePresent(workflowInstanceId, nodeId)) {
            throw new WorkflowInstanceNodeAlreadyExistsException(workflowInstanceId, nodeId);
        }
        NodeDataResource nodeData = this.jpa.getWorker().getWorkflowInstance(workflowInstanceId).createNodeData(nodeId);
        nodeData.save();
    }

    public ExperimentData getExperimentMetaInformation(String experimentId) throws RegistryException {
        if (!this.isExperimentExists(experimentId)) {
            throw new ExperimentDoesNotExistsException(experimentId);
        }
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getExperimentMetaInformation(experimentId);
    }

    public List<ExperimentData> getAllExperimentMetaInformation(String user) throws RegistryException {
        ExperimentDataRetriever experimentDataRetriever = new ExperimentDataRetriever();
        return experimentDataRetriever.getAllExperimentMetaInformation(user);
    }
}

