/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.common.utils.SecurityUtil;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.utils.RegistrySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UserResource.class);
    private String userName;
    private String password;

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Users existingUser = (Users)em.find(Users.class, (Object)this.userName);
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Users user = new Users();
            user.setUser_name(this.userName);
            if (this.password != null && !this.password.equals("")) {
                try {
                    user.setPassword(SecurityUtil.digestString((String)this.password, (String)RegistrySettings.getSetting((String)"default.registry.password.hash.method")));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Error hashing default admin password. Invalid hash algorithm.", e);
                }
                catch (RegistryException e) {
                    throw new RuntimeException("Error reading hash algorithm from configurations", e);
                }
            }
            if (existingUser != null) {
                if (this.password != null && !this.password.equals("")) {
                    try {
                        existingUser.setPassword(SecurityUtil.digestString((String)this.password, (String)RegistrySettings.getSetting((String)"default.registry.password.hash.method")));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new RuntimeException("Error hashing default admin password. Invalid hash algorithm.", e);
                    }
                    catch (RegistryException e) {
                        throw new RuntimeException("Error reading hash algorithm from configurations", e);
                    }
                }
                user = (Users)em.merge((Object)existingUser);
            } else {
                em.persist((Object)user);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

