/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.ErrorDetail;
import org.apache.airavata.persistance.registry.jpa.model.JobDetail;
import org.apache.airavata.persistance.registry.jpa.model.JobDetails_PK;
import org.apache.airavata.persistance.registry.jpa.model.Status;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ErrorDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.StatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.utils.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDetailResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(JobDetailResource.class);
    private String jobId;
    private TaskDetailResource taskDetailResource;
    private String jobDescription;
    private Timestamp creationTime;
    private String computeResourceConsumed;

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getComputeResourceConsumed() {
        return this.computeResourceConsumed;
    }

    public void setComputeResourceConsumed(String computeResourceConsumed) {
        this.computeResourceConsumed = computeResourceConsumed;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        switch (type) {
            case STATUS: {
                StatusResource statusResource = new StatusResource();
                statusResource.setJobId(this.jobId);
                return statusResource;
            }
            case ERROR_DETAIL: {
                ErrorDetailResource errorDetailResource = new ErrorDetailResource();
                errorDetailResource.setJobId(this.jobId);
                return errorDetailResource;
            }
        }
        logger.error("Unsupported resource type for job details data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("jobId", name);
                    generator.setParameter("statusType", StatusType.JOB.toString());
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("jobId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for job details resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("jobId", name);
                    generator.setParameter("statusType", StatusType.JOB.toString());
                    Query q = generator.selectQuery(em);
                    Status status = (Status)q.getSingleResult();
                    StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                    em.getTransaction().commit();
                    em.close();
                    StatusResource statusResource2 = statusResource;
                    return statusResource2;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("jobId", name);
                    Query q = generator.selectQuery(em);
                    ErrorDetail errorDetail = (ErrorDetail)q.getSingleResult();
                    ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                    em.getTransaction().commit();
                    em.close();
                    ErrorDetailResource errorDetailResource2 = errorDetailResource;
                    return errorDetailResource2;
                }
            }
            try {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for job details resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for job details resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("jobId", this.jobId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Status status = (Status)result;
                        StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                        resourceList.add(statusResource);
                    }
                    break;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("jobId", this.jobId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ErrorDetail errorDetail = (ErrorDetail)result;
                        ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                        resourceList.add(errorDetailResource);
                    }
                    break;
                }
                default: {
                    em.getTransaction().commit();
                    em.close();
                    logger.error("Unsupported resource type for workflow node details resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            JobDetail existingJobDetail = (JobDetail)em.find(JobDetail.class, (Object)new JobDetails_PK(this.jobId, this.taskDetailResource.getTaskId()));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            JobDetail jobDetail = new JobDetail();
            TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
            jobDetail.setJobId(this.jobId);
            jobDetail.setTask(taskDetail);
            jobDetail.setTaskId(this.taskDetailResource.getTaskId());
            jobDetail.setCreationTime(this.creationTime);
            if (this.jobDescription != null) {
                jobDetail.setJobDescription(this.jobDescription.toCharArray());
            }
            jobDetail.setComputeResourceConsumed(this.computeResourceConsumed);
            if (existingJobDetail != null) {
                existingJobDetail.setJobId(this.jobId);
                existingJobDetail.setTask(taskDetail);
                existingJobDetail.setTaskId(this.taskDetailResource.getTaskId());
                existingJobDetail.setCreationTime(this.creationTime);
                if (this.jobDescription != null) {
                    existingJobDetail.setJobDescription(this.jobDescription.toCharArray());
                }
                existingJobDetail.setComputeResourceConsumed(this.computeResourceConsumed);
                jobDetail = (JobDetail)em.merge((Object)existingJobDetail);
            } else {
                em.persist((Object)jobDetail);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public StatusResource getJobStatus() throws RegistryException {
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource jobStatus = (StatusResource)resource;
            if (!jobStatus.getStatusType().equals(StatusType.JOB.toString())) continue;
            if (jobStatus.getState() == null || jobStatus.getState().equals("")) {
                jobStatus.setState("UNKNOWN");
            }
            return jobStatus;
        }
        return null;
    }

    public StatusResource getApplicationStatus() throws RegistryException {
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource appStatus = (StatusResource)resource;
            if (!appStatus.getStatusType().equals(StatusType.APPLICATION.toString())) continue;
            if (appStatus.getState() == null || appStatus.getState().equals("")) {
                appStatus.setState("UNKNOWN");
            }
            return appStatus;
        }
        return null;
    }

    public List<ErrorDetailResource> getErrorDetails() throws RegistryException {
        ArrayList<ErrorDetailResource> errorDetailResources = new ArrayList<ErrorDetailResource>();
        List<Resource> resources = this.get(ResourceType.ERROR_DETAIL);
        for (Resource resource : resources) {
            errorDetailResources.add((ErrorDetailResource)resource);
        }
        return errorDetailResources;
    }
}

