/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Input;
import org.apache.airavata.persistance.registry.jpa.model.Experiment_Input_PK;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentInputResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ExperimentInputResource.class);
    private ExperimentResource experimentResource;
    private String experimentKey;
    private String value;
    private String inputType;
    private String metadata;

    public String getExperimentKey() {
        return this.experimentKey;
    }

    public void setExperimentKey(String experimentKey) {
        this.experimentKey = experimentKey;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for experiment input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for experiment input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for experiment input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for experiment input data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Experiment_Input existingInput = (Experiment_Input)em.find(Experiment_Input.class, (Object)new Experiment_Input_PK(this.experimentResource.getExpID(), this.experimentKey));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Experiment_Input exInput = new Experiment_Input();
            exInput.setEx_key(this.experimentKey);
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            exInput.setExperiment(experiment);
            exInput.setExperiment_id(experiment.getExpId());
            if (this.value != null) {
                exInput.setValue(this.value.toCharArray());
            }
            exInput.setInputType(this.inputType);
            exInput.setMetadata(this.metadata);
            if (existingInput != null) {
                existingInput.setEx_key(this.experimentKey);
                existingInput.setExperiment(experiment);
                existingInput.setExperiment_id(experiment.getExpId());
                if (this.value != null) {
                    existingInput.setValue(this.value.toCharArray());
                }
                existingInput.setInputType(this.inputType);
                existingInput.setMetadata(this.metadata);
                exInput = (Experiment_Input)em.merge((Object)existingInput);
            } else {
                em.persist((Object)exInput);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

