/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.DataTransferDetail;
import org.apache.airavata.persistance.registry.jpa.model.Status;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.StatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.utils.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransferDetailResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(DataTransferDetailResource.class);
    private String transferId;
    private TaskDetailResource taskDetailResource;
    private Timestamp creationTime;
    private String transferDescription;

    public String getTransferId() {
        return this.transferId;
    }

    public void setTransferId(String transferId) {
        this.transferId = transferId;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getTransferDescription() {
        return this.transferDescription;
    }

    public void setTransferDescription(String transferDescription) {
        this.transferDescription = transferDescription;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        switch (type) {
            case STATUS: {
                StatusResource statusResource = new StatusResource();
                statusResource.setDataTransferDetail(this);
                return statusResource;
            }
        }
        logger.error("Unsupported resource type for data transfer details data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("transferId", name);
                    generator.setParameter("statusType", StatusType.DATA_TRANSFER);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for data transfer details resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("transferId", name);
                    generator.setParameter("statusType", StatusType.DATA_TRANSFER);
                    Query q = generator.selectQuery(em);
                    Status status = (Status)q.getSingleResult();
                    StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                    em.getTransaction().commit();
                    em.close();
                    StatusResource statusResource2 = statusResource;
                    return statusResource2;
                }
            }
            try {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for data transfer details resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for data transfer details resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("transferId", this.transferId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Status status = (Status)result;
                        StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                        resourceList.add(statusResource);
                    }
                    break;
                }
                default: {
                    em.getTransaction().commit();
                    em.close();
                    logger.error("Unsupported resource type for workflow node details resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            DataTransferDetail existingDF = (DataTransferDetail)em.find(DataTransferDetail.class, (Object)this.transferId);
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            DataTransferDetail dataTransferDetail = new DataTransferDetail();
            TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
            dataTransferDetail.setTransferId(this.transferId);
            dataTransferDetail.setTask(taskDetail);
            dataTransferDetail.setTaskId(this.taskDetailResource.getTaskId());
            dataTransferDetail.setCreationTime(this.creationTime);
            if (this.transferDescription != null) {
                dataTransferDetail.setTransferDesc(this.transferDescription.toCharArray());
            }
            if (existingDF != null) {
                existingDF.setTransferId(this.transferId);
                existingDF.setTask(taskDetail);
                existingDF.setTaskId(this.taskDetailResource.getTaskId());
                existingDF.setCreationTime(this.creationTime);
                if (this.transferDescription != null) {
                    existingDF.setTransferDesc(this.transferDescription.toCharArray());
                }
                dataTransferDetail = (DataTransferDetail)em.merge((Object)existingDF);
            } else {
                em.persist((Object)dataTransferDetail);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public StatusResource getDataTransferStatus() throws RegistryException {
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource dataTransferStatus = (StatusResource)resource;
            if (!dataTransferStatus.getStatusType().equals(StatusType.DATA_TRANSFER.toString())) continue;
            if (dataTransferStatus.getState() == null || dataTransferStatus.getState().equals("")) {
                dataTransferStatus.setState("UNKNOWN");
            }
            return dataTransferStatus;
        }
        return null;
    }
}

