/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedOutputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedOutputDataHandlingResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(AdvancedOutputDataHandlingResource.class);
    private int outputDataHandlingId = 0;
    private ExperimentResource experimentResource;
    private TaskDetailResource taskDetailResource;
    private String outputDataDir;
    private String dataRegUrl;
    private boolean persistOutputData;

    public int getOutputDataHandlingId() {
        return this.outputDataHandlingId;
    }

    public void setOutputDataHandlingId(int outputDataHandlingId) {
        this.outputDataHandlingId = outputDataHandlingId;
    }

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    public String getOutputDataDir() {
        return this.outputDataDir;
    }

    public void setOutputDataDir(String outputDataDir) {
        this.outputDataDir = outputDataDir;
    }

    public String getDataRegUrl() {
        return this.dataRegUrl;
    }

    public void setDataRegUrl(String dataRegUrl) {
        this.dataRegUrl = dataRegUrl;
    }

    public boolean isPersistOutputData() {
        return this.persistOutputData;
    }

    public void setPersistOutputData(boolean persistOutputData) {
        this.persistOutputData = persistOutputData;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for output data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for output data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for output data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for output data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            AdvancedOutputDataHandling dataHandling;
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (this.outputDataHandlingId != 0) {
                dataHandling = (AdvancedOutputDataHandling)em.find(AdvancedOutputDataHandling.class, (Object)this.outputDataHandlingId);
                dataHandling.setOutputDataHandlingId(this.outputDataHandlingId);
            } else {
                dataHandling = new AdvancedOutputDataHandling();
            }
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            if (this.taskDetailResource != null) {
                TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
                dataHandling.setTaskId(this.taskDetailResource.getTaskId());
                dataHandling.setTask(taskDetail);
            }
            dataHandling.setExpId(this.experimentResource.getExpID());
            dataHandling.setExperiment(experiment);
            dataHandling.setDataRegUrl(this.dataRegUrl);
            dataHandling.setOutputDataDir(this.outputDataDir);
            dataHandling.setPersistOutputData(this.persistOutputData);
            em.persist((Object)dataHandling);
            this.outputDataHandlingId = dataHandling.getOutputDataHandlingId();
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

