/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedInputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvanceInputDataHandlingResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(AdvanceInputDataHandlingResource.class);
    private int dataHandlingId = 0;
    private ExperimentResource experimentResource;
    private TaskDetailResource taskDetailResource;
    private String workingDirParent;
    private String workingDir;
    private boolean stageInputFiles;
    private boolean cleanAfterJob;

    public int getDataHandlingId() {
        return this.dataHandlingId;
    }

    public void setDataHandlingId(int dataHandlingId) {
        this.dataHandlingId = dataHandlingId;
    }

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    public String getWorkingDirParent() {
        return this.workingDirParent;
    }

    public void setWorkingDirParent(String workingDirParent) {
        this.workingDirParent = workingDirParent;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean isStageInputFiles() {
        return this.stageInputFiles;
    }

    public void setStageInputFiles(boolean stageInputFiles) {
        this.stageInputFiles = stageInputFiles;
    }

    public boolean isCleanAfterJob() {
        return this.cleanAfterJob;
    }

    public void setCleanAfterJob(boolean cleanAfterJob) {
        this.cleanAfterJob = cleanAfterJob;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for input data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for input data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for input data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for input data handling resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            AdvancedInputDataHandling dataHandling;
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (this.dataHandlingId != 0) {
                dataHandling = (AdvancedInputDataHandling)em.find(AdvancedInputDataHandling.class, (Object)this.dataHandlingId);
                dataHandling.setDataHandlingId(this.dataHandlingId);
            } else {
                dataHandling = new AdvancedInputDataHandling();
            }
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            if (this.taskDetailResource != null) {
                TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
                dataHandling.setTaskId(this.taskDetailResource.getTaskId());
                dataHandling.setTask(taskDetail);
            }
            dataHandling.setExpId(this.experimentResource.getExpID());
            dataHandling.setExperiment(experiment);
            dataHandling.setWorkingDir(this.workingDir);
            dataHandling.setParentWorkingDir(this.workingDirParent);
            dataHandling.setStageInputsToWorkingDir(this.stageInputFiles);
            dataHandling.setCleanAfterJob(this.cleanAfterJob);
            em.persist((Object)dataHandling);
            this.dataHandlingId = dataHandling.getDataHandlingId();
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

