/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.workspace.Project;
import org.apache.airavata.model.workspace.experiment.AdvancedInputDataHandling;
import org.apache.airavata.model.workspace.experiment.AdvancedOutputDataHandling;
import org.apache.airavata.model.workspace.experiment.ApplicationStatus;
import org.apache.airavata.model.workspace.experiment.ComputationalResourceScheduling;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorDetails;
import org.apache.airavata.model.workspace.experiment.Experiment;
import org.apache.airavata.model.workspace.experiment.ExperimentStatus;
import org.apache.airavata.model.workspace.experiment.ExperimentSummary;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobStatus;
import org.apache.airavata.model.workspace.experiment.QualityOfServiceParams;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.model.workspace.experiment.TaskStatus;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.model.workspace.experiment.UserConfigurationData;
import org.apache.airavata.model.workspace.experiment.WorkflowNodeDetails;
import org.apache.airavata.model.workspace.experiment.WorkflowNodeStatus;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.impl.ExperimentRegistry;
import org.apache.airavata.persistance.registry.jpa.impl.ProjectRegistry;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.apache.airavata.registry.cpi.ParentDataType;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.RegistryModelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryImpl
implements Registry {
    private GatewayResource gatewayResource;
    private UserResource user;
    private static final Logger logger = LoggerFactory.getLogger(RegistryImpl.class);
    private ExperimentRegistry experimentRegistry = null;
    private ProjectRegistry projectRegistry = null;

    public RegistryImpl() throws RegistryException {
        try {
            if (!ResourceUtils.isGatewayExist(ServerSettings.getDefaultUserGateway())) {
                this.gatewayResource = (GatewayResource)ResourceUtils.createGateway(ServerSettings.getDefaultUserGateway());
                this.gatewayResource.save();
            } else {
                this.gatewayResource = (GatewayResource)ResourceUtils.getGateway(ServerSettings.getDefaultUserGateway());
            }
            if (!ResourceUtils.isUserExist(ServerSettings.getDefaultUser())) {
                this.user = ResourceUtils.createUser(ServerSettings.getDefaultUser(), ServerSettings.getDefaultUserPassword());
                this.user.save();
            } else {
                this.user = (UserResource)ResourceUtils.getUser(ServerSettings.getDefaultUser());
            }
            this.experimentRegistry = new ExperimentRegistry(this.gatewayResource, this.user);
            this.projectRegistry = new ProjectRegistry(this.gatewayResource, this.user);
        }
        catch (ApplicationSettingsException e) {
            logger.error("Unable to read airavata server properties..", (Throwable)e);
        }
    }

    public RegistryImpl(String gateway, String username, String password) throws RegistryException {
        if (!ResourceUtils.isGatewayExist(gateway)) {
            this.gatewayResource = (GatewayResource)ResourceUtils.createGateway(gateway);
            this.gatewayResource.save();
        } else {
            this.gatewayResource = (GatewayResource)ResourceUtils.getGateway(gateway);
        }
        if (!ResourceUtils.isUserExist(username)) {
            this.user = ResourceUtils.createUser(username, password);
            this.user.save();
        } else {
            this.user = (UserResource)ResourceUtils.getUser(username);
        }
        this.experimentRegistry = new ExperimentRegistry(this.gatewayResource, this.user);
        this.projectRegistry = new ProjectRegistry(this.gatewayResource, this.user);
    }

    public Object add(ParentDataType dataType, Object newObjectToAdd) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.addProject((Project)newObjectToAdd);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.addExperiment((Experiment)newObjectToAdd);
                }
            }
            logger.error("Unsupported top level type..", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while adding the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while adding the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public Object add(ChildDataType dataType, Object newObjectToAdd, Object dependentIdentifier) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT_CONFIGURATION_DATA: {
                    return this.experimentRegistry.addUserConfigData((UserConfigurationData)newObjectToAdd, (String)dependentIdentifier);
                }
                case EXPERIMENT_OUTPUT: {
                    return this.experimentRegistry.addExpOutputs((List)newObjectToAdd, (String)dependentIdentifier);
                }
                case EXPERIMENT_STATUS: {
                    return this.experimentRegistry.updateExperimentStatus((ExperimentStatus)newObjectToAdd, (String)dependentIdentifier);
                }
                case WORKFLOW_NODE_DETAIL: {
                    return this.experimentRegistry.addWorkflowNodeDetails((WorkflowNodeDetails)newObjectToAdd, (String)dependentIdentifier);
                }
                case WORKFLOW_NODE_STATUS: {
                    return this.experimentRegistry.addWorkflowNodeStatus((WorkflowNodeStatus)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case NODE_OUTPUT: {
                    return this.experimentRegistry.addNodeOutputs((List)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case TASK_DETAIL: {
                    return this.experimentRegistry.addTaskDetails((TaskDetails)newObjectToAdd, (String)dependentIdentifier);
                }
                case APPLICATION_OUTPUT: {
                    return this.experimentRegistry.addApplicationOutputs((List)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case TASK_STATUS: {
                    return this.experimentRegistry.addTaskStatus((TaskStatus)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case JOB_DETAIL: {
                    return this.experimentRegistry.addJobDetails((JobDetails)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case JOB_STATUS: {
                    return this.experimentRegistry.addJobStatus((JobStatus)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case APPLICATION_STATUS: {
                    return this.experimentRegistry.addApplicationStatus((ApplicationStatus)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case DATA_TRANSFER_DETAIL: {
                    return this.experimentRegistry.addDataTransferDetails((DataTransferDetails)newObjectToAdd, (String)dependentIdentifier);
                }
                case TRANSFER_STATUS: {
                    return this.experimentRegistry.addTransferStatus((TransferStatus)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    return this.experimentRegistry.addComputationalResourceScheduling((ComputationalResourceScheduling)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    return this.experimentRegistry.addOutputDataHandling((AdvancedOutputDataHandling)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    return this.experimentRegistry.addInputDataHandling((AdvancedInputDataHandling)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case QOS_PARAM: {
                    return this.experimentRegistry.addQosParams((QualityOfServiceParams)newObjectToAdd, (CompositeIdentifier)dependentIdentifier);
                }
                case ERROR_DETAIL: {
                    return this.experimentRegistry.addErrorDetails((ErrorDetails)newObjectToAdd, dependentIdentifier);
                }
            }
            logger.error("Unsupported dependent data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while adding " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while adding " + dataType.toString(), (Throwable)e);
        }
    }

    public void update(RegistryModelType dataType, Object newObjectToUpdate, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    this.projectRegistry.updateProject((Project)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT: {
                    this.experimentRegistry.updateExperiment((Experiment)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT_CONFIGURATION_DATA: {
                    this.experimentRegistry.updateUserConfigData((UserConfigurationData)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT_OUTPUT: {
                    this.experimentRegistry.updateExpOutputs((List)newObjectToUpdate, (String)identifier);
                    break;
                }
                case EXPERIMENT_STATUS: {
                    this.experimentRegistry.updateExperimentStatus((ExperimentStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case WORKFLOW_NODE_DETAIL: {
                    this.experimentRegistry.updateWorkflowNodeDetails((WorkflowNodeDetails)newObjectToUpdate, (String)identifier);
                    break;
                }
                case WORKFLOW_NODE_STATUS: {
                    this.experimentRegistry.updateWorkflowNodeStatus((WorkflowNodeStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case NODE_OUTPUT: {
                    this.experimentRegistry.updateNodeOutputs((List)newObjectToUpdate, (String)identifier);
                    break;
                }
                case TASK_DETAIL: {
                    this.experimentRegistry.updateTaskDetails((TaskDetails)newObjectToUpdate, (String)identifier);
                    break;
                }
                case APPLICATION_OUTPUT: {
                    this.experimentRegistry.updateAppOutputs((List)newObjectToUpdate, (String)identifier);
                    break;
                }
                case TASK_STATUS: {
                    this.experimentRegistry.updateTaskStatus((TaskStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case JOB_DETAIL: {
                    this.experimentRegistry.updateJobDetails((JobDetails)newObjectToUpdate, (CompositeIdentifier)identifier);
                    break;
                }
                case JOB_STATUS: {
                    this.experimentRegistry.updateJobStatus((JobStatus)newObjectToUpdate, (CompositeIdentifier)identifier);
                    break;
                }
                case APPLICATION_STATUS: {
                    this.experimentRegistry.updateApplicationStatus((ApplicationStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case DATA_TRANSFER_DETAIL: {
                    this.experimentRegistry.updateDataTransferDetails((DataTransferDetails)newObjectToUpdate, (String)identifier);
                    break;
                }
                case TRANSFER_STATUS: {
                    this.experimentRegistry.updateTransferStatus((TransferStatus)newObjectToUpdate, (String)identifier);
                    break;
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    this.experimentRegistry.updateScheduling((ComputationalResourceScheduling)newObjectToUpdate, (String)identifier, dataType.toString());
                    break;
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    this.experimentRegistry.updateInputDataHandling((AdvancedInputDataHandling)newObjectToUpdate, (String)identifier, dataType.toString());
                    break;
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    this.experimentRegistry.updateOutputDataHandling((AdvancedOutputDataHandling)newObjectToUpdate, (String)identifier, dataType.toString());
                    break;
                }
                case QOS_PARAM: {
                    this.experimentRegistry.updateQOSParams((QualityOfServiceParams)newObjectToUpdate, (String)identifier, dataType.toString());
                    break;
                }
                default: {
                    logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while updating the resource.." + dataType.toString(), (Throwable)e);
        }
    }

    public void update(RegistryModelType dataType, Object identifier, String fieldName, Object value) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    this.experimentRegistry.updateExperimentField((String)identifier, fieldName, value);
                    break;
                }
                case EXPERIMENT_CONFIGURATION_DATA: {
                    this.experimentRegistry.updateExpConfigDataField((String)identifier, fieldName, value);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while updating the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while updating the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public Object get(RegistryModelType dataType, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.getProject((String)identifier);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.getExperiment((String)identifier, null);
                }
                case EXPERIMENT_CONFIGURATION_DATA: {
                    return this.experimentRegistry.getConfigData((String)identifier, null);
                }
                case EXPERIMENT_OUTPUT: {
                    return this.experimentRegistry.getExperimentOutputs((String)identifier);
                }
                case EXPERIMENT_STATUS: {
                    return this.experimentRegistry.getExperimentStatus((String)identifier);
                }
                case WORKFLOW_NODE_DETAIL: {
                    return this.experimentRegistry.getWorkflowNodeDetails((String)identifier);
                }
                case WORKFLOW_NODE_STATUS: {
                    return this.experimentRegistry.getWorkflowNodeStatus((String)identifier);
                }
                case NODE_OUTPUT: {
                    return this.experimentRegistry.getNodeOutputs((String)identifier);
                }
                case TASK_DETAIL: {
                    return this.experimentRegistry.getTaskDetails((String)identifier);
                }
                case APPLICATION_OUTPUT: {
                    return this.experimentRegistry.getApplicationOutputs((String)identifier);
                }
                case TASK_STATUS: {
                    return this.experimentRegistry.getTaskStatus((String)identifier);
                }
                case JOB_DETAIL: {
                    return this.experimentRegistry.getJobDetails((CompositeIdentifier)identifier);
                }
                case JOB_STATUS: {
                    return this.experimentRegistry.getJobStatus((CompositeIdentifier)identifier);
                }
                case APPLICATION_STATUS: {
                    return this.experimentRegistry.getApplicationStatus((CompositeIdentifier)identifier);
                }
                case DATA_TRANSFER_DETAIL: {
                    return this.experimentRegistry.getDataTransferDetails((String)identifier);
                }
                case TRANSFER_STATUS: {
                    return this.experimentRegistry.getDataTransferStatus((String)identifier);
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    return this.experimentRegistry.getComputationalScheduling(dataType, (String)identifier);
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    return this.experimentRegistry.getInputDataHandling(dataType, (String)identifier);
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    return this.experimentRegistry.getOutputDataHandling(dataType, (String)identifier);
                }
                case QOS_PARAM: {
                    return this.experimentRegistry.getQosParams(dataType, (String)identifier);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<Object> get(RegistryModelType dataType, String fieldName, Object value) throws RegistryException {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            switch (dataType) {
                case PROJECT: {
                    List<Project> projectList = this.projectRegistry.getProjectList(fieldName, value);
                    for (Project project : projectList) {
                        result.add(project);
                    }
                    return result;
                }
                case EXPERIMENT: {
                    List<Experiment> experimentList = this.experimentRegistry.getExperimentList(fieldName, value);
                    for (Experiment experiment : experimentList) {
                        result.add(experiment);
                    }
                    return result;
                }
                case WORKFLOW_NODE_DETAIL: {
                    List<WorkflowNodeDetails> wfNodeDetails = this.experimentRegistry.getWFNodeDetails(fieldName, value);
                    for (WorkflowNodeDetails wf : wfNodeDetails) {
                        result.add(wf);
                    }
                    return result;
                }
                case WORKFLOW_NODE_STATUS: {
                    List<WorkflowNodeStatus> wfNodeStatusList = this.experimentRegistry.getWFNodeStatusList(fieldName, value);
                    for (WorkflowNodeStatus wfs : wfNodeStatusList) {
                        result.add(wfs);
                    }
                    return result;
                }
                case TASK_DETAIL: {
                    List<TaskDetails> taskDetails = this.experimentRegistry.getTaskDetails(fieldName, value);
                    for (TaskDetails task : taskDetails) {
                        result.add(task);
                    }
                    return result;
                }
                case JOB_DETAIL: {
                    List<JobDetails> jobDetails = this.experimentRegistry.getJobDetails(fieldName, value);
                    for (JobDetails job : jobDetails) {
                        result.add(job);
                    }
                    return result;
                }
                case DATA_TRANSFER_DETAIL: {
                    List<DataTransferDetails> dataTransferDetails = this.experimentRegistry.getDataTransferDetails(fieldName, value);
                    for (DataTransferDetails transferDetails : dataTransferDetails) {
                        result.add(transferDetails);
                    }
                    return result;
                }
                case ERROR_DETAIL: {
                    List<ErrorDetails> errorDetails = this.experimentRegistry.getErrorDetails(fieldName, value);
                    for (ErrorDetails error : errorDetails) {
                        result.add(error);
                    }
                    return result;
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<Object> search(RegistryModelType dataType, Map<String, String> filters) throws RegistryException {
        try {
            ArrayList<Object> result = new ArrayList<Object>();
            switch (dataType) {
                case PROJECT: {
                    List<Project> projectList = this.projectRegistry.searchProjects(filters);
                    for (Project project : projectList) {
                        result.add(project);
                    }
                    return result;
                }
                case EXPERIMENT: {
                    List<ExperimentSummary> experimentSummaries = this.experimentRegistry.searchExperiments(filters);
                    for (ExperimentSummary ex : experimentSummaries) {
                        result.add(ex);
                    }
                    return result;
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public Object getValue(RegistryModelType dataType, Object identifier, String field) throws RegistryException {
        try {
            switch (dataType) {
                case EXPERIMENT: {
                    return this.experimentRegistry.getExperiment((String)identifier, field);
                }
                case EXPERIMENT_CONFIGURATION_DATA: {
                    return this.experimentRegistry.getConfigData((String)identifier, field);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public List<String> getIds(RegistryModelType dataType, String fieldName, Object value) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.getProjectIDs(fieldName, value);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.getExperimentIDs(fieldName, value);
                }
                case EXPERIMENT_CONFIGURATION_DATA: {
                    return this.experimentRegistry.getExperimentIDs(fieldName, value);
                }
                case WORKFLOW_NODE_DETAIL: {
                    return this.experimentRegistry.getWorkflowNodeIds(fieldName, value);
                }
                case TASK_DETAIL: {
                    return this.experimentRegistry.getTaskDetailIds(fieldName, value);
                }
                case JOB_DETAIL: {
                    return this.experimentRegistry.getJobDetailIds(fieldName, value);
                }
                case DATA_TRANSFER_DETAIL: {
                    return this.experimentRegistry.getTransferDetailIds(fieldName, value);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while retrieving the ids for" + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while retrieving the ids for " + dataType.toString(), (Throwable)e);
        }
    }

    public void remove(RegistryModelType dataType, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    this.projectRegistry.removeProject((String)identifier);
                    break;
                }
                case EXPERIMENT: {
                    this.experimentRegistry.removeExperiment((String)identifier);
                    break;
                }
                case EXPERIMENT_CONFIGURATION_DATA: {
                    this.experimentRegistry.removeExperimentConfigData((String)identifier);
                    break;
                }
                case WORKFLOW_NODE_DETAIL: {
                    this.experimentRegistry.removeWorkflowNode((String)identifier);
                    break;
                }
                case TASK_DETAIL: {
                    this.experimentRegistry.removeTaskDetails((String)identifier);
                    break;
                }
                case JOB_DETAIL: {
                    this.experimentRegistry.removeJobDetails((CompositeIdentifier)identifier);
                    break;
                }
                case DATA_TRANSFER_DETAIL: {
                    this.experimentRegistry.removeDataTransferDetails((String)identifier);
                    break;
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    this.experimentRegistry.removeComputationalScheduling(dataType, (String)identifier);
                    break;
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    this.experimentRegistry.removeOutputDataHandling(dataType, (String)identifier);
                    break;
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    this.experimentRegistry.removeInputDataHandling(dataType, (String)identifier);
                    break;
                }
                case QOS_PARAM: {
                    this.experimentRegistry.removeQOSParams(dataType, (String)identifier);
                    break;
                }
                default: {
                    logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while removing the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while removing the resource " + dataType.toString(), (Throwable)e);
        }
    }

    public boolean isExist(RegistryModelType dataType, Object identifier) throws RegistryException {
        try {
            switch (dataType) {
                case PROJECT: {
                    return this.projectRegistry.isProjectExist((String)identifier);
                }
                case EXPERIMENT: {
                    return this.experimentRegistry.isExperimentExist((String)identifier);
                }
                case EXPERIMENT_CONFIGURATION_DATA: {
                    return this.experimentRegistry.isExperimentConfigDataExist((String)identifier);
                }
                case WORKFLOW_NODE_DETAIL: {
                    return this.experimentRegistry.isWFNodeExist((String)identifier);
                }
                case TASK_DETAIL: {
                    return this.experimentRegistry.isTaskDetailExist((String)identifier);
                }
                case JOB_DETAIL: {
                    return this.experimentRegistry.isJobDetailExist((CompositeIdentifier)identifier);
                }
                case DATA_TRANSFER_DETAIL: {
                    return this.experimentRegistry.isTransferDetailExist((String)identifier);
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    return this.experimentRegistry.isComputationalSchedulingExist(dataType, (String)identifier);
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    return this.experimentRegistry.isInputDataHandlingExist(dataType, (String)identifier);
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    return this.experimentRegistry.isOutputDataHandlingExist(dataType, (String)identifier);
                }
                case QOS_PARAM: {
                    return this.experimentRegistry.isQOSParamsExist(dataType, (String)identifier);
                }
            }
            logger.error("Unsupported data type...", (Throwable)new UnsupportedOperationException());
            throw new UnsupportedOperationException();
        }
        catch (Exception e) {
            logger.error("Error while checking existence of the resource " + dataType.toString(), (Throwable)new RegistryException((Throwable)e));
            throw new RegistryException("Error while checking existence of the resource " + dataType.toString(), (Throwable)e);
        }
    }
}

