/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.ErrorDetail;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.NodeInput;
import org.apache.airavata.persistance.registry.jpa.model.NodeOutput;
import org.apache.airavata.persistance.registry.jpa.model.Status;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ErrorDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.NodeOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.StatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.utils.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowNodeDetailResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowNodeDetailResource.class);
    private ExperimentResource experimentResource;
    private String nodeInstanceId;
    private Timestamp creationTime;
    private String nodeName;
    private String executionUnit;
    private String executionUnitData;

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public String getNodeInstanceId() {
        return this.nodeInstanceId;
    }

    public void setNodeInstanceId(String nodeInstanceId) {
        this.nodeInstanceId = nodeInstanceId;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        switch (type) {
            case TASK_DETAIL: {
                TaskDetailResource taskDetailResource = new TaskDetailResource();
                taskDetailResource.setWorkflowNodeDetailResource(this);
                return taskDetailResource;
            }
            case ERROR_DETAIL: {
                ErrorDetailResource errorDetailResource = new ErrorDetailResource();
                errorDetailResource.setNodeDetail(this);
                return errorDetailResource;
            }
            case NODE_INPUT: {
                NodeInputResource nodeInputResource = new NodeInputResource();
                nodeInputResource.setNodeDetailResource(this);
                return nodeInputResource;
            }
            case NODE_OUTPUT: {
                NodeOutputResource nodeOutputResource = new NodeOutputResource();
                nodeOutputResource.setNodeDetailResource(this);
                return nodeOutputResource;
            }
            case STATUS: {
                StatusResource statusResource = new StatusResource();
                statusResource.setWorkflowNodeDetail(this);
                return statusResource;
            }
        }
        logger.error("Unsupported resource type for workflow node detail resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for workflow node detail resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case TASK_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("TaskDetail", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case NODE_INPUT: {
                    QueryGenerator generator = new QueryGenerator("NodeInput", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case NODE_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("NodeOutput", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for experiment resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case TASK_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("TaskDetail", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    TaskDetail taskDetail = (TaskDetail)q.getSingleResult();
                    TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.getResource(ResourceType.TASK_DETAIL, taskDetail);
                    em.getTransaction().commit();
                    em.close();
                    TaskDetailResource taskDetailResource2 = taskDetailResource;
                    return taskDetailResource2;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.selectQuery(em);
                    ErrorDetail errorDetail = (ErrorDetail)q.getSingleResult();
                    ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                    em.getTransaction().commit();
                    em.close();
                    ErrorDetailResource errorDetailResource2 = errorDetailResource;
                    return errorDetailResource2;
                }
                case NODE_INPUT: {
                    QueryGenerator generator = new QueryGenerator("NodeInput", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.selectQuery(em);
                    NodeInput nodeInput = (NodeInput)q.getSingleResult();
                    NodeInputResource nodeInputResource = (NodeInputResource)Utils.getResource(ResourceType.NODE_INPUT, nodeInput);
                    em.getTransaction().commit();
                    em.close();
                    NodeInputResource nodeInputResource2 = nodeInputResource;
                    return nodeInputResource2;
                }
                case NODE_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("NodeOutput", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.selectQuery(em);
                    NodeOutput nodeOutput = (NodeOutput)q.getSingleResult();
                    NodeOutputResource nodeOutputResource = (NodeOutputResource)Utils.getResource(ResourceType.NODE_OUTPUT, nodeOutput);
                    em.getTransaction().commit();
                    em.close();
                    NodeOutputResource nodeOutputResource2 = nodeOutputResource;
                    return nodeOutputResource2;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("nodeId", name);
                    Query q = generator.selectQuery(em);
                    Status status = (Status)q.getSingleResult();
                    StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                    em.getTransaction().commit();
                    em.close();
                    StatusResource statusResource2 = statusResource;
                    return statusResource2;
                }
            }
            try {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for workflow node resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for workflow node resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case TASK_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("TaskDetail", new Object[0][]);
                    generator.setParameter("nodeId", this.nodeInstanceId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        TaskDetail taskDetail = (TaskDetail)result;
                        TaskDetailResource taskDetailResource = (TaskDetailResource)Utils.getResource(ResourceType.TASK_DETAIL, taskDetail);
                        resourceList.add(taskDetailResource);
                    }
                    break;
                }
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("nodeId", this.nodeInstanceId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ErrorDetail errorDetail = (ErrorDetail)result;
                        ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                        resourceList.add(errorDetailResource);
                    }
                    break;
                }
                case NODE_INPUT: {
                    QueryGenerator generator = new QueryGenerator("NodeInput", new Object[0][]);
                    generator.setParameter("nodeId", this.nodeInstanceId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        NodeInput nodeInput = (NodeInput)result;
                        NodeInputResource nodeInputResource = (NodeInputResource)Utils.getResource(ResourceType.NODE_INPUT, nodeInput);
                        resourceList.add(nodeInputResource);
                    }
                    break;
                }
                case NODE_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("NodeOutput", new Object[0][]);
                    generator.setParameter("nodeId", this.nodeInstanceId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        NodeOutput nodeOutput = (NodeOutput)result;
                        NodeOutputResource nodeOutputResource = (NodeOutputResource)Utils.getResource(ResourceType.NODE_OUTPUT, nodeOutput);
                        resourceList.add(nodeOutputResource);
                    }
                    break;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("nodeId", this.nodeInstanceId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Status status = (Status)result;
                        StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                        resourceList.add(statusResource);
                    }
                    break;
                }
                default: {
                    em.getTransaction().commit();
                    em.close();
                    logger.error("Unsupported resource type for workflow node details resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            WorkflowNodeDetail existingNode = (WorkflowNodeDetail)em.find(WorkflowNodeDetail.class, (Object)this.nodeInstanceId);
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowNodeDetail workflowNodeDetail = new WorkflowNodeDetail();
            workflowNodeDetail.setNodeId(this.nodeInstanceId);
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            workflowNodeDetail.setExperiment(experiment);
            workflowNodeDetail.setExpId(this.experimentResource.getExpID());
            workflowNodeDetail.setCreationTime(this.creationTime);
            workflowNodeDetail.setNodeName(this.nodeName);
            workflowNodeDetail.setExecutionUnit(this.getExecutionUnit());
            workflowNodeDetail.setExecutionUnitData(this.getExecutionUnitData());
            if (existingNode != null) {
                existingNode.setExperiment(experiment);
                existingNode.setExpId(this.experimentResource.getExpID());
                existingNode.setCreationTime(this.creationTime);
                existingNode.setNodeName(this.nodeName);
                existingNode.setExecutionUnit(this.getExecutionUnit());
                existingNode.setExecutionUnitData(this.getExecutionUnitData());
                workflowNodeDetail = (WorkflowNodeDetail)em.merge((Object)existingNode);
            } else {
                em.persist((Object)workflowNodeDetail);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public List<NodeInputResource> getNodeInputs() throws RegistryException {
        ArrayList<NodeInputResource> nodeInputResourceList = new ArrayList<NodeInputResource>();
        List<Resource> resources = this.get(ResourceType.NODE_INPUT);
        for (Resource resource : resources) {
            NodeInputResource nodeInputResource = (NodeInputResource)resource;
            nodeInputResourceList.add(nodeInputResource);
        }
        return nodeInputResourceList;
    }

    public List<NodeOutputResource> getNodeOutputs() throws RegistryException {
        ArrayList<NodeOutputResource> outputResources = new ArrayList<NodeOutputResource>();
        List<Resource> resources = this.get(ResourceType.NODE_OUTPUT);
        for (Resource resource : resources) {
            NodeOutputResource nodeOutputResource = (NodeOutputResource)resource;
            outputResources.add(nodeOutputResource);
        }
        return outputResources;
    }

    public StatusResource getWorkflowNodeStatus() throws RegistryException {
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource nodeStatus = (StatusResource)resource;
            if (!nodeStatus.getStatusType().equals(StatusType.WORKFLOW_NODE.toString())) continue;
            if (nodeStatus.getState() == null || nodeStatus.getState().equals("")) {
                nodeStatus.setState("UNKNOWN");
            }
            return nodeStatus;
        }
        return null;
    }

    public StatusResource getTaskStatus(String taskId) throws RegistryException {
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource taskStatus = (StatusResource)resource;
            if (!taskStatus.getStatusType().equals(StatusType.TASK.toString()) || !taskStatus.getTaskDetailResource().getTaskId().equals(taskId)) continue;
            if (taskStatus.getState() == null || taskStatus.getState().equals("")) {
                taskStatus.setState("UNKNOWN");
            }
            return taskStatus;
        }
        return null;
    }

    public List<TaskDetailResource> getTaskDetails() throws RegistryException {
        ArrayList<TaskDetailResource> taskDetailResources = new ArrayList<TaskDetailResource>();
        List<Resource> resources = this.get(ResourceType.TASK_DETAIL);
        for (Resource resource : resources) {
            TaskDetailResource taskDetailResource = (TaskDetailResource)resource;
            taskDetailResources.add(taskDetailResource);
        }
        return taskDetailResources;
    }

    public List<ErrorDetailResource> getErrorDetails() throws RegistryException {
        ArrayList<ErrorDetailResource> errorDetails = new ArrayList<ErrorDetailResource>();
        List<Resource> resources = this.get(ResourceType.ERROR_DETAIL);
        for (Resource resource : resources) {
            ErrorDetailResource errorDetailResource = (ErrorDetailResource)resource;
            errorDetails.add(errorDetailResource);
        }
        return errorDetails;
    }

    public TaskDetailResource getTaskDetail(String taskId) throws RegistryException {
        return (TaskDetailResource)this.get(ResourceType.TASK_DETAIL, taskId);
    }

    public String getExecutionUnit() {
        return this.executionUnit;
    }

    public void setExecutionUnit(String executionUnit) {
        this.executionUnit = executionUnit;
    }

    public String getExecutionUnitData() {
        return this.executionUnitData;
    }

    public void setExecutionUnitData(String executionUnitData) {
        this.executionUnitData = executionUnitData;
    }
}

