/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.User_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.User_Workflow_PK;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserWorkflowResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UserWorkflowResource.class);
    private GatewayResource gateway;
    private WorkerResource worker;
    private String name;
    private Timestamp lastUpdateDate;
    private String content;
    private String path;

    public UserWorkflowResource() {
    }

    public UserWorkflowResource(GatewayResource gateway, WorkerResource worker, String name) {
        this.setGateway(gateway);
        this.setWorker(worker);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setLastUpdateDate(Timestamp lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Timestamp getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public String getContent() {
        return this.content;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for user workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            User_Workflow existingWF = (User_Workflow)em.find(User_Workflow.class, (Object)new User_Workflow_PK(this.name, this.worker.getUser(), this.gateway.getGatewayName()));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            User_Workflow userWorkflow = new User_Workflow();
            userWorkflow.setTemplate_name(this.name);
            if (this.lastUpdateDate == null) {
                Date date = new Date();
                this.lastUpdateDate = new Timestamp(date.getTime());
            }
            userWorkflow.setLast_updated_date(this.lastUpdateDate);
            byte[] bytes = this.content.getBytes();
            userWorkflow.setWorkflow_graph(bytes);
            userWorkflow.setGateway_name(this.gateway.getGatewayName());
            userWorkflow.setOwner(this.getWorker().getUser());
            userWorkflow.setPath(this.path);
            if (existingWF != null) {
                existingWF.setGateway_name(this.gateway.getGatewayName());
                existingWF.setOwner(this.getWorker().getUser());
                existingWF.setTemplate_name(this.name);
                existingWF.setLast_updated_date(this.lastUpdateDate);
                existingWF.setPath(this.path);
                existingWF.setWorkflow_graph(bytes);
                userWorkflow = (User_Workflow)em.merge((Object)existingWF);
            } else {
                em.persist((Object)userWorkflow);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for user workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public WorkerResource getWorker() {
        return this.worker;
    }

    public void setWorker(WorkerResource worker) {
        this.worker = worker;
    }
}

