/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedInputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.AdvancedOutputDataHandling;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationInput;
import org.apache.airavata.persistance.registry.jpa.model.ApplicationOutput;
import org.apache.airavata.persistance.registry.jpa.model.Computational_Resource_Scheduling;
import org.apache.airavata.persistance.registry.jpa.model.DataTransferDetail;
import org.apache.airavata.persistance.registry.jpa.model.ErrorDetail;
import org.apache.airavata.persistance.registry.jpa.model.JobDetail;
import org.apache.airavata.persistance.registry.jpa.model.QosParam;
import org.apache.airavata.persistance.registry.jpa.model.Status;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.AdvanceInputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.AdvancedOutputDataHandlingResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationInputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationOutputResource;
import org.apache.airavata.persistance.registry.jpa.resources.ComputationSchedulingResource;
import org.apache.airavata.persistance.registry.jpa.resources.DataTransferDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.ErrorDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.JobDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.QosParamResource;
import org.apache.airavata.persistance.registry.jpa.resources.StatusResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.utils.StatusType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDetailResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(TaskDetailResource.class);
    private String taskId;
    private WorkflowNodeDetailResource workflowNodeDetailResource;
    private Timestamp creationTime;
    private String applicationId;
    private String applicationVersion;
    private String applicationDeploymentId;

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public WorkflowNodeDetailResource getWorkflowNodeDetailResource() {
        return this.workflowNodeDetailResource;
    }

    public void setWorkflowNodeDetailResource(WorkflowNodeDetailResource workflowNodeDetailResource) {
        this.workflowNodeDetailResource = workflowNodeDetailResource;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        switch (type) {
            case ERROR_DETAIL: {
                ErrorDetailResource errorDetailResource = new ErrorDetailResource();
                errorDetailResource.setTaskDetailResource(this);
                return errorDetailResource;
            }
            case APPLICATION_INPUT: {
                ApplicationInputResource applicationInputResource = new ApplicationInputResource();
                applicationInputResource.setTaskDetailResource(this);
                return applicationInputResource;
            }
            case APPLICATION_OUTPUT: {
                ApplicationOutputResource applicationOutputResource = new ApplicationOutputResource();
                applicationOutputResource.setTaskDetailResource(this);
                return applicationOutputResource;
            }
            case JOB_DETAIL: {
                JobDetailResource jobDetailResource = new JobDetailResource();
                jobDetailResource.setTaskDetailResource(this);
                return jobDetailResource;
            }
            case DATA_TRANSFER_DETAIL: {
                DataTransferDetailResource dataTransferDetailResource = new DataTransferDetailResource();
                dataTransferDetailResource.setTaskDetailResource(this);
                return dataTransferDetailResource;
            }
            case STATUS: {
                StatusResource statusResource = new StatusResource();
                statusResource.setTaskDetailResource(this);
                return statusResource;
            }
            case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                ComputationSchedulingResource schedulingResource = new ComputationSchedulingResource();
                schedulingResource.setTaskDetailResource(this);
                return schedulingResource;
            }
            case ADVANCE_INPUT_DATA_HANDLING: {
                AdvanceInputDataHandlingResource inputDataHandlingResource = new AdvanceInputDataHandlingResource();
                inputDataHandlingResource.setTaskDetailResource(this);
                return inputDataHandlingResource;
            }
            case ADVANCE_OUTPUT_DATA_HANDLING: {
                AdvancedOutputDataHandlingResource outputDataHandlingResource = new AdvancedOutputDataHandlingResource();
                outputDataHandlingResource.setTaskDetailResource(this);
                return outputDataHandlingResource;
            }
            case QOS_PARAM: {
                QosParamResource qosParamResource = new QosParamResource();
                qosParamResource.setTaskDetailResource(this);
                return qosParamResource;
            }
        }
        logger.error("Unsupported resource type for task detail resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for task detail resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case APPLICATION_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ApplicationInput", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case APPLICATION_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ApplicationOutput", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case JOB_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("JobDetail", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    generator.setParameter("jobId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case DATA_TRANSFER_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("DataTransferDetail", new Object[0][]);
                    generator.setParameter("transferId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    QueryGenerator generator = new QueryGenerator("Computational_Resource_Scheduling", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedInputDataHandling", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedOutputDataHandling", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case QOS_PARAM: {
                    QueryGenerator generator = new QueryGenerator("QosParam", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for task detail resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    ErrorDetail errorDetail = (ErrorDetail)q.getSingleResult();
                    ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                    em.getTransaction().commit();
                    em.close();
                    ErrorDetailResource errorDetailResource2 = errorDetailResource;
                    return errorDetailResource2;
                }
                case APPLICATION_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ApplicationInput", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    ApplicationInput applicationInput = (ApplicationInput)q.getSingleResult();
                    ApplicationInputResource inputResource = (ApplicationInputResource)Utils.getResource(ResourceType.APPLICATION_INPUT, applicationInput);
                    em.getTransaction().commit();
                    em.close();
                    ApplicationInputResource applicationInputResource = inputResource;
                    return applicationInputResource;
                }
                case APPLICATION_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ApplicationOutput", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    ApplicationOutput applicationOutput = (ApplicationOutput)q.getSingleResult();
                    ApplicationOutputResource outputResource = (ApplicationOutputResource)Utils.getResource(ResourceType.APPLICATION_OUTPUT, applicationOutput);
                    em.getTransaction().commit();
                    em.close();
                    ApplicationOutputResource applicationOutputResource = outputResource;
                    return applicationOutputResource;
                }
                case JOB_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("JobDetail", new Object[0][]);
                    generator.setParameter("jobId", name);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    JobDetail jobDetail = (JobDetail)q.getSingleResult();
                    JobDetailResource jobDetailResource = (JobDetailResource)Utils.getResource(ResourceType.JOB_DETAIL, jobDetail);
                    em.getTransaction().commit();
                    em.close();
                    JobDetailResource jobDetailResource2 = jobDetailResource;
                    return jobDetailResource2;
                }
                case DATA_TRANSFER_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("DataTransferDetail", new Object[0][]);
                    generator.setParameter("transferId", name);
                    Query q = generator.selectQuery(em);
                    DataTransferDetail transferDetail = (DataTransferDetail)q.getSingleResult();
                    DataTransferDetailResource transferDetailResource = (DataTransferDetailResource)Utils.getResource(ResourceType.DATA_TRANSFER_DETAIL, transferDetail);
                    em.getTransaction().commit();
                    em.close();
                    DataTransferDetailResource dataTransferDetailResource = transferDetailResource;
                    return dataTransferDetailResource;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    Status status = (Status)q.getSingleResult();
                    StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                    em.getTransaction().commit();
                    em.close();
                    StatusResource statusResource2 = statusResource;
                    return statusResource2;
                }
                case COMPUTATIONAL_RESOURCE_SCHEDULING: {
                    QueryGenerator generator = new QueryGenerator("Computational_Resource_Scheduling", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    Computational_Resource_Scheduling resourceScheduling = (Computational_Resource_Scheduling)q.getSingleResult();
                    ComputationSchedulingResource schedulingResource = (ComputationSchedulingResource)Utils.getResource(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, resourceScheduling);
                    em.getTransaction().commit();
                    em.close();
                    ComputationSchedulingResource computationSchedulingResource = schedulingResource;
                    return computationSchedulingResource;
                }
                case ADVANCE_INPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedInputDataHandling", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    AdvancedInputDataHandling dataHandling = (AdvancedInputDataHandling)q.getSingleResult();
                    AdvanceInputDataHandlingResource inputDataHandlingResource = (AdvanceInputDataHandlingResource)Utils.getResource(ResourceType.ADVANCE_INPUT_DATA_HANDLING, dataHandling);
                    em.getTransaction().commit();
                    em.close();
                    AdvanceInputDataHandlingResource advanceInputDataHandlingResource = inputDataHandlingResource;
                    return advanceInputDataHandlingResource;
                }
                case ADVANCE_OUTPUT_DATA_HANDLING: {
                    QueryGenerator generator = new QueryGenerator("AdvancedOutputDataHandling", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    AdvancedOutputDataHandling outputDataHandling = (AdvancedOutputDataHandling)q.getSingleResult();
                    AdvancedOutputDataHandlingResource outputDataHandlingResource = (AdvancedOutputDataHandlingResource)Utils.getResource(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, outputDataHandling);
                    em.getTransaction().commit();
                    em.close();
                    AdvancedOutputDataHandlingResource advancedOutputDataHandlingResource = outputDataHandlingResource;
                    return advancedOutputDataHandlingResource;
                }
                case QOS_PARAM: {
                    QueryGenerator generator = new QueryGenerator("QosParam", new Object[0][]);
                    generator.setParameter("taskId", name);
                    Query q = generator.selectQuery(em);
                    QosParam qosParam = (QosParam)q.getSingleResult();
                    QosParamResource qosParamResource = (QosParamResource)Utils.getResource(ResourceType.QOS_PARAM, qosParam);
                    em.getTransaction().commit();
                    em.close();
                    QosParamResource qosParamResource2 = qosParamResource;
                    return qosParamResource2;
                }
            }
            try {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for workflow node resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for workflow node resource.");
            }
            catch (Exception e) {
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case ERROR_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("ErrorDetail", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ErrorDetail errorDetail = (ErrorDetail)result;
                        ErrorDetailResource errorDetailResource = (ErrorDetailResource)Utils.getResource(ResourceType.ERROR_DETAIL, errorDetail);
                        resourceList.add(errorDetailResource);
                    }
                    break;
                }
                case APPLICATION_INPUT: {
                    QueryGenerator generator = new QueryGenerator("ApplicationInput", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ApplicationInput applicationInput = (ApplicationInput)result;
                        ApplicationInputResource inputResource = (ApplicationInputResource)Utils.getResource(ResourceType.APPLICATION_INPUT, applicationInput);
                        resourceList.add(inputResource);
                    }
                    break;
                }
                case APPLICATION_OUTPUT: {
                    QueryGenerator generator = new QueryGenerator("ApplicationOutput", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        ApplicationOutput applicationOutput = (ApplicationOutput)result;
                        ApplicationOutputResource outputResource = (ApplicationOutputResource)Utils.getResource(ResourceType.APPLICATION_OUTPUT, applicationOutput);
                        resourceList.add(outputResource);
                    }
                    break;
                }
                case JOB_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("JobDetail", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        JobDetail jobDetail = (JobDetail)result;
                        JobDetailResource jobDetailResource = (JobDetailResource)Utils.getResource(ResourceType.JOB_DETAIL, jobDetail);
                        resourceList.add(jobDetailResource);
                    }
                    break;
                }
                case DATA_TRANSFER_DETAIL: {
                    QueryGenerator generator = new QueryGenerator("DataTransferDetail", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        DataTransferDetail transferDetail = (DataTransferDetail)result;
                        DataTransferDetailResource transferDetailResource = (DataTransferDetailResource)Utils.getResource(ResourceType.DATA_TRANSFER_DETAIL, transferDetail);
                        resourceList.add(transferDetailResource);
                    }
                    break;
                }
                case STATUS: {
                    QueryGenerator generator = new QueryGenerator("Status", new Object[0][]);
                    generator.setParameter("taskId", this.taskId);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Status status = (Status)result;
                        StatusResource statusResource = (StatusResource)Utils.getResource(ResourceType.STATUS, status);
                        resourceList.add(statusResource);
                    }
                    break;
                }
                default: {
                    em.getTransaction().commit();
                    em.close();
                    logger.error("Unsupported resource type for workflow node details resource.", (Throwable)new UnsupportedOperationException());
                    throw new UnsupportedOperationException();
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskId);
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            WorkflowNodeDetail workflowNodeDetail = (WorkflowNodeDetail)em.find(WorkflowNodeDetail.class, (Object)this.workflowNodeDetailResource.getNodeInstanceId());
            if (taskDetail != null) {
                this.updateTaskDetail(taskDetail, workflowNodeDetail);
                em.merge((Object)taskDetail);
            } else {
                taskDetail = new TaskDetail();
                this.updateTaskDetail(taskDetail, workflowNodeDetail);
                em.persist((Object)taskDetail);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    private void updateTaskDetail(TaskDetail taskDetail, WorkflowNodeDetail workflowNodeDetail) {
        taskDetail.setTaskId(this.taskId);
        taskDetail.setNodeDetail(workflowNodeDetail);
        taskDetail.setNodeId(this.workflowNodeDetailResource.getNodeInstanceId());
        taskDetail.setCreationTime(this.creationTime);
        taskDetail.setAppId(this.applicationId);
        taskDetail.setAppVersion(this.applicationVersion);
        taskDetail.setApplicationDeploymentId(this.getApplicationDeploymentId());
    }

    public List<ApplicationInputResource> getApplicationInputs() throws RegistryException {
        ArrayList<ApplicationInputResource> applicationInputResources = new ArrayList<ApplicationInputResource>();
        List<Resource> resources = this.get(ResourceType.APPLICATION_INPUT);
        for (Resource resource : resources) {
            ApplicationInputResource inputResource = (ApplicationInputResource)resource;
            applicationInputResources.add(inputResource);
        }
        return applicationInputResources;
    }

    public List<ApplicationOutputResource> getApplicationOutputs() throws RegistryException {
        ArrayList<ApplicationOutputResource> outputResources = new ArrayList<ApplicationOutputResource>();
        List<Resource> resources = this.get(ResourceType.APPLICATION_OUTPUT);
        for (Resource resource : resources) {
            ApplicationOutputResource outputResource = (ApplicationOutputResource)resource;
            outputResources.add(outputResource);
        }
        return outputResources;
    }

    public StatusResource getTaskStatus() throws RegistryException {
        List<Resource> resources = this.get(ResourceType.STATUS);
        for (Resource resource : resources) {
            StatusResource taskStatus = (StatusResource)resource;
            if (!taskStatus.getStatusType().equals(StatusType.TASK.toString())) continue;
            if (taskStatus.getState() == null || taskStatus.getState().equals("")) {
                taskStatus.setState("UNKNOWN");
            }
            return taskStatus;
        }
        return null;
    }

    public List<JobDetailResource> getJobDetailList() throws RegistryException {
        ArrayList<JobDetailResource> jobDetailResources = new ArrayList<JobDetailResource>();
        List<Resource> resources = this.get(ResourceType.JOB_DETAIL);
        for (Resource resource : resources) {
            JobDetailResource jobDetailResource = (JobDetailResource)resource;
            jobDetailResources.add(jobDetailResource);
        }
        return jobDetailResources;
    }

    public List<DataTransferDetailResource> getDataTransferDetailList() throws RegistryException {
        ArrayList<DataTransferDetailResource> transferDetails = new ArrayList<DataTransferDetailResource>();
        List<Resource> resources = this.get(ResourceType.DATA_TRANSFER_DETAIL);
        for (Resource resource : resources) {
            DataTransferDetailResource transferDetailResource = (DataTransferDetailResource)resource;
            transferDetails.add(transferDetailResource);
        }
        return transferDetails;
    }

    public List<ErrorDetailResource> getErrorDetailList() throws RegistryException {
        ArrayList<ErrorDetailResource> errorDetailResources = new ArrayList<ErrorDetailResource>();
        List<Resource> resources = this.get(ResourceType.ERROR_DETAIL);
        for (Resource resource : resources) {
            ErrorDetailResource errorDetailResource = (ErrorDetailResource)resource;
            errorDetailResources.add(errorDetailResource);
        }
        return errorDetailResources;
    }

    public ComputationSchedulingResource getComputationScheduling(String taskId) throws RegistryException {
        return (ComputationSchedulingResource)this.get(ResourceType.COMPUTATIONAL_RESOURCE_SCHEDULING, taskId);
    }

    public AdvanceInputDataHandlingResource getInputDataHandling(String taskId) throws RegistryException {
        return (AdvanceInputDataHandlingResource)this.get(ResourceType.ADVANCE_INPUT_DATA_HANDLING, taskId);
    }

    public AdvancedOutputDataHandlingResource getOutputDataHandling(String taskId) throws RegistryException {
        return (AdvancedOutputDataHandlingResource)this.get(ResourceType.ADVANCE_OUTPUT_DATA_HANDLING, taskId);
    }

    public JobDetailResource createJobDetail(String jobId) throws RegistryException {
        JobDetailResource resource = (JobDetailResource)this.create(ResourceType.JOB_DETAIL);
        resource.setJobId(jobId);
        return resource;
    }

    public JobDetailResource getJobDetail(String jobId) throws RegistryException {
        return (JobDetailResource)this.get(ResourceType.JOB_DETAIL, jobId);
    }

    public DataTransferDetailResource getDataTransferDetail(String dataTransferId) throws RegistryException {
        return (DataTransferDetailResource)this.get(ResourceType.DATA_TRANSFER_DETAIL, dataTransferId);
    }

    public boolean isTaskStatusExist(String taskId) throws RegistryException {
        return this.isExists(ResourceType.STATUS, taskId);
    }

    public String getApplicationDeploymentId() {
        return this.applicationDeploymentId;
    }

    public void setApplicationDeploymentId(String applicationDeploymentId) {
        this.applicationDeploymentId = applicationDeploymentId;
    }
}

