/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishWorkflowResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(PublishWorkflowResource.class);
    private String name;
    private String version;
    private Timestamp publishedDate;
    private String content;
    private GatewayResource gateway;
    private String createdUser;
    private String path;

    public PublishWorkflowResource() {
    }

    public PublishWorkflowResource(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public String getCreatedUser() {
        return this.createdUser;
    }

    public String getPath() {
        return this.path;
    }

    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public Timestamp getPublishedDate() {
        return this.publishedDate;
    }

    public String getContent() {
        return this.content;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setPublishedDate(Timestamp publishedDate) {
        this.publishedDate = publishedDate;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Published_Workflow existingWF = (Published_Workflow)em.find(Published_Workflow.class, (Object)new Published_Workflow_PK(this.gateway.getGatewayName(), this.name));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Published_Workflow publishedWorkflow = new Published_Workflow();
            publishedWorkflow.setPublish_workflow_name(this.getName());
            publishedWorkflow.setPublished_date(this.publishedDate);
            publishedWorkflow.setVersion(this.version);
            byte[] bytes = this.content.getBytes();
            publishedWorkflow.setWorkflow_content(bytes);
            Gateway existingGateway = (Gateway)em.find(Gateway.class, (Object)this.gateway.getGatewayName());
            publishedWorkflow.setGateway(existingGateway);
            publishedWorkflow.setGateway_name(existingGateway.getGateway_name());
            Users user = (Users)em.find(Users.class, (Object)this.createdUser);
            publishedWorkflow.setUser(user);
            if (existingWF != null) {
                existingWF.setUser(user);
                existingWF.setGateway(existingGateway);
                existingWF.setGateway_name(existingGateway.getGateway_name());
                existingWF.setPublished_date(this.publishedDate);
                existingWF.setWorkflow_content(bytes);
                existingWF.setVersion(this.version);
                existingWF.setPath(this.path);
                publishedWorkflow = (Published_Workflow)em.merge((Object)existingWF);
            } else {
                em.merge((Object)publishedWorkflow);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for published workflow resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public void setName(String name) {
        this.name = name;
    }
}

