/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.impl;

import org.apache.airavata.persistance.registry.jpa.impl.LoggingRegistryImpl;
import org.apache.airavata.persistance.registry.jpa.impl.RegistryImpl;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryFactory {
    private static Registry registry;
    private static Logger logger;

    public static Registry getRegistry(String gateway, String username, String password) throws RegistryException {
        try {
            if (registry == null) {
                registry = new RegistryImpl(gateway, username, password);
            }
        }
        catch (RegistryException e) {
            logger.error("Unable to create registry instance", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return registry;
    }

    public static Registry getDefaultRegistry() throws RegistryException {
        try {
            if (registry == null) {
                registry = new RegistryImpl();
            }
        }
        catch (RegistryException e) {
            logger.error("Unable to create registry instance", (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        return registry;
    }

    public static Registry getLoggingRegistry() {
        if (registry == null) {
            registry = new LoggingRegistryImpl();
        }
        return registry;
    }

    static {
        logger = LoggerFactory.getLogger(RegistryFactory.class);
    }
}

