/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.model.Configuration;
import org.apache.airavata.persistance.registry.jpa.model.Configuration_PK;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.ConfigurationResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);
    private static final String PERSISTENCE_UNIT_NAME = "airavata_data";
    protected static EntityManagerFactory factory;

    public static void reset() {
        factory = null;
    }

    public static EntityManager getEntityManager() {
        if (factory == null) {
            String connectionProperties = "DriverClassName=" + Utils.getJDBCDriver() + "," + "Url=" + Utils.getJDBCURL() + "," + "Username=" + Utils.getJDBCUser() + "," + "Password=" + Utils.getJDBCPassword() + ",validationQuery=" + Utils.getValidationQuery();
            System.out.println(connectionProperties);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("openjpa.ConnectionDriverName", "org.apache.commons.dbcp.BasicDataSource");
            properties.put("openjpa.ConnectionProperties", connectionProperties);
            properties.put("openjpa.DynamicEnhancementAgent", "true");
            properties.put("openjpa.RuntimeUnenhancedClasses", "unsupported");
            properties.put("openjpa.DataCache", "true(CacheSize=" + Utils.getJPACacheSize() + ", SoftReferenceSize=0)");
            properties.put("openjpa.QueryCache", "true(CacheSize=" + Utils.getJPACacheSize() + ", SoftReferenceSize=0)");
            properties.put("openjpa.RemoteCommitProvider", "sjvm");
            properties.put("openjpa.Log", "DefaultLevel=INFO, Runtime=INFO, Tool=INFO, SQL=INFO");
            properties.put("openjpa.jdbc.DBDictionary", "SupportsMultipleNontransactionalResultSets=false");
            properties.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
            properties.put("openjpa.jdbc.QuerySQLCache", "false");
            factory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, properties);
        }
        return factory.createEntityManager();
    }

    public static Resource createGateway(String gatewayName) throws RegistryException {
        if (!ResourceUtils.isGatewayExist(gatewayName)) {
            GatewayResource gatewayResource = new GatewayResource();
            gatewayResource.setGatewayName(gatewayName);
            return gatewayResource;
        }
        return ResourceUtils.getGateway(gatewayName);
    }

    public static UserResource createUser(String username, String password) throws RegistryException {
        if (!ResourceUtils.isUserExist(username)) {
            UserResource userResource = new UserResource();
            userResource.setUserName(username);
            userResource.setPassword(password);
            return userResource;
        }
        return (UserResource)ResourceUtils.getUser(username);
    }

    public static Resource getGateway(String gatewayName) throws RegistryException {
        EntityManager em = null;
        try {
            if (ResourceUtils.isGatewayExist(gatewayName)) {
                em = ResourceUtils.getEntityManager();
                Gateway gateway = (Gateway)em.find(Gateway.class, (Object)gatewayName);
                GatewayResource gatewayResource = (GatewayResource)Utils.getResource(ResourceType.GATEWAY, gateway);
                em.close();
                GatewayResource gatewayResource2 = gatewayResource;
                return gatewayResource2;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return null;
    }

    public static void addUser(String userName, String password) throws RegistryException {
        UserResource resource = new UserResource();
        resource.setUserName(userName);
        resource.setPassword(password);
        resource.save();
    }

    public static boolean isUserExist(String username) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
            generator.setParameter("user_name", username);
            Query q = generator.selectQuery(em);
            int size = q.getResultList().size();
            em.getTransaction().commit();
            em.close();
            boolean bl = size > 0;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static Resource getUser(String userName) throws RegistryException {
        EntityManager em = null;
        try {
            if (ResourceUtils.isUserExist(userName)) {
                em = ResourceUtils.getEntityManager();
                Users user = (Users)em.find(Users.class, (Object)userName);
                UserResource userResource = (UserResource)Utils.getResource(ResourceType.USER, user);
                em.close();
                UserResource userResource2 = userResource;
                return userResource2;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return null;
    }

    public static Resource getWorker(String gatewayName, String userName) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Gateway_Worker gatewayWorker = (Gateway_Worker)em.find(Gateway_Worker.class, (Object)new Gateway_Worker_PK(gatewayName, userName));
            WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
            em.close();
            WorkerResource workerResource2 = workerResource;
            return workerResource2;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static boolean isGatewayExist(String gatewayName) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway", new Object[0][]);
            generator.setParameter("gateway_name", gatewayName);
            Query q = generator.selectQuery(em);
            int size = q.getResultList().size();
            em.getTransaction().commit();
            em.close();
            boolean bl = size > 0;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeGateway(String gatewayName) {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway", new Object[0][]);
            generator.setParameter("gateway_name", gatewayName);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static WorkerResource addGatewayWorker(GatewayResource gatewayResource, UserResource userResource) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            if (!ResourceUtils.isGatewayExist(gatewayResource.getGatewayName())) {
                gatewayResource.save();
            }
            if (!ResourceUtils.isUserExist(userResource.getUserName())) {
                userResource.save();
            }
            Gateway gateway = (Gateway)em.find(Gateway.class, (Object)gatewayResource.getGatewayName());
            Users user = (Users)em.find(Users.class, (Object)userResource.getUserName());
            Gateway_Worker gatewayWorker = new Gateway_Worker();
            gatewayWorker.setGateway(gateway);
            gatewayWorker.setUser(user);
            em.persist((Object)gatewayWorker);
            em.getTransaction().commit();
            em.close();
            WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
            return workerResource;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeGatewayWorker(GatewayResource gatewayResource, UserResource userResource) {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Gateway_Worker", new Object[0][]);
            generator.setParameter("gateway_name", gatewayResource.getGatewayName());
            generator.setParameter("user_name", userResource.getUserName());
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            em.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConfigurationResource> getConfigurations(String configKey) {
        ArrayList<ConfigurationResource> list = new ArrayList<ConfigurationResource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            QueryGenerator generator = new QueryGenerator("Configuration", new Object[0][]);
            generator.setParameter("config_key", configKey);
            Query q = generator.selectQuery(em);
            List resultList = q.getResultList();
            if (resultList.size() != 0) {
                for (Object result : resultList) {
                    ConfigurationResource configurationResource = ResourceUtils.createConfigurationResourceObject(result);
                    list.add(configurationResource);
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return list;
    }

    public static ConfigurationResource getConfiguration(String configKey) {
        List<ConfigurationResource> configurations = ResourceUtils.getConfigurations(configKey);
        return configurations != null && configurations.size() > 0 ? configurations.get(0) : null;
    }

    public static boolean isConfigurationExist(String configKey) {
        List<ConfigurationResource> configurations = ResourceUtils.getConfigurations(configKey);
        return configurations != null && configurations.size() > 0;
    }

    public static ConfigurationResource createConfiguration(String configKey) {
        ConfigurationResource config = new ConfigurationResource();
        config.setConfigKey(configKey);
        return config;
    }

    private static ConfigurationResource createConfigurationResourceObject(Object result) {
        Configuration configuration = (Configuration)result;
        ConfigurationResource configurationResource = new ConfigurationResource(configuration.getConfig_key(), configuration.getConfig_val());
        configurationResource.setExpireDate(configuration.getExpire_date());
        return configurationResource;
    }

    public static void removeConfiguration(String configkey, String configValue) throws RegistryException {
        QueryGenerator queryGenerator = new QueryGenerator("Configuration", new Object[0][]);
        queryGenerator.setParameter("config_key", configkey);
        queryGenerator.setParameter("config_val", configValue);
        EntityManager em = null;
        try {
            if (ResourceUtils.isConfigurationExists(configkey, configValue)) {
                em = ResourceUtils.getEntityManager();
                em.getTransaction().begin();
                Query q = queryGenerator.deleteQuery(em);
                q.executeUpdate();
                em.getTransaction().commit();
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static void removeConfiguration(String configkey) throws RegistryException {
        QueryGenerator queryGenerator = new QueryGenerator("Configuration", new Object[0][]);
        queryGenerator.setParameter("config_key", configkey);
        EntityManager em = null;
        try {
            if (ResourceUtils.isConfigurationExist(configkey)) {
                em = ResourceUtils.getEntityManager();
                em.getTransaction().begin();
                Query q = queryGenerator.deleteQuery(em);
                q.executeUpdate();
                em.getTransaction().commit();
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public static boolean isConfigurationExists(String configKey, String configVal) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Configuration existing = (Configuration)em.find(Configuration.class, (Object)new Configuration_PK(configKey, configVal, "SYSTEM"));
            em.close();
            boolean bl = existing != null;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

