/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.utils;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class QueryGenerator {
    private String tableName;
    private Map<String, Object> matches = new HashMap<String, Object>();
    private static final String SELECT_OBJ = "p";
    private static final String DELETE_OBJ = "p";
    private static final String TABLE_OBJ = "p";

    public QueryGenerator(String tableName, Object[] ... params) {
        this.setTableName(tableName);
        for (Object[] param : params) {
            this.addMatch(param[0].toString(), param[1]);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addMatch(String colName, Object matchValue) {
        this.matches.put(colName, matchValue);
    }

    public void setParameter(String colName, Object matchValue) {
        this.addMatch(colName, matchValue);
    }

    public Query selectQuery(EntityManager entityManager) {
        String queryString = "SELECT p FROM " + this.getTableName() + " " + "p";
        return this.generateQueryWithParameters(entityManager, queryString);
    }

    public Query deleteQuery(EntityManager entityManager) {
        String queryString = "Delete FROM " + this.getTableName() + " " + "p";
        return this.generateQueryWithParameters(entityManager, queryString);
    }

    private Query generateQueryWithParameters(EntityManager entityManager, String queryString) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        if (this.matches.size() > 0) {
            String matchString = "";
            int paramCount = 0;
            for (String colName : this.matches.keySet()) {
                String paramName = "param" + paramCount;
                queryParameters.put(paramName, this.matches.get(colName));
                if (!matchString.equals("")) {
                    matchString = matchString + " AND ";
                }
                matchString = matchString + "p." + colName + " =:" + paramName;
                ++paramCount;
            }
            queryString = queryString + " WHERE " + matchString;
        }
        Query query = entityManager.createQuery(queryString);
        for (String paramName : queryParameters.keySet()) {
            query.setParameter(paramName, queryParameters.get(paramName));
        }
        return query;
    }
}

