/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker_PK;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.User_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.GatewayResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(WorkerResource.class);
    private String user;
    private GatewayResource gateway;

    public WorkerResource() {
    }

    public WorkerResource(String user, GatewayResource gateway) {
        this.setUser(user);
        this.gateway = gateway;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        AbstractResource result = null;
        switch (type) {
            case PROJECT: {
                ProjectResource projectResource = new ProjectResource();
                projectResource.setWorker(this);
                projectResource.setGateway(this.gateway);
                result = projectResource;
                break;
            }
            case USER_WORKFLOW: {
                UserWorkflowResource userWorkflowResource = new UserWorkflowResource();
                userWorkflowResource.setWorker(this);
                userWorkflowResource.setGateway(this.gateway);
                result = userWorkflowResource;
                break;
            }
            case EXPERIMENT: {
                ExperimentResource experimentResource = new ExperimentResource();
                experimentResource.setExecutionUser(this.user);
                experimentResource.setGateway(this.gateway);
                result = experimentResource;
                break;
            }
            default: {
                logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for worker resource.");
            }
        }
        return result;
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    generator.setParameter("project_id", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case USER_WORKFLOW: {
                    QueryGenerator generator = new QueryGenerator("User_Workflow", new Object[0][]);
                    generator.setParameter("owner", this.getUser());
                    generator.setParameter("template_name", name);
                    generator.setParameter("gateway_name", this.gateway.getGatewayName());
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException(e.getMessage());
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        Resource result = null;
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    generator.setParameter("project_id", name);
                    Query q = generator.selectQuery(em);
                    Project project = (Project)q.getSingleResult();
                    result = Utils.getResource(ResourceType.PROJECT, project);
                    break;
                }
                case USER_WORKFLOW: {
                    QueryGenerator generator = new QueryGenerator("User_Workflow", new Object[0][]);
                    generator.setParameter("owner", this.getUser());
                    generator.setParameter("template_name", name);
                    generator.setParameter("gateway_name", this.gateway.getGatewayName());
                    Query q = generator.selectQuery(em);
                    User_Workflow userWorkflow = (User_Workflow)q.getSingleResult();
                    result = Utils.getResource(ResourceType.USER_WORKFLOW, userWorkflow);
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.selectQuery(em);
                    Experiment experiment = (Experiment)q.getSingleResult();
                    result = Utils.getResource(ResourceType.EXPERIMENT, experiment);
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    Users users = (Users)em.find(Users.class, (Object)this.getUser());
                    Gateway gatewayModel = (Gateway)em.find(Gateway.class, (Object)this.gateway.getGatewayName());
                    generator.setParameter("users", users);
                    generator.setParameter("gateway", gatewayModel);
                    Query q = generator.selectQuery(em);
                    for (Object o : q.getResultList()) {
                        Project project = (Project)o;
                        ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                        result.add(projectResource);
                    }
                    break;
                }
                case USER_WORKFLOW: {
                    QueryGenerator generator = new QueryGenerator("User_Workflow", new Object[0][]);
                    generator.setParameter("owner", this.getUser());
                    Query q = generator.selectQuery(em);
                    for (Object o : q.getResultList()) {
                        User_Workflow userWorkflow = (User_Workflow)o;
                        UserWorkflowResource userWorkflowResource = (UserWorkflowResource)Utils.getResource(ResourceType.USER_WORKFLOW, userWorkflow);
                        result.add(userWorkflowResource);
                    }
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("executionUser", this.getUser());
                    Query q = generator.selectQuery(em);
                    for (Object o : q.getResultList()) {
                        Experiment experiment = (Experiment)o;
                        ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                        result.add(experimentResource);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for worker resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Gateway_Worker existingWorker = (Gateway_Worker)em.find(Gateway_Worker.class, (Object)new Gateway_Worker_PK(this.gateway.getGatewayName(), this.user));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Gateway_Worker gatewayWorker = new Gateway_Worker();
            Users existingUser = (Users)em.find(Users.class, (Object)this.user);
            gatewayWorker.setUser(existingUser);
            gatewayWorker.setUser_name(existingUser.getUser_name());
            Gateway gatewaymodel = (Gateway)em.find(Gateway.class, (Object)this.gateway.getGatewayName());
            gatewayWorker.setGateway(gatewaymodel);
            gatewayWorker.setGateway_name(gatewaymodel.getGateway_name());
            if (existingWorker != null) {
                existingWorker.setUser_name(existingUser.getUser_name());
                existingWorker.setUser(existingUser);
                existingWorker.setGateway(gatewaymodel);
                existingWorker.setGateway_name(gatewaymodel.getGateway_name());
                gatewayWorker = (Gateway_Worker)em.merge((Object)existingWorker);
            } else {
                em.persist((Object)gatewayWorker);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public GatewayResource getGateway() {
        return this.gateway;
    }

    public void setGateway(GatewayResource gateway) {
        this.gateway = gateway;
    }

    public boolean isProjectExists(String id) throws RegistryException {
        return this.isExists(ResourceType.PROJECT, id);
    }

    public ProjectResource createProject(String projectId) throws RegistryException {
        ProjectResource project = (ProjectResource)this.create(ResourceType.PROJECT);
        project.setId(projectId);
        return project;
    }

    public String getProjectID(String projectName) {
        String pro = projectName.replaceAll("\\s", "");
        return pro + "_" + UUID.randomUUID();
    }

    public ProjectResource getProject(String id) throws RegistryException {
        return (ProjectResource)this.get(ResourceType.PROJECT, id);
    }

    public void removeProject(String id) throws RegistryException {
        this.remove(ResourceType.PROJECT, id);
    }

    public List<ProjectResource> getProjects() throws RegistryException {
        ArrayList<ProjectResource> result = new ArrayList<ProjectResource>();
        List<Resource> list = this.get(ResourceType.PROJECT);
        for (Resource resource : list) {
            result.add((ProjectResource)resource);
        }
        return result;
    }

    public boolean isWorkflowTemplateExists(String templateName) throws RegistryException {
        return this.isExists(ResourceType.USER_WORKFLOW, templateName);
    }

    public UserWorkflowResource createWorkflowTemplate(String templateName) throws RegistryException {
        UserWorkflowResource workflow = (UserWorkflowResource)this.create(ResourceType.USER_WORKFLOW);
        workflow.setName(templateName);
        return workflow;
    }

    public UserWorkflowResource getWorkflowTemplate(String templateName) throws RegistryException {
        return (UserWorkflowResource)this.get(ResourceType.USER_WORKFLOW, templateName);
    }

    public void removeWorkflowTemplate(String templateName) throws RegistryException {
        this.remove(ResourceType.USER_WORKFLOW, templateName);
    }

    public List<UserWorkflowResource> getWorkflowTemplates() throws RegistryException {
        ArrayList<UserWorkflowResource> result = new ArrayList<UserWorkflowResource>();
        List<Resource> list = this.get(ResourceType.USER_WORKFLOW);
        for (Resource resource : list) {
            result.add((UserWorkflowResource)resource);
        }
        return result;
    }

    public boolean isExperimentExists(String name) throws RegistryException {
        return this.isExists(ResourceType.EXPERIMENT, name);
    }

    public ExperimentResource getExperiment(String name) throws RegistryException {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, name);
    }

    public List<ExperimentResource> getExperiments() throws RegistryException {
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        List<Resource> list = this.get(ResourceType.EXPERIMENT);
        for (Resource resource : list) {
            result.add((ExperimentResource)resource);
        }
        return result;
    }

    public void removeExperiment(String experimentId) throws RegistryException {
        this.remove(ResourceType.EXPERIMENT, experimentId);
    }

    public List<ProjectResource> searchProjects(Map<String, String> filters) throws RegistryException {
        ArrayList<ProjectResource> result = new ArrayList<ProjectResource>();
        EntityManager em = null;
        try {
            String query = "SELECT p from Project p WHERE ";
            if (filters != null && filters.size() != 0) {
                for (String field : filters.keySet()) {
                    query = query + "p." + field + " LIKE '" + filters.get(field) + "%' AND ";
                }
            }
            query = query.substring(0, query.length() - 5);
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = em.createQuery(query);
            List resultList = q.getResultList();
            for (Object o : resultList) {
                Project project = (Project)o;
                ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                result.add(projectResource);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    public List<ExperimentResource> searchExperiments(Map<String, String> filters) throws RegistryException {
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        EntityManager em = null;
        try {
            String query = "SELECT e from Experiment e WHERE ";
            if (filters != null && filters.size() != 0) {
                for (String field : filters.keySet()) {
                    if (field.equals("executionUser")) {
                        query = query + "e." + field + "= '" + filters.get(field) + "' AND ";
                        continue;
                    }
                    query = query + "e." + field + " LIKE '%" + filters.get(field) + "%' AND ";
                }
            }
            query = query.substring(0, query.length() - 5);
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = em.createQuery(query);
            List resultList = q.getResultList();
            for (Object o : resultList) {
                Experiment experiment = (Experiment)o;
                ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                result.add(experimentResource);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }

    public List<ExperimentResource> getExperimentsByCaching(String user) throws RegistryException {
        ArrayList<ExperimentResource> result = new ArrayList<ExperimentResource>();
        EntityManager em = null;
        try {
            String query = "SELECT e from Experiment e WHERE e.executionUser = '" + user + "'";
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Query q = em.createQuery(query);
            List resultList = q.getResultList();
            for (Object o : resultList) {
                Experiment experiment = (Experiment)o;
                ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                result.add(experimentResource);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return result;
    }
}

