/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.ProjectUser;
import org.apache.airavata.persistance.registry.jpa.model.ProjectUser_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUserResource
extends AbstractResource {
    private String projectId;
    private String userName;
    private static final Logger logger = LoggerFactory.getLogger(ProjectUserResource.class);

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for project resource data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            ProjectUser existingPrUser = (ProjectUser)em.find(ProjectUser.class, (Object)new ProjectUser_PK(this.projectId, this.userName));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ProjectUser prUser = new ProjectUser();
            prUser.setProjectID(this.projectId);
            prUser.setUserName(this.userName);
            Users user = (Users)em.find(Users.class, (Object)this.userName);
            prUser.setUser(user);
            Project project = (Project)em.find(Project.class, (Object)this.projectId);
            prUser.setProject(project);
            if (existingPrUser != null) {
                existingPrUser.setProjectID(this.projectId);
                existingPrUser.setUserName(this.userName);
                existingPrUser.setUser(user);
                existingPrUser.setProject(project);
                prUser = (ProjectUser)em.merge((Object)existingPrUser);
            } else {
                em.persist((Object)prUser);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

