/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.NodeOutput;
import org.apache.airavata.persistance.registry.jpa.model.NodeOutput_PK;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeOutputResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(NodeOutputResource.class);
    private WorkflowNodeDetailResource nodeDetailResource;
    private String outputKey;
    private String outputType;
    private String metadata;
    private String value;

    public WorkflowNodeDetailResource getNodeDetailResource() {
        return this.nodeDetailResource;
    }

    public void setNodeDetailResource(WorkflowNodeDetailResource nodeDetailResource) {
        this.nodeDetailResource = nodeDetailResource;
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for node output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for node output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for node output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for node output data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            NodeOutput existingOutput = (NodeOutput)em.find(NodeOutput.class, (Object)new NodeOutput_PK(this.outputKey, this.nodeDetailResource.getNodeInstanceId()));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            NodeOutput nodeOutput = new NodeOutput();
            WorkflowNodeDetail nodeDetail = (WorkflowNodeDetail)em.find(WorkflowNodeDetail.class, (Object)this.nodeDetailResource.getNodeInstanceId());
            nodeOutput.setNode(nodeDetail);
            nodeOutput.setNodeId(nodeDetail.getNodeId());
            nodeOutput.setOutputKey(this.outputKey);
            nodeOutput.setOutputKeyType(this.outputType);
            nodeOutput.setValue(this.value);
            nodeOutput.setMetadata(this.metadata);
            if (existingOutput != null) {
                existingOutput.setNode(nodeDetail);
                existingOutput.setNodeId(nodeDetail.getNodeId());
                existingOutput.setOutputKey(this.outputKey);
                existingOutput.setOutputKeyType(this.outputType);
                existingOutput.setValue(this.value);
                existingOutput.setMetadata(this.metadata);
                nodeOutput = (NodeOutput)em.merge((Object)existingOutput);
            } else {
                em.persist((Object)nodeOutput);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

