/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Application_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.Gateway;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker;
import org.apache.airavata.persistance.registry.jpa.model.Gateway_Worker_PK;
import org.apache.airavata.persistance.registry.jpa.model.Host_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Host_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Project;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow;
import org.apache.airavata.persistance.registry.jpa.model.Published_Workflow_PK;
import org.apache.airavata.persistance.registry.jpa.model.Service_Descriptor;
import org.apache.airavata.persistance.registry.jpa.model.Service_Descriptor_PK;
import org.apache.airavata.persistance.registry.jpa.model.Users;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ApplicationDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.HostDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.ProjectResource;
import org.apache.airavata.persistance.registry.jpa.resources.PublishWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.ServiceDescriptorResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserResource;
import org.apache.airavata.persistance.registry.jpa.resources.UserWorkflowResource;
import org.apache.airavata.persistance.registry.jpa.resources.Utils;
import org.apache.airavata.persistance.registry.jpa.resources.WorkerResource;
import org.apache.airavata.persistance.registry.jpa.utils.QueryGenerator;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(GatewayResource.class);
    private String gatewayName;
    private String owner;

    public GatewayResource(String gatewayName) {
        this.setGatewayName(gatewayName);
    }

    public GatewayResource() {
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        switch (type) {
            case PROJECT: {
                ProjectResource projectResource = new ProjectResource();
                projectResource.setGateway(this);
                return projectResource;
            }
            case PUBLISHED_WORKFLOW: {
                PublishWorkflowResource publishWorkflowResource = new PublishWorkflowResource();
                publishWorkflowResource.setGateway(this);
                return publishWorkflowResource;
            }
            case USER_WORKFLOW: {
                UserWorkflowResource userWorkflowResource = new UserWorkflowResource();
                userWorkflowResource.setGateway(this);
                return userWorkflowResource;
            }
            case HOST_DESCRIPTOR: {
                HostDescriptorResource hostDescriptorResource = new HostDescriptorResource();
                hostDescriptorResource.setGatewayName(this.gatewayName);
                return hostDescriptorResource;
            }
            case SERVICE_DESCRIPTOR: {
                ServiceDescriptorResource serviceDescriptorResource = new ServiceDescriptorResource();
                serviceDescriptorResource.setGatewayName(this.gatewayName);
                return serviceDescriptorResource;
            }
            case APPLICATION_DESCRIPTOR: {
                ApplicationDescriptorResource applicationDescriptorResource = new ApplicationDescriptorResource();
                applicationDescriptorResource.setGatewayName(this.gatewayName);
                return applicationDescriptorResource;
            }
            case EXPERIMENT: {
                ExperimentResource experimentResource = new ExperimentResource();
                experimentResource.setGateway(this);
                return experimentResource;
            }
            case GATEWAY_WORKER: {
                WorkerResource workerResource = new WorkerResource();
                workerResource.setGateway(this);
                return workerResource;
            }
        }
        logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
        throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case USER: {
                    QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
                    generator.setParameter("user_name", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case PUBLISHED_WORKFLOW: {
                    QueryGenerator generator = new QueryGenerator("Published_Workflow", new Object[0][]);
                    generator.setParameter("publish_workflow_name", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case HOST_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Host_Descriptor", new Object[0][]);
                    generator.setParameter("host_descriptor_ID", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case SERVICE_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Service_Descriptor", new Object[0][]);
                    generator.setParameter("service_descriptor_ID", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                case APPLICATION_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Application_Descriptor", new Object[0][]);
                    generator.setParameter("application_descriptor_ID", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.deleteQuery(em);
                    q.executeUpdate();
                    break;
                }
                default: {
                    logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case GATEWAY_WORKER: {
                    QueryGenerator generator = new QueryGenerator("Gateway_Worker", new Object[0][]);
                    generator.setParameter("user_name", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    Gateway_Worker worker = (Gateway_Worker)q.getSingleResult();
                    WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, worker);
                    em.getTransaction().commit();
                    em.close();
                    WorkerResource workerResource2 = workerResource;
                    return workerResource2;
                }
                case USER: {
                    QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
                    generator.setParameter("user_name", name);
                    Query q = generator.selectQuery(em);
                    Users user = (Users)q.getSingleResult();
                    UserResource userResource = (UserResource)Utils.getResource(ResourceType.USER, user);
                    em.getTransaction().commit();
                    em.close();
                    UserResource userResource2 = userResource;
                    return userResource2;
                }
                case PUBLISHED_WORKFLOW: {
                    QueryGenerator generator = new QueryGenerator("Published_Workflow", new Object[0][]);
                    generator.setParameter("publish_workflow_name", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    Published_Workflow ePub_workflow = (Published_Workflow)q.getSingleResult();
                    PublishWorkflowResource publishWorkflowResource = (PublishWorkflowResource)Utils.getResource(ResourceType.PUBLISHED_WORKFLOW, ePub_workflow);
                    em.getTransaction().commit();
                    em.close();
                    PublishWorkflowResource publishWorkflowResource2 = publishWorkflowResource;
                    return publishWorkflowResource2;
                }
                case HOST_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Host_Descriptor", new Object[0][]);
                    generator.setParameter("host_descriptor_ID", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    Host_Descriptor eHostDesc = (Host_Descriptor)q.getSingleResult();
                    HostDescriptorResource hostDescriptorResource = (HostDescriptorResource)Utils.getResource(ResourceType.HOST_DESCRIPTOR, eHostDesc);
                    em.getTransaction().commit();
                    em.close();
                    HostDescriptorResource hostDescriptorResource2 = hostDescriptorResource;
                    return hostDescriptorResource2;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("expId", name);
                    Query q = generator.selectQuery(em);
                    Experiment experiment = (Experiment)q.getSingleResult();
                    ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                    em.getTransaction().commit();
                    em.close();
                    ExperimentResource experimentResource2 = experimentResource;
                    return experimentResource2;
                }
                case SERVICE_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Service_Descriptor", new Object[0][]);
                    generator.setParameter("service_descriptor_ID", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    Service_Descriptor eServiceDesc = (Service_Descriptor)q.getSingleResult();
                    ServiceDescriptorResource serviceDescriptorResource = (ServiceDescriptorResource)Utils.getResource(ResourceType.SERVICE_DESCRIPTOR, eServiceDesc);
                    em.getTransaction().commit();
                    em.close();
                    ServiceDescriptorResource serviceDescriptorResource2 = serviceDescriptorResource;
                    return serviceDescriptorResource2;
                }
                case APPLICATION_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Application_Descriptor", new Object[0][]);
                    generator.setParameter("application_descriptor_ID", name);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    Application_Descriptor eAppDesc = (Application_Descriptor)q.getSingleResult();
                    ApplicationDescriptorResource applicationDescriptorResource = (ApplicationDescriptorResource)Utils.getResource(ResourceType.APPLICATION_DESCRIPTOR, eAppDesc);
                    em.getTransaction().commit();
                    em.close();
                    ApplicationDescriptorResource applicationDescriptorResource2 = applicationDescriptorResource;
                    return applicationDescriptorResource2;
                }
            }
            try {
                em.getTransaction().commit();
                em.close();
                logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            switch (type) {
                case PROJECT: {
                    QueryGenerator generator = new QueryGenerator("Project", new Object[0][]);
                    Gateway gatewayModel = (Gateway)em.find(Gateway.class, (Object)this.gatewayName);
                    generator.setParameter("gateway", gatewayModel);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Project project = (Project)result;
                        ProjectResource projectResource = (ProjectResource)Utils.getResource(ResourceType.PROJECT, project);
                        resourceList.add(projectResource);
                    }
                    break;
                }
                case GATEWAY_WORKER: {
                    QueryGenerator generator = new QueryGenerator("Gateway_Worker", new Object[0][]);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Gateway_Worker gatewayWorker = (Gateway_Worker)result;
                        WorkerResource workerResource = (WorkerResource)Utils.getResource(ResourceType.GATEWAY_WORKER, gatewayWorker);
                        resourceList.add(workerResource);
                    }
                    break;
                }
                case PUBLISHED_WORKFLOW: {
                    QueryGenerator generator = new QueryGenerator("Published_Workflow", new Object[0][]);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Published_Workflow publishedWorkflow = (Published_Workflow)result;
                        PublishWorkflowResource publishWorkflowResource = (PublishWorkflowResource)Utils.getResource(ResourceType.PUBLISHED_WORKFLOW, publishedWorkflow);
                        resourceList.add(publishWorkflowResource);
                    }
                    break;
                }
                case HOST_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Host_Descriptor", new Object[0][]);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Host_Descriptor hostDescriptor = (Host_Descriptor)result;
                        HostDescriptorResource hostDescriptorResource = (HostDescriptorResource)Utils.getResource(ResourceType.HOST_DESCRIPTOR, hostDescriptor);
                        resourceList.add(hostDescriptorResource);
                    }
                    break;
                }
                case SERVICE_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Service_Descriptor", new Object[0][]);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Service_Descriptor serviceDescriptor = (Service_Descriptor)result;
                        ServiceDescriptorResource serviceDescriptorResource = (ServiceDescriptorResource)Utils.getResource(ResourceType.SERVICE_DESCRIPTOR, serviceDescriptor);
                        resourceList.add(serviceDescriptorResource);
                    }
                    break;
                }
                case APPLICATION_DESCRIPTOR: {
                    QueryGenerator generator = new QueryGenerator("Application_Descriptor", new Object[0][]);
                    generator.setParameter("gateway_name", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Application_Descriptor applicationDescriptor = (Application_Descriptor)result;
                        ApplicationDescriptorResource applicationDescriptorResource = (ApplicationDescriptorResource)Utils.getResource(ResourceType.APPLICATION_DESCRIPTOR, applicationDescriptor);
                        resourceList.add(applicationDescriptorResource);
                    }
                    break;
                }
                case EXPERIMENT: {
                    QueryGenerator generator = new QueryGenerator("Experiment", new Object[0][]);
                    generator.setParameter("gatewayName", this.gatewayName);
                    Query q = generator.selectQuery(em);
                    List results = q.getResultList();
                    if (results.size() == 0) break;
                    for (Object result : results) {
                        Experiment experiment = (Experiment)result;
                        ExperimentResource experimentResource = (ExperimentResource)Utils.getResource(ResourceType.EXPERIMENT, experiment);
                        resourceList.add(experimentResource);
                    }
                    break;
                }
                case USER: {
                    QueryGenerator generator = new QueryGenerator("Users", new Object[0][]);
                    Query q = generator.selectQuery(em);
                    for (Object o : q.getResultList()) {
                        Users user = (Users)o;
                        UserResource userResource = (UserResource)Utils.getResource(ResourceType.USER, user);
                        resourceList.add(userResource);
                    }
                    break;
                }
                default: {
                    em.getTransaction().commit();
                    em.close();
                    logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                    throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
                }
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceList;
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Gateway existingGateway = (Gateway)em.find(Gateway.class, (Object)this.gatewayName);
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Gateway gateway = new Gateway();
            gateway.setGateway_name(this.gatewayName);
            gateway.setOwner(this.owner);
            if (existingGateway != null) {
                existingGateway.setOwner(this.owner);
                gateway = (Gateway)em.merge((Object)existingGateway);
            } else {
                em.persist((Object)gateway);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) throws RegistryException {
        EntityManager em = null;
        try {
            switch (type) {
                case GATEWAY_WORKER: {
                    em = ResourceUtils.getEntityManager();
                    Gateway_Worker existingWorker = (Gateway_Worker)em.find(Gateway_Worker.class, (Object)new Gateway_Worker_PK(this.gatewayName, name.toString()));
                    em.close();
                    boolean bl = existingWorker != null;
                    return bl;
                }
                case USER: {
                    em = ResourceUtils.getEntityManager();
                    Users existingUser = (Users)em.find(Users.class, name);
                    em.close();
                    boolean bl = existingUser != null;
                    return bl;
                }
                case PUBLISHED_WORKFLOW: {
                    em = ResourceUtils.getEntityManager();
                    Published_Workflow existingWf = (Published_Workflow)em.find(Published_Workflow.class, (Object)new Published_Workflow_PK(this.gatewayName, name.toString()));
                    em.close();
                    boolean a = existingWf != null;
                    boolean bl = existingWf != null;
                    return bl;
                }
                case HOST_DESCRIPTOR: {
                    em = ResourceUtils.getEntityManager();
                    Host_Descriptor existingHostDesc = (Host_Descriptor)em.find(Host_Descriptor.class, (Object)new Host_Descriptor_PK(this.gatewayName, name.toString()));
                    em.close();
                    boolean bl = existingHostDesc != null;
                    return bl;
                }
                case SERVICE_DESCRIPTOR: {
                    em = ResourceUtils.getEntityManager();
                    Service_Descriptor existingServiceDesc = (Service_Descriptor)em.find(Service_Descriptor.class, (Object)new Service_Descriptor_PK(this.gatewayName, name.toString()));
                    em.close();
                    boolean bl = existingServiceDesc != null;
                    return bl;
                }
                case APPLICATION_DESCRIPTOR: {
                    em = ResourceUtils.getEntityManager();
                    Application_Descriptor existingAppDesc = (Application_Descriptor)em.find(Application_Descriptor.class, (Object)new Application_Descriptor_PK(this.gatewayName, name.toString()));
                    em.close();
                    boolean bl = existingAppDesc != null;
                    return bl;
                }
                case EXPERIMENT: {
                    em = ResourceUtils.getEntityManager();
                    Experiment existingExp = (Experiment)em.find(Experiment.class, (Object)name.toString());
                    em.close();
                    boolean bl = existingExp != null;
                    return bl;
                }
            }
            try {
                logger.error("Unsupported resource type for gateway resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported resource type for gateway resource.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RegistryException((Throwable)e);
            }
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public boolean isHostDescriptorExists(String descriptorName) throws RegistryException {
        return this.isExists(ResourceType.HOST_DESCRIPTOR, descriptorName);
    }

    public HostDescriptorResource createHostDescriptorResource(String hostDescriptorName) throws RegistryException {
        HostDescriptorResource hdr = (HostDescriptorResource)this.create(ResourceType.HOST_DESCRIPTOR);
        hdr.setHostDescName(hostDescriptorName);
        return hdr;
    }

    public HostDescriptorResource getHostDescriptorResource(String hostDescriptorName) throws RegistryException {
        return (HostDescriptorResource)this.get(ResourceType.HOST_DESCRIPTOR, hostDescriptorName);
    }

    public void removeHostDescriptor(String descriptorName) throws RegistryException {
        this.remove(ResourceType.HOST_DESCRIPTOR, descriptorName);
    }

    public List<HostDescriptorResource> getHostDescriptorResources() throws RegistryException {
        ArrayList<HostDescriptorResource> results = new ArrayList<HostDescriptorResource>();
        List<Resource> list = this.get(ResourceType.HOST_DESCRIPTOR);
        for (Resource resource : list) {
            results.add((HostDescriptorResource)resource);
        }
        return results;
    }

    public boolean isServiceDescriptorExists(String descriptorName) throws RegistryException {
        return this.isExists(ResourceType.SERVICE_DESCRIPTOR, descriptorName);
    }

    public ServiceDescriptorResource createServiceDescriptorResource(String descriptorName) throws RegistryException {
        ServiceDescriptorResource hdr = (ServiceDescriptorResource)this.create(ResourceType.SERVICE_DESCRIPTOR);
        hdr.setServiceDescName(descriptorName);
        return hdr;
    }

    public ServiceDescriptorResource getServiceDescriptorResource(String descriptorName) throws RegistryException {
        return (ServiceDescriptorResource)this.get(ResourceType.SERVICE_DESCRIPTOR, descriptorName);
    }

    public void removeServiceDescriptor(String descriptorName) throws RegistryException {
        this.remove(ResourceType.SERVICE_DESCRIPTOR, descriptorName);
    }

    public List<ServiceDescriptorResource> getServiceDescriptorResources() throws RegistryException {
        ArrayList<ServiceDescriptorResource> results = new ArrayList<ServiceDescriptorResource>();
        List<Resource> list = this.get(ResourceType.SERVICE_DESCRIPTOR);
        for (Resource resource : list) {
            results.add((ServiceDescriptorResource)resource);
        }
        return results;
    }

    public boolean isApplicationDescriptorExists(String descriptorName) throws RegistryException {
        return this.isExists(ResourceType.APPLICATION_DESCRIPTOR, descriptorName);
    }

    public ApplicationDescriptorResource createApplicationDescriptorResource(String descriptorName) throws RegistryException {
        ApplicationDescriptorResource hdr = (ApplicationDescriptorResource)this.create(ResourceType.APPLICATION_DESCRIPTOR);
        hdr.setName(descriptorName);
        return hdr;
    }

    public ApplicationDescriptorResource getApplicationDescriptorResource(String descriptorName) throws RegistryException {
        return (ApplicationDescriptorResource)this.get(ResourceType.APPLICATION_DESCRIPTOR, descriptorName);
    }

    public void removeApplicationDescriptor(String descriptorName) throws RegistryException {
        this.remove(ResourceType.APPLICATION_DESCRIPTOR, descriptorName);
    }

    public List<ApplicationDescriptorResource> getApplicationDescriptorResources() throws RegistryException {
        ArrayList<ApplicationDescriptorResource> results = new ArrayList<ApplicationDescriptorResource>();
        List<Resource> list = this.get(ResourceType.APPLICATION_DESCRIPTOR);
        for (Resource resource : list) {
            results.add((ApplicationDescriptorResource)resource);
        }
        return results;
    }

    public List<ApplicationDescriptorResource> getApplicationDescriptorResources(String serviceName, String hostName) throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            String qString = "SELECT p FROM Application_Descriptor p WHERE p.gateway_name =:gate_name";
            if (hostName != null) {
                qString = qString + " and p.host_descriptor_ID =:host_name";
            }
            if (serviceName != null) {
                qString = qString + " and p.service_descriptor_ID =:service_name";
            }
            Query q = em.createQuery(qString);
            q.setParameter("gate_name", (Object)this.gatewayName);
            if (serviceName != null) {
                q.setParameter("service_name", (Object)serviceName);
            }
            if (hostName != null) {
                q.setParameter("host_name", (Object)hostName);
            }
            List results = q.getResultList();
            ArrayList<ApplicationDescriptorResource> resourceList = new ArrayList<ApplicationDescriptorResource>();
            if (results.size() != 0) {
                for (Object result : results) {
                    Application_Descriptor applicationDescriptor = (Application_Descriptor)result;
                    ApplicationDescriptorResource applicationDescriptorResource = new ApplicationDescriptorResource(applicationDescriptor.getApplication_descriptor_ID(), applicationDescriptor.getGateway().getGateway_name());
                    applicationDescriptorResource.setContent(new String(applicationDescriptor.getApplication_descriptor_xml()));
                    applicationDescriptorResource.setUpdatedUser(applicationDescriptor.getUser().getUser_name());
                    applicationDescriptorResource.setHostDescName(applicationDescriptor.getHost_descriptor_ID());
                    applicationDescriptorResource.setServiceDescName(applicationDescriptor.getService_descriptor_ID());
                    resourceList.add(applicationDescriptorResource);
                }
            }
            em.getTransaction().commit();
            em.close();
            ArrayList<ApplicationDescriptorResource> arrayList = resourceList;
            return arrayList;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public boolean isPublishedWorkflowExists(String workflowTemplateName) throws RegistryException {
        return this.isExists(ResourceType.PUBLISHED_WORKFLOW, workflowTemplateName);
    }

    public PublishWorkflowResource createPublishedWorkflow(String workflowTemplateName) throws RegistryException {
        PublishWorkflowResource publishedWorkflowResource = (PublishWorkflowResource)this.create(ResourceType.PUBLISHED_WORKFLOW);
        publishedWorkflowResource.setName(workflowTemplateName);
        publishedWorkflowResource.setPath("/");
        publishedWorkflowResource.setVersion("1.0");
        return publishedWorkflowResource;
    }

    public PublishWorkflowResource getPublishedWorkflow(String workflowTemplateName) throws RegistryException {
        return (PublishWorkflowResource)this.get(ResourceType.PUBLISHED_WORKFLOW, workflowTemplateName);
    }

    public List<PublishWorkflowResource> getPublishedWorkflows() throws RegistryException {
        ArrayList<PublishWorkflowResource> result = new ArrayList<PublishWorkflowResource>();
        List<Resource> list = this.get(ResourceType.PUBLISHED_WORKFLOW);
        for (Resource resource : list) {
            result.add((PublishWorkflowResource)resource);
        }
        return result;
    }

    public void removePublishedWorkflow(String workflowTemplateName) throws RegistryException {
        this.remove(ResourceType.PUBLISHED_WORKFLOW, workflowTemplateName);
    }

    public ExperimentResource createExperiment(String experimentID) throws RegistryException {
        ExperimentResource metadataResource = (ExperimentResource)this.create(ResourceType.EXPERIMENT);
        metadataResource.setExpID(experimentID);
        return metadataResource;
    }

    public ExperimentResource getExperiment(String expId) throws RegistryException {
        return (ExperimentResource)this.get(ResourceType.EXPERIMENT, expId);
    }

    public List<ExperimentResource> getExperiments() throws RegistryException {
        ArrayList<ExperimentResource> experiments = new ArrayList<ExperimentResource>();
        List<Resource> resources = this.get(ResourceType.EXPERIMENT);
        for (Resource resource : resources) {
            experiments.add((ExperimentResource)resource);
        }
        return experiments;
    }
}

