/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.ErrorDetail;
import org.apache.airavata.persistance.registry.jpa.model.Experiment;
import org.apache.airavata.persistance.registry.jpa.model.TaskDetail;
import org.apache.airavata.persistance.registry.jpa.model.WorkflowNodeDetail;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.persistance.registry.jpa.resources.ExperimentResource;
import org.apache.airavata.persistance.registry.jpa.resources.TaskDetailResource;
import org.apache.airavata.persistance.registry.jpa.resources.WorkflowNodeDetailResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorDetailResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ErrorDetailResource.class);
    private int errorId;
    private ExperimentResource experimentResource;
    private TaskDetailResource taskDetailResource;
    private WorkflowNodeDetailResource nodeDetail;
    private Timestamp creationTime;
    private String actualErrorMsg;
    private String userFriendlyErrorMsg;
    private boolean transientPersistent;
    private String errorCategory;
    private String correctiveAction;
    private String actionableGroup;
    private String jobId;

    public int getErrorId() {
        return this.errorId;
    }

    public void setErrorId(int errorId) {
        this.errorId = errorId;
    }

    public Timestamp getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Timestamp creationTime) {
        this.creationTime = creationTime;
    }

    public String getActualErrorMsg() {
        return this.actualErrorMsg;
    }

    public void setActualErrorMsg(String actualErrorMsg) {
        this.actualErrorMsg = actualErrorMsg;
    }

    public String getUserFriendlyErrorMsg() {
        return this.userFriendlyErrorMsg;
    }

    public void setUserFriendlyErrorMsg(String userFriendlyErrorMsg) {
        this.userFriendlyErrorMsg = userFriendlyErrorMsg;
    }

    public boolean isTransientPersistent() {
        return this.transientPersistent;
    }

    public void setTransientPersistent(boolean transientPersistent) {
        this.transientPersistent = transientPersistent;
    }

    public String getErrorCategory() {
        return this.errorCategory;
    }

    public void setErrorCategory(String errorCategory) {
        this.errorCategory = errorCategory;
    }

    public String getCorrectiveAction() {
        return this.correctiveAction;
    }

    public void setCorrectiveAction(String correctiveAction) {
        this.correctiveAction = correctiveAction;
    }

    public String getActionableGroup() {
        return this.actionableGroup;
    }

    public void setActionableGroup(String actionableGroup) {
        this.actionableGroup = actionableGroup;
    }

    public ExperimentResource getExperimentResource() {
        return this.experimentResource;
    }

    public void setExperimentResource(ExperimentResource experimentResource) {
        this.experimentResource = experimentResource;
    }

    public TaskDetailResource getTaskDetailResource() {
        return this.taskDetailResource;
    }

    public void setTaskDetailResource(TaskDetailResource taskDetailResource) {
        this.taskDetailResource = taskDetailResource;
    }

    public WorkflowNodeDetailResource getNodeDetail() {
        return this.nodeDetail;
    }

    public void setNodeDetail(WorkflowNodeDetailResource nodeDetail) {
        this.nodeDetail = nodeDetail;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for error details data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for error details data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for error details data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for error details data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ErrorDetail errorDetail = new ErrorDetail();
            errorDetail.setErrorID(this.errorId);
            Experiment experiment = (Experiment)em.find(Experiment.class, (Object)this.experimentResource.getExpID());
            errorDetail.setExperiment(experiment);
            errorDetail.setExpId(this.experimentResource.getExpID());
            if (this.taskDetailResource != null) {
                TaskDetail taskDetail = (TaskDetail)em.find(TaskDetail.class, (Object)this.taskDetailResource.getTaskId());
                errorDetail.setTask(taskDetail);
                errorDetail.setTaskId(taskDetail.getTaskId());
            }
            if (this.nodeDetail != null) {
                WorkflowNodeDetail workflowNodeDetail = (WorkflowNodeDetail)em.find(WorkflowNodeDetail.class, (Object)this.nodeDetail.getNodeInstanceId());
                errorDetail.setNodeDetails(workflowNodeDetail);
                errorDetail.setNodeId(workflowNodeDetail.getNodeId());
            }
            errorDetail.setCreationTime(this.creationTime);
            errorDetail.setActualErrorMsg(this.actualErrorMsg.toCharArray());
            errorDetail.setUserFriendlyErrorMsg(this.userFriendlyErrorMsg);
            errorDetail.setTransientPersistent(this.transientPersistent);
            errorDetail.setErrorCategory(this.errorCategory);
            errorDetail.setCorrectiveAction(this.correctiveAction);
            errorDetail.setActionableGroup(this.actionableGroup);
            errorDetail.setJobId(this.jobId);
            em.persist((Object)errorDetail);
            this.errorId = errorDetail.getErrorID();
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

