/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.persistance.registry.jpa.resources;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.persistance.registry.jpa.Resource;
import org.apache.airavata.persistance.registry.jpa.ResourceType;
import org.apache.airavata.persistance.registry.jpa.ResourceUtils;
import org.apache.airavata.persistance.registry.jpa.model.Configuration;
import org.apache.airavata.persistance.registry.jpa.model.Configuration_PK;
import org.apache.airavata.persistance.registry.jpa.resources.AbstractResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationResource
extends AbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationResource.class);
    private String configKey;
    private String configVal;
    private Timestamp expireDate;
    private String categoryID = "SYSTEM";

    public ConfigurationResource() {
    }

    public ConfigurationResource(String configKey, String configVal) {
        this.configKey = configKey;
        this.configVal = configVal;
    }

    @Override
    public Resource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Resource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public void setExpireDate(Timestamp expireDate) {
        this.expireDate = expireDate;
    }

    @Override
    public synchronized void save() throws RegistryException {
        EntityManager em = null;
        try {
            em = ResourceUtils.getEntityManager();
            Configuration existing = (Configuration)em.find(Configuration.class, (Object)new Configuration_PK(this.configKey, this.configVal, this.categoryID));
            em.close();
            em = ResourceUtils.getEntityManager();
            em.getTransaction().begin();
            Configuration configuration = new Configuration();
            configuration.setConfig_key(this.configKey);
            configuration.setConfig_val(this.configVal);
            configuration.setExpire_date(this.expireDate);
            configuration.setCategory_id(this.categoryID);
            if (existing != null) {
                existing.setExpire_date(this.expireDate);
                existing.setCategory_id(this.categoryID);
                configuration = (Configuration)em.merge((Object)existing);
            } else {
                em.persist((Object)configuration);
            }
            em.getTransaction().commit();
            em.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(ResourceType type, Object name) {
        logger.error("Unsupported operation for configuration resource since there are no child resources generated by configuration resource.. ", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    public String getConfigVal() {
        return this.configVal;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public void setConfigVal(String configVal) {
        this.configVal = configVal;
    }

    public String getCategoryID() {
        return this.categoryID;
    }

    public void setCategoryID(String categoryID) {
        this.categoryID = categoryID;
    }
}

